/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.serialize.IDeserializer;
import com.ibm.team.repository.common.serialize.IPrimitiveHandler;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.util.NLS;

public abstract class Deserializer
implements IDeserializer {
    private static final IPrimitiveRegistry PrimitiveReg = IPrimitiveRegistry.INSTANCE;

    public Object deserializeString(String string, Class expectedType) throws SerializeException {
        IPrimitiveHandler primHandler = PrimitiveReg.getHandler(expectedType);
        if (primHandler == null) {
            String msg = NLS.bind((String)Messages.getServerString("Deserializer.UnknownPrimitiveType"), (Object)expectedType.getName(), (Object[])new Object[0]);
            throw new SerializeException(msg);
        }
        return primHandler.stringToObject(string);
    }
}

