/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IVirtual;
import com.ibm.team.repository.common.IVirtualType;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.serialize.IStackAdjuster;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.APPDeserializer;
import com.ibm.team.repository.common.serialize.internal.JSONDeserializer;
import com.ibm.team.repository.common.serialize.internal.UriSerializer;
import com.ibm.team.repository.common.serialize.internal.XMLDeserializer;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.util.NLS;
import java.io.Reader;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IDeserializer2 {
    public static final Factory FACTORY = new Factory(){

        public IDeserializer2 newInstance(HttpUtil.MediaType mType, IURISerializer uriSerializer) {
            if (uriSerializer == null) {
                uriSerializer = new UriSerializer();
            }
            if (mType == HttpUtil.MediaType.XML) {
                return new XMLDeserializer(mType, uriSerializer);
            }
            if (mType == HttpUtil.MediaType.JSON || mType == HttpUtil.MediaType.TEXT_PLAIN || mType == HttpUtil.MediaType.ANY) {
                return new JSONDeserializer(mType, uriSerializer);
            }
            if (mType == HttpUtil.MediaType.APP) {
                return new APPDeserializer(mType, uriSerializer);
            }
            String msg = NLS.bind((String)Messages.getServerString("IDeserializer2.UnknownMediaType"), (Object)mType, (Object[])new Object[0]);
            throw new UnsupportedOperationException(msg);
        }
    };

    public IItem deserializeNewItem(IItemType var1, Reader var2) throws SerializeException;

    public IItem deserializeWorkingCopy(IItem var1, Reader var2) throws SerializeException;

    public IItem deserializeItem(Reader var1) throws SerializeException;

    public List<IItem> deserializeItems(Reader var1) throws SerializeException;

    public IVirtual deserializeVirtual(Reader var1) throws SerializeException;

    public IVirtual deserializeVirtual(IVirtualType var1, Reader var2) throws SerializeException;

    public List<IVirtual> deserializeVirtuals(Reader var1) throws SerializeException;

    public List<IVirtual> deserializeVirtuals(IVirtualType var1, Reader var2) throws SerializeException;

    public HttpUtil.MediaType getMediaType();

    public Throwable deserializeException(Reader var1, ClassLoader var2, IStackAdjuster var3) throws SerializeException;

    public Object deserialize(EObject var1, Reader var2) throws SerializeException;

    public static interface Factory {
        public IDeserializer2 newInstance(HttpUtil.MediaType var1, IURISerializer var2);
    }
}

