/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.MarshallingExceptionReasonCode;
import com.ibm.team.repository.common.internal.marshal.impl.EObjectJSONMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.EObjectMarshaller;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.internal.services.DataArg;
import com.ibm.team.repository.common.transport.internal.services.DataArgType;
import com.ibm.team.repository.common.transport.internal.services.NullDataArg;
import com.ibm.team.repository.common.transport.internal.services.Request;
import com.ibm.team.repository.common.transport.internal.services.Response;
import com.ibm.team.repository.common.transport.internal.services.ServicesFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.xmlsoap.schemas.soap.envelope.Body;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.EnvelopeFactory;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class WebServicesMarshaller
extends EObjectMarshaller {
    private static final Class ITEM_CLASS = IItem.class;
    private static final Class ITEM_HANDLE_CLASS = IItemHandle.class;
    public static final WebServicesMarshaller INSTANCE = new WebServicesMarshaller();
    public static final String WEB_SERVICVES_MARSHALLER_REGISTRATION_NAME = "Web Services";
    public static final int MARSHAL_AS_XML = 0;
    public static final int MARSHAL_AS_JSON = 1;

    private WebServicesMarshaller() {
        this.setSupportedType(WebServicesMarshaller.class);
        this.setMarshallerType(MarshallerType.WEB_SERVICES_LITERAL);
    }

    public String getRegistrationName() {
        return WEB_SERVICVES_MARSHALLER_REGISTRATION_NAME;
    }

    public boolean canMarshal(Class type) {
        return type == this.supportedType;
    }

    protected void writeXMLHeader(OutputStream outputStream) {
    }

    public Request demarshalInputStreamToServiceRequest(InputStream inputStream) throws MarshallingException {
        return this.demarshalInputStreamToServiceRequest(inputStream, HttpUtil.CharsetEncoding.UTF8.toCharset());
    }

    public Request demarshalInputStreamToServiceRequest(InputStream inputStream, Charset charset) throws MarshallingException {
        if (charset == null) {
            throw new IllegalArgumentException("charset must not be null");
        }
        Envelope envelope = (Envelope)this.demarshalInputStreamToObject(inputStream, charset);
        if (envelope != null) {
            return envelope.getBody().getRequest();
        }
        return null;
    }

    public Response demarshalInputStreamToServiceResponse(InputStream inputStream) throws MarshallingException {
        return this.demarshalInputStreamToServiceResponse(inputStream, HttpUtil.CharsetEncoding.UTF8.toCharset());
    }

    public Response demarshalInputStreamToServiceResponse(InputStream inputStream, Charset charset) throws MarshallingException {
        if (charset == null) {
            throw new IllegalArgumentException("charset must not be null");
        }
        Envelope envelope = (Envelope)this.demarshalInputStreamToObject(inputStream, charset);
        if (envelope != null) {
            return envelope.getBody().getResponse();
        }
        return null;
    }

    public Envelope marshalServiceRequest(String methodName, String interfaceName, Class[] parameterTypes, Object[] parameters, int marshalType, OutputStream outputStream, Charset charset) throws MarshallingException {
        if (parameterTypes.length != parameters.length) {
            throw new IllegalArgumentException("types and objects are not the same length");
        }
        Request request = ServicesFactory.eINSTANCE.createRequest();
        if (methodName != null) {
            request.setMethod(methodName);
        }
        if (interfaceName != null) {
            request.setInterface(interfaceName);
        }
        request.setMethod(methodName);
        int i = 0;
        while (i < parameterTypes.length) {
            Object parameter = parameters[i];
            parameter = this.handleizeIfRequired(parameter, parameterTypes[i]);
            Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(parameterTypes[i]);
            if (marshaller == null) {
                marshaller = MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.EOBJECT_LITERAL);
            }
            DataArg dataArg = marshaller.marshalObjectToDataArg(parameter);
            request.getParameters().add((Object)dataArg);
            ++i;
        }
        Envelope envelope = EnvelopeFactory.eINSTANCE.createEnvelope();
        Body body = EnvelopeFactory.eINSTANCE.createBody();
        body.setRequest(request);
        envelope.setBody(body);
        this.marshalObjectToOutputStream(envelope, outputStream, marshalType, charset);
        return envelope;
    }

    @Deprecated
    public Envelope marshalServiceRequest(String methodName, String interfaceName, Class[] parameterTypes, Object[] parameters, int marshalType, OutputStream outputStream) throws MarshallingException {
        return this.marshalServiceRequest(methodName, interfaceName, parameterTypes, parameters, marshalType, outputStream, HttpUtil.CharsetEncoding.UTF8.toCharset());
    }

    public Envelope marshalServiceResponse(String methodName, String interfaceName, Class type, Object object, int marshalType, OutputStream outputStream, Charset charset) throws MarshallingException {
        Response response = ServicesFactory.eINSTANCE.createResponse();
        if (methodName != null) {
            response.setMethod(methodName);
        }
        if (interfaceName != null) {
            response.setInterface(interfaceName);
        }
        NullDataArg dataArg = null;
        if (object != null) {
            Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(type);
            if (marshaller == null) {
                marshaller = MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.EOBJECT_LITERAL);
            }
            dataArg = marshaller.marshalObjectToDataArg(object);
            response.setReturnValue((DataArg)dataArg);
        } else {
            dataArg = ServicesFactory.eINSTANCE.createNullDataArg();
            dataArg.setType(DataArgType.NULL_LITERAL);
            response.setReturnValue((DataArg)dataArg);
        }
        Body body = EnvelopeFactory.eINSTANCE.createBody();
        body.setResponse(response);
        Envelope envelope = EnvelopeFactory.eINSTANCE.createEnvelope();
        envelope.setBody(body);
        this.marshalObjectToOutputStream(envelope, outputStream, marshalType, charset);
        return envelope;
    }

    @Deprecated
    public Envelope marshalServiceResponse(String methodName, String interfaceName, Class type, Object object, int marshalType, OutputStream outputStream) throws MarshallingException {
        return this.marshalServiceResponse(methodName, interfaceName, type, object, marshalType, outputStream, HttpUtil.CharsetEncoding.UTF8.toCharset());
    }

    public Envelope marshalFaultServiceResponse(String methodName, String interfaceName, Throwable exception, int marshalType, OutputStream outputStream, Charset charset) {
        Response response = ServicesFactory.eINSTANCE.createResponse();
        if (methodName != null) {
            response.setMethod(methodName);
        }
        if (interfaceName != null) {
            response.setInterface(interfaceName);
        }
        Fault fault = EnvelopeFactory.eINSTANCE.createFault();
        fault.setFaultstring(MarshallerUtil.encodeExceptions(exception));
        this.populateExtraDataInfo(fault, exception);
        Body body = EnvelopeFactory.eINSTANCE.createBody();
        body.setResponse(response);
        body.setFault(fault);
        Envelope envelope = EnvelopeFactory.eINSTANCE.createEnvelope();
        envelope.setBody(body);
        try {
            this.marshalObjectToOutputStream(envelope, outputStream, marshalType, charset);
        }
        catch (MarshallingException marshallingException) {}
        return envelope;
    }

    private void populateExtraDataInfo(Fault fault, Throwable throwable) {
        TeamRepositoryException tre;
        Object exceptionData;
        PermissionDeniedException pde;
        Object processReportData;
        if (throwable instanceof PermissionDeniedException && (processReportData = (pde = (PermissionDeniedException)throwable).getProcessReportData()) != null && processReportData instanceof EObject) {
            fault.getExtraData().put((Object)"processReportData", (Object)((EObject)processReportData));
        }
        if (throwable instanceof TeamRepositoryException && (exceptionData = (tre = (TeamRepositoryException)throwable).getData()) != null && exceptionData instanceof EObject) {
            fault.getExtraData().put((Object)"exceptionData", (Object)((EObject)exceptionData));
        }
    }

    private void marshalObjectToOutputStream(Envelope envelope, OutputStream outputStream, int marshalType, Charset charset) throws MarshallingException {
        switch (marshalType) {
            case 0: {
                this.marshalObjectToOutputStream(envelope, outputStream, charset);
                break;
            }
            case 1: {
                EObjectJSONMarshaller eObjectJSONMarshaller = (EObjectJSONMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.JSON_LITERAL);
                eObjectJSONMarshaller.marshalObjectToOutputStream(envelope, outputStream, charset);
            }
        }
    }

    public Object[] getRequestParameters(Request request, Class[] parameterTypes) {
        return this.getMethodParameters((List)request.getParameters(), parameterTypes);
    }

    public Object getResponseReturnValue(Response response, Class parameterType) {
        return this.getReturnValue(response.getReturnValue(), parameterType);
    }

    public Object demarshalInputStreamToReturnValue(InputStream stream, Charset charset, Class type, int marshalType) throws MarshallingException {
        switch (marshalType) {
            case 1: {
                EObjectJSONMarshaller eObjectJSONMarshaller = (EObjectJSONMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.JSON_LITERAL);
                Object ret = eObjectJSONMarshaller.demarshalInputStreamToObject(stream, charset);
                if (!(ret instanceof Envelope)) {
                    throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, "Missing envelope");
                }
                Envelope envelope = (Envelope)ret;
                Body body = envelope.getBody();
                if (body == null) {
                    throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, "Missing envelope body");
                }
                Response response = body.getResponse();
                if (response == null) {
                    throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, "Missing body response");
                }
                return this.getResponseReturnValue(response, type);
            }
        }
        throw new IllegalArgumentException("Only know how to handle JSON");
    }

    private Object[] getMethodParameters(List dataArgParameters, Class[] parameterTypes) {
        Object[] parameters = new Object[parameterTypes.length];
        int i = 0;
        while (i < dataArgParameters.size()) {
            DataArg dataArg = (DataArg)dataArgParameters.get(i);
            parameters[i] = this.getMethodParameter(dataArg, parameterTypes[i]);
            ++i;
        }
        return parameters;
    }

    private Object getMethodParameter(DataArg dataArg, Class parameterType) {
        if (dataArg.getType().equals(DataArgType.NULL_LITERAL)) {
            return null;
        }
        Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(parameterType);
        if (marshaller == null) {
            marshaller = MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.EOBJECT_LITERAL);
        }
        return marshaller.demarshalDataArgToObject(dataArg, parameterType);
    }

    private Object getReturnValue(DataArg dataArg, Class parameterType) {
        if (dataArg.getType().equals(DataArgType.NULL_LITERAL)) {
            return null;
        }
        Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(parameterType);
        if (marshaller == null) {
            marshaller = MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.EOBJECT_LITERAL);
        }
        return marshaller.demarshalDataArgToObject(dataArg, parameterType);
    }

    private Object handleizeIfRequired(Object parameter, Class parameterType) {
        if (parameter == null) {
            return null;
        }
        if (parameterType.isArray()) {
            return this.handleizeArrayIfRequired(parameter, parameterType);
        }
        if (!ITEM_HANDLE_CLASS.isAssignableFrom(parameterType)) {
            return parameter;
        }
        if (ITEM_CLASS.isAssignableFrom(parameterType)) {
            return parameter;
        }
        ItemHandle itemHandle = (ItemHandle)parameter;
        if (!itemHandle.hasFullState()) {
            return parameter;
        }
        return ItemUtil.newItemHandle((ItemHandle)itemHandle, (boolean)true);
    }

    private Object handleizeArrayIfRequired(Object parameter, Class parameterType) {
        if (!ITEM_HANDLE_CLASS.isAssignableFrom(parameterType = parameterType.getComponentType())) {
            return parameter;
        }
        if (ITEM_CLASS.isAssignableFrom(parameterType)) {
            return parameter;
        }
        int length = Array.getLength(parameter);
        if (length == 0) {
            return parameter;
        }
        Object result = Array.newInstance(parameterType, length);
        int i = 0;
        while (i < length) {
            Object object = Array.get(parameter, i);
            object = this.handleizeIfRequired(object, parameterType);
            Array.set(result, i, object);
            ++i;
        }
        return result;
    }
}

