/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.MarshallingExceptionReasonCode;
import com.ibm.team.repository.common.internal.marshal.impl.AbstractEObjectMarshaller;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.internal.marshal.util.XMLConstructionUtil;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectJSONMarshaller
extends AbstractEObjectMarshaller {
    public static final String QUALIFIED_CLASS_NAME = "_eQualifiedClassName";
    public static final String ITEM_ID = "itemId";
    public static final String STATE_ID = "stateId";

    public EObjectJSONMarshaller() {
        super(EObjectJSONMarshaller.class, MarshallerType.JSON_LITERAL);
    }

    @Override
    @Deprecated
    public void marshalObjectToOutputStream(Object object, OutputStream outputStream) throws MarshallingException {
        this.marshalObjectToOutputStream(object, outputStream, HttpUtil.CharsetEncoding.UTF8.toCharset());
    }

    @Override
    public void marshalObjectToOutputStream(Object object, OutputStream outputStream, Charset charset) throws MarshallingException {
        if (charset == null) {
            charset = HttpUtil.CharsetEncoding.UTF8.toCharset();
        }
        Writer writer = null;
        try {
            writer = XMLConstructionUtil.createWriter(outputStream, charset);
        }
        catch (UnsupportedEncodingException e1) {
            throw new MarshallingException(e1);
        }
        this.marshalObject(object, writer);
    }

    private void marshalObject(Object object, Writer writer) throws MarshallingException {
        try {
            Object result = this.marshalObjectToJSON(object);
            if (result instanceof JSONObject) {
                ((JSONObject)result).serialize(writer);
            } else if (result instanceof JSONArray) {
                ((JSONArray)result).serialize(writer);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new MarshallingException(e);
        }
    }

    public Object marshalObjectToJSON(Object object) throws MarshallingException {
        if (object instanceof Collection) {
            return this.marshalObjectCollection((Collection)object);
        }
        EObject eObject = (EObject)object;
        JSONObject jsonObject = new JSONObject();
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        String qualifiedClassName = this.getQualifiedEClassName(eClass, ePackage.getNsURI());
        this.addAttributeToJSONObject(jsonObject, QUALIFIED_CLASS_NAME, qualifiedClassName);
        if (RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(eClass)) {
            this.addAttributeToJSONObject(jsonObject, "com.ibm.team.repository.typeName", ItemUtil.typeToName((IType)ItemUtil.itemTypeFor((EClass)eClass)));
        }
        this.marshalAttributes(eObject, eClass, jsonObject);
        this.marshalReferences(eObject, eClass, jsonObject);
        return jsonObject;
    }

    private Object marshalObjectCollection(Collection collection) throws MarshallingException {
        JSONArray jsonArray = new JSONArray();
        for (Object obj : collection) {
            if (!(obj instanceof EObject)) {
                String message = this.constructEObjectMarshallingOnlySupportedMessage(obj);
                throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, message);
            }
            jsonArray.add(this.marshalObjectToJSON(obj));
        }
        return jsonArray;
    }

    private String constructEObjectMarshallingOnlySupportedMessage(Object obj) {
        String message = MessageFormat.format("Only EObjects are supported as collection members.  Member is of type \"{1}\"", obj.getClass());
        return message;
    }

    protected void marshalAttributes(EObject eObject, EClass eClass, JSONObject jsonObject) throws MarshallingException {
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            if (!this.shouldBeMarshalled(eObject, (EStructuralFeature)attribute)) continue;
            this.marshalAttribute(eObject, attribute, jsonObject);
        }
    }

    protected void marshalAttribute(EObject eObject, EAttribute attribute, JSONObject jsonObject) throws MarshallingException {
        if (attribute.isMany()) {
            this.marshalManyValuedAttribute(eObject, attribute, jsonObject);
        } else {
            Object attributeValue = this.serializeEAttributeValue2(eObject, attribute);
            this.addAttributeToJSONObject(jsonObject, attribute.getName(), attributeValue);
        }
    }

    protected Object serializeEAttributeValue2(EObject eObject, EAttribute attribute) throws MarshallingException {
        Object objectValue = eObject.eGet((EStructuralFeature)attribute);
        if (objectValue == null) {
            return null;
        }
        Class classZ = attribute.getEType().getInstanceClass();
        Object attributeValue = null;
        if (classZ == null) {
            attributeValue = this.getStringValueUsingFactory(eObject, attribute, objectValue);
        } else {
            Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(classZ);
            if (marshaller != null) {
                attributeValue = marshaller.marshalAttributeValue(objectValue);
            } else if (attribute.getEType().getName().equals(Object.class.getSimpleName())) {
                attributeValue = this.getStringValueUsingFactory(eObject, attribute, objectValue);
            } else {
                String message = this.createCannotMarshalAttributeMessage(eObject, attribute);
                throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_MARSHAL_LITERAL, message);
            }
        }
        return attributeValue;
    }

    private void marshalManyValuedAttribute(EObject eObject, EAttribute attribute, JSONObject jsonObject) throws MarshallingException {
        Object objectValue = eObject.eGet((EStructuralFeature)attribute);
        if (objectValue == null) {
            this.addAttributeToJSONObject(jsonObject, attribute.getName(), null);
            return;
        }
        Class classZ = attribute.getEType().getInstanceClass();
        Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(classZ);
        if (objectValue instanceof List) {
            JSONArray jsonArray = new JSONArray();
            for (Object attributeValue : (List)objectValue) {
                if (classZ == FeatureMap.Entry.class) continue;
                Object value = null;
                if (attributeValue != null) {
                    value = marshaller.marshalAttributeValue(attributeValue);
                }
                jsonArray.add(value);
            }
            this.addAttributeToJSONObject(jsonObject, attribute.getName(), jsonArray);
        }
    }

    protected void marshalReferences(EObject eObject, EClass eClass, JSONObject jsonObject) throws MarshallingException {
        for (EReference reference : eClass.getEAllReferences()) {
            if (!MarshallerUtil.shouldBeMarshalled(eObject, (EStructuralFeature)reference)) continue;
            if (MarshallerUtil.shouldConsiderAsContainment(reference)) {
                this.marshalContainmentReferences(eObject, reference, jsonObject);
                continue;
            }
            this.marshalAssociationReferences(eObject, reference, jsonObject);
        }
    }

    private void marshalAssociationReferences(EObject eObject, EReference reference, JSONObject jsonObject) throws MarshallingException {
        if (reference.isMany()) {
            this.marshalMultiValuedAssociationReferences(eObject, reference, jsonObject);
        } else {
            this.marshalSingleValuedAssociationReference(eObject, reference, jsonObject);
        }
    }

    private void marshalSingleValuedAssociationReference(EObject eObject, EReference reference, JSONObject jsonObject) throws MarshallingException {
        if (!this.marshalEClassifiersUsingHREFs(eObject, reference, jsonObject)) {
            Object objectValue = eObject.eGet((EStructuralFeature)reference);
            if (objectValue == null) {
                this.addAttributeToJSONObject(jsonObject, reference.getName(), null);
            } else if (objectValue instanceof ItemHandle) {
                JSONObject referenceJSONObject = this.marshalItemHandleAssociationReference((ItemHandle)objectValue);
                this.addAttributeToJSONObject(jsonObject, reference.getName(), referenceJSONObject);
            }
        }
    }

    private boolean marshalEClassifiersUsingHREFs(EObject eObject, EReference reference, JSONObject jsonObject) throws MarshallingException {
        if (reference.getEReferenceType().equals(EcorePackage.eINSTANCE.getEDataType()) || reference.getEReferenceType().equals(EcorePackage.eINSTANCE.getEClass()) || reference.getEReferenceType().equals(EcorePackage.eINSTANCE.getEEnum())) {
            String hrefURI = this.createHREFs(eObject, reference);
            this.addAttributeToJSONObject(jsonObject, reference.getName(), hrefURI);
            return true;
        }
        return false;
    }

    private void marshalMultiValuedAssociationReferences(EObject eObject, EReference reference, JSONObject jsonObject) throws MarshallingException {
        List objectValues = (List)eObject.eGet((EStructuralFeature)reference);
        if (objectValues == null) {
            this.addAttributeToJSONObject(jsonObject, reference.getName(), null);
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (Object objectValue : objectValues) {
            if (objectValue == null || !(objectValue instanceof ItemHandle)) continue;
            JSONObject referenceJSONObject = this.marshalItemHandleAssociationReference((ItemHandle)objectValue);
            jsonArray.add((Object)referenceJSONObject);
        }
        this.addAttributeToJSONObject(jsonObject, reference.getName(), jsonArray);
    }

    protected JSONObject marshalItemHandleAssociationReference(ItemHandle itemHandle) throws MarshallingException {
        JSONObject referenceJSONObject = new JSONObject();
        UUID itemId = itemHandle.getItemId();
        UUID stateId = itemHandle.getStateId();
        String qualifiedNameOfInstance = this.getQualifiedEClassName((EObject)itemHandle);
        this.addAttributeToJSONObject(referenceJSONObject, QUALIFIED_CLASS_NAME, qualifiedNameOfInstance);
        this.addAttributeToJSONObject(referenceJSONObject, "com.ibm.team.repository.typeName", ItemUtil.typeToName((IType)itemHandle.getItemType()));
        if (itemId != null) {
            this.addAttributeToJSONObject(referenceJSONObject, ITEM_ID, itemId.getUuidValue());
        }
        if (stateId != null) {
            this.addAttributeToJSONObject(referenceJSONObject, STATE_ID, stateId.getUuidValue());
        }
        return referenceJSONObject;
    }

    private void marshalContainmentReferences(EObject eObject, EReference reference, JSONObject jsonObject) throws MarshallingException {
        if (reference.isMany()) {
            this.marshalMultiValuedContainmentReferences(eObject, reference, jsonObject);
        } else {
            this.marshalSingleValuedContainmentReference(eObject, reference, jsonObject);
        }
    }

    private void marshalSingleValuedContainmentReference(EObject eObject, EReference reference, JSONObject jsonObject) throws MarshallingException {
        Object objectValue = eObject.eGet((EStructuralFeature)reference);
        if (objectValue == null) {
            this.addAttributeToJSONObject(jsonObject, this.getReferenceName((EObject)objectValue, (EStructuralFeature)reference), null);
            return;
        }
        if (this.marshalEClassifiersUsingHREFs(eObject, reference, jsonObject)) {
            return;
        }
        Object containedJSONObject = this.marshalObjectToJSON(objectValue);
        this.addAttributeToJSONObject(jsonObject, this.getReferenceName((EObject)objectValue, (EStructuralFeature)reference), containedJSONObject);
    }

    private void marshalMultiValuedContainmentReferences(EObject eObject, EReference reference, JSONObject jsonObject) throws MarshallingException {
        List objectValues = (List)eObject.eGet((EStructuralFeature)reference);
        if (objectValues == null) {
            this.addAttributeToJSONObject(jsonObject, reference.getName(), null);
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (Object object : objectValues) {
            EObject eObjectValue = (EObject)object;
            Object containedObject = this.marshalObjectToJSON(eObjectValue);
            jsonArray.add(containedObject);
        }
        this.addAttributeToJSONObject(jsonObject, reference.getName(), jsonArray);
    }

    @Override
    public String marshalObjectToString(Object object) throws MarshallingException {
        return this.marshalObjectToJSON(object).toString();
    }

    @Override
    public Object demarshalInputStreamToObject(InputStream inputStream) throws MarshallingException {
        InputStreamReader reader = this.createInputStreamReader(inputStream, null);
        return this.demarshalInputStream(reader);
    }

    @Override
    public Object demarshalInputStreamToObject(InputStream inputStream, Charset charset) throws MarshallingException {
        InputStreamReader reader = this.createInputStreamReader(inputStream, charset);
        return this.demarshalInputStream(reader);
    }

    private Object demarshalInputStream(InputStreamReader reader) throws MarshallingException {
        Object obj = null;
        try {
            obj = JSONObject.parseAny((Reader)reader);
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.getServerString("EObjectJSONMarshaller.ParseError"), (Object)"JSON Object", (Object[])new Object[]{e.getMessage()});
            throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, msg, e);
        }
        if (obj instanceof JSONObject) {
            return this.objToItem((JSONObject)obj);
        }
        if (obj instanceof JSONArray) {
            return this.objsToItem((JSONArray)obj);
        }
        String msg = NLS.bind((String)Messages.getServerString("EObjectJSONMarshaller.UnsupportedTypeInStream"), (Object)"JSON Object", (Object[])new Object[]{obj.getClass()});
        throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, msg);
    }

    private Collection objsToItem(JSONArray objs) throws MarshallingException {
        ArrayList<EObject> retVal = new ArrayList<EObject>(objs.size());
        for (Object obj : objs) {
            if (!(obj instanceof JSONObject)) {
                String msg = NLS.bind((String)Messages.getServerString("EObjectJSONMarshaller.UnsupportedTypeInArray"), (Object)"JSON object", (Object[])new Object[]{"JSON array", obj.getClass()});
                throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, msg);
            }
            retVal.add(this.objToItem((JSONObject)obj));
        }
        return retVal;
    }

    private EObject objToItem(JSONObject obj) throws MarshallingException {
        if (obj == null) {
            throw new IllegalArgumentException("Object must not be null");
        }
        return this.convertJSONToEObject(obj);
    }

    private EObject convertJSONToEObject(JSONObject obj) throws MarshallingException {
        String qualifiedClassName = (String)obj.get((Object)QUALIFIED_CLASS_NAME);
        String namespaceURI = this.getNamespaceURI(qualifiedClassName);
        String typeName = this.getTypeName(qualifiedClassName);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(namespaceURI);
        if (ePackage == null) {
            throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorMissingPackage"), (Object)namespaceURI, (Object[])new Object[0]));
        }
        EClass eClass = (EClass)ePackage.getEClassifier(typeName);
        EObject eObject = ePackage.getEFactoryInstance().create(eClass);
        Map<String, EStructuralFeature> attributeMappings = this.generateAttributeMappings(eObject);
        for (Object keyObject : obj.keySet()) {
            String key = (String)keyObject;
            if (key.equals("com.ibm.team.repository.typeName") || key.equals(QUALIFIED_CLASS_NAME)) continue;
            this.fillEObjectFromJSON(eObject, attributeMappings.get(key), obj.get((Object)key));
        }
        return eObject;
    }

    private Map<String, EStructuralFeature> generateAttributeMappings(EObject object) {
        HashMap<String, EStructuralFeature> result = new HashMap<String, EStructuralFeature>();
        for (EStructuralFeature f : object.eClass().getEAllStructuralFeatures()) {
            result.put(this.getReferenceName(object, f), f);
        }
        return result;
    }

    private String getNamespaceURI(String qualifiedClassName) {
        int index = qualifiedClassName.lastIndexOf(":");
        return qualifiedClassName.substring(0, index);
    }

    private String getTypeName(String qualifiedClassName) {
        int index = qualifiedClassName.lastIndexOf(":");
        return qualifiedClassName.substring(index + 1);
    }

    private void fillEObjectFromJSON(EObject eObject, EStructuralFeature feature, Object attrValue) throws MarshallingException {
        if (feature == null) {
            throw new IllegalArgumentException("Attribute name must not be null");
        }
        if (this.isImmutableFeature(feature)) {
            return;
        }
        if (attrValue == null) {
            eObject.eSet(feature, null);
            return;
        }
        if (feature instanceof EAttribute) {
            if (feature.isMany()) {
                JSONArray jArray = (JSONArray)attrValue;
                ArrayList<Object> list = new ArrayList<Object>(jArray.size());
                int i = 0;
                while (i < jArray.size()) {
                    Object obj = jArray.get(i);
                    list.add(obj);
                    ++i;
                }
                eObject.eSet(feature, list);
            } else {
                EDataType dataType = ((EAttribute)feature).getEAttributeType();
                EFactory eFactory = dataType.getEPackage().getEFactoryInstance();
                Object obj = eFactory.createFromString(dataType, attrValue.toString());
                eObject.eSet(feature, obj);
            }
        } else if (feature instanceof EReference) {
            if (feature.isMany()) {
                JSONArray jArray = (JSONArray)attrValue;
                ArrayList<EObject> list = new ArrayList<EObject>(jArray.size());
                int i = 0;
                while (i < jArray.size()) {
                    JSONObject obj = (JSONObject)jArray.get(i);
                    EObject ref = this.convertJSONToEObject(obj);
                    list.add(ref);
                    ++i;
                }
                eObject.eSet(feature, list);
            } else {
                EObject ref = this.convertJSONToEObject((JSONObject)attrValue);
                eObject.eSet(feature, (Object)ref);
            }
        } else {
            String msg = NLS.bind((String)Messages.getServerString("EObjectJSONMarshaller.UnexpectedFeatureType"), (Object)feature.getName(), (Object[])new Object[0]);
            throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, msg);
        }
    }

    private boolean isImmutableFeature(EStructuralFeature feature) {
        return feature.equals(RepositoryPackage.eINSTANCE.getItemHandle_Immutable());
    }

    private InputStreamReader createInputStreamReader(InputStream inputStream, Charset charset) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        InputStreamReader reader = null;
        reader = charset != null ? new InputStreamReader(inputStream, charset) : new InputStreamReader(inputStream);
        return reader;
    }

    private void addAttributeToJSONObject(JSONObject jsonObject, String key, Object value) throws MarshallingException {
        jsonObject.put((Object)key, value);
    }
}

