/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal.content;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.content.ScmClientUtil;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class MonitoredOutputStream
extends OutputStream {
    private final SubMonitor monitor;
    private final long estimatedBytes;
    private long writtenBytes;
    private boolean cancellable;
    private final OutputStream out;
    private final String estimatedBytesHumanReadable;

    public MonitoredOutputStream(OutputStream out, long estimatedBytes, IProgressMonitor monitor) {
        this.out = out;
        this.estimatedBytes = estimatedBytes;
        this.cancellable = true;
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        this.estimatedBytesHumanReadable = ScmClientUtil.bytesAsHumanReadable(estimatedBytes);
    }

    public void write(int b) throws IOException {
        this.cancelIfRequested();
        this.out.write(b);
        this.advance(1L);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.cancelIfRequested();
        this.out.write(buffer, offset, length);
        this.advance(length);
    }

    public void flush() throws IOException {
        this.cancelIfRequested();
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
        this.cancelIfRequested();
        this.monitor.subTask("");
        this.monitor.done();
    }

    public void setIsCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private void cancelIfRequested() {
        if (this.cancellable && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void advance(long count) {
        int oldPercent = (int)(this.writtenBytes * 1000L / this.estimatedBytes);
        this.writtenBytes += count;
        int newPercent = (int)(this.writtenBytes * 1000L / this.estimatedBytes);
        this.monitor.worked(newPercent - oldPercent);
        String msg = NLS.bind((String)Messages.MonitoredOutputStream_TransferStatus, (Object)ScmClientUtil.bytesAsHumanReadable(this.writtenBytes), (Object[])new Object[]{this.estimatedBytesHumanReadable});
        this.monitor.subTask(msg);
    }
}

