/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.StateLocator;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.FetchProfile;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoFetcher {
    public static <T extends IItem> Map<StateLocator<T>, T> fetchItems(Collection<StateLocator<T>> states, FetchProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)states.size());
        HashMap result = NewCollection.hashMap();
        HashMap organisedByRepository = NewCollection.hashMap();
        for (StateLocator<T> next : states) {
            RepoFetcher.addToMapOfLists(organisedByRepository, next.getRepository(), next.getStateId());
        }
        for (ITeamRepository repo : organisedByRepository.keySet()) {
            List toFetch = (List)organisedByRepository.get(repo);
            Map<StateId<T>, T> fetched = RepoFetcher.fetchItems(repo, toFetch, profile, (IProgressMonitor)progress.newChild(states.size()));
            for (Map.Entry<StateId<T>, T> next : fetched.entrySet()) {
                StateId<T> nextKey = next.getKey();
                result.put(new StateLocator(repo, nextKey.getItemType(), nextKey.getItemUUID(), nextKey.getStateUUID()), (IItem)next.getValue());
            }
        }
        return result;
    }

    private static <K, V> void addToMapOfLists(Map<K, List<V>> map, K key, V value) {
        ArrayList currentList = map.get(key);
        if (currentList == null) {
            currentList = NewCollection.arrayList();
            map.put(key, currentList);
        }
        currentList.add(value);
    }

    public static <T extends IItem> Map<StateId<T>, T> fetchItems(ITeamRepository server, Collection<StateId<T>> states, FetchProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        RepoFetcher.checkCanceled((IProgressMonitor)progress);
        ArrayList<StateId<T>> auditables = new ArrayList<StateId<T>>();
        ArrayList<StateId<T>> versionables = new ArrayList<StateId<T>>();
        for (StateId<T> next : states) {
            IItemType nextType = next.getItemType();
            if (nextType.isAuditable()) {
                auditables.add(next);
                continue;
            }
            if (!nextType.isUnmanaged()) continue;
            versionables.add(next);
        }
        ArrayList result = new ArrayList();
        List auditableHandlesToFetch = ItemLists.statesToHandles(auditables);
        List versionableHandlesToFetch = ItemLists.statesToHandles(versionables);
        progress.setWorkRemaining(auditableHandlesToFetch.size() + versionableHandlesToFetch.size());
        if (!auditableHandlesToFetch.isEmpty()) {
            SubMonitor fetchProgress = progress.newChild(auditables.size());
            RepoFetcher.checkCanceled((IProgressMonitor)fetchProgress);
            IItemManager itemManager = server.itemManager();
            List fetchedAuditables = profile.isFull() ? itemManager.fetchCompleteStates(auditableHandlesToFetch, (IProgressMonitor)fetchProgress) : itemManager.fetchPartialStates(auditableHandlesToFetch, profile.getProperties(), (IProgressMonitor)fetchProgress);
            result.addAll(fetchedAuditables);
        }
        if (!versionableHandlesToFetch.isEmpty()) {
            IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager(server).versionableManager();
            SubMonitor fetchProgress = progress.newChild(versionables.size());
            RepoFetcher.checkCanceled((IProgressMonitor)fetchProgress);
            List fetchedVersionables = profile.isFull() ? versionableManager.fetchCompleteStates(versionableHandlesToFetch, (IProgressMonitor)fetchProgress) : versionableManager.fetchPartialStates(versionableHandlesToFetch, profile.getProperties(), (IProgressMonitor)fetchProgress);
            result.addAll(fetchedVersionables);
        }
        HashMap resultMap = NewCollection.hashMap();
        for (Object next : result) {
            IItem tNext = (IItem)next;
            if (tNext == null) continue;
            resultMap.put(StateId.forItem((IItem)tNext), tNext);
        }
        return resultMap;
    }

    public static <T extends IItem> Map<StateId<T>, T> fetchItems(ITeamRepository server, Collection<StateId<T>> states, IProgressMonitor monitor) throws TeamRepositoryException {
        return RepoFetcher.fetchItems(server, states, FetchProfile.createFullProfile(), monitor);
    }

    public static <T extends IItem> T fetchItem(ITeamRepository server, StateId<T> state, IProgressMonitor rep) throws ItemNotFoundException, TeamRepositoryException {
        return (T)((IItem)RepoFetcher.getItem(RepoFetcher.fetchItems(server, Collections.singletonList(state), rep), state));
    }

    public static <T extends IItem> T fetchItem(ITeamRepository server, StateId<T> state, FetchProfile profile, IProgressMonitor rep) throws TeamRepositoryException {
        return (T)((IItem)RepoFetcher.getItem(RepoFetcher.fetchItems(server, Collections.singletonList(state), profile, rep), state));
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(ITeamRepository repo, Collection<ItemId<T>> items, boolean refresh, FetchProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        List handles = ItemLists.idsToHandles(items);
        RepoFetcher.checkCanceled(monitor);
        if (handles.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = NewCollection.hashMap();
        int flags = refresh ? 1 : 0;
        List fetched = profile.isFull() ? repo.itemManager().fetchCompleteItems(handles, flags, monitor) : repo.itemManager().fetchPartialItems(handles, flags, profile.getProperties(), monitor);
        for (IItem next : fetched) {
            if (next == null) continue;
            result.put(new ItemId((IItemHandle)next), next);
        }
        return result;
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(ITeamRepository repo, Collection<ItemId<T>> items, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return RepoFetcher.fetchCurrents(repo, items, refresh, FetchProfile.createFullProfile(), monitor);
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(ITeamRepository repo, Collection<ItemId<T>> items, IProgressMonitor monitor) throws TeamRepositoryException {
        return RepoFetcher.fetchCurrents(repo, items, FetchProfile.createFullProfile(), monitor);
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(ITeamRepository repo, IProgressMonitor monitor, ItemId ... items) throws TeamRepositoryException {
        ArrayList<ItemId<T>> toFetch = new ArrayList<ItemId<T>>(items.length);
        ItemId[] itemIdArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ItemId next = itemIdArray[n2];
            toFetch.add(next);
            ++n2;
        }
        return RepoFetcher.fetchCurrents(repo, toFetch, monitor);
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(ITeamRepository repo, Collection<ItemId<T>> items, FetchProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return RepoFetcher.fetchCurrents(repo, items, false, profile, monitor);
    }

    public static <T extends IItem> T fetchCurrent(ITeamRepository repo, ItemId<T> item, FetchProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return (T)((IItem)RepoFetcher.getItem(RepoFetcher.fetchCurrents(repo, Collections.singletonList(item), profile, monitor), item));
    }

    public static <T extends IItem> T fetchCurrent(ITeamRepository repository, ItemId<T> toFetch, boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return (T)((IItem)RepoFetcher.getItem(RepoFetcher.fetchCurrents(repository, Collections.singletonList(toFetch), needsRefresh, FetchProfile.createFullProfile(), monitor), toFetch));
    }

    public static <T extends IItem> T fetchCurrent(ITeamRepository repo, ItemId<T> item, IProgressMonitor monitor) throws TeamRepositoryException {
        return RepoFetcher.fetchCurrent(repo, item, FetchProfile.createFullProfile(), monitor);
    }

    public static <K, V> V getItem(Map<K, V> map, K key) throws ItemNotFoundException {
        V result = map.get(key);
        if (result == null) {
            IItemHandle handle = null;
            if (key != null) {
                if (key instanceof IItemHandle) {
                    handle = (IItemHandle)key;
                } else if (key instanceof ItemId) {
                    ItemId itemId = (ItemId)key;
                    handle = itemId.toHandle();
                } else if (key instanceof StateId) {
                    StateId stateId = (StateId)key;
                    handle = stateId.toHandle();
                }
            }
            if (handle != null) {
                throw new ItemNotFoundException(handle);
            }
            throw new ItemNotFoundException(String.valueOf(key));
        }
        return result;
    }

    private static void checkCanceled(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException(Messages.RepoFetcher_0);
        }
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(IConfiguration configuration, Collection<ItemId<T>> items, FetchProfile profile, boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        if (items.isEmpty() || configuration == null) {
            return Collections.EMPTY_MAP;
        }
        RepoFetcher.checkCanceled(monitor);
        List handles = ItemLists.idsToHandles(items);
        HashMap result = NewCollection.hashMap();
        try {
            List fetched = profile.isFull() ? configuration.fetchCompleteItems(handles, monitor) : configuration.fetchPartialItems(handles, profile.getProperties(), monitor);
            for (IItem next : fetched) {
                if (next == null) continue;
                result.put(new ItemId((IItemHandle)next), next);
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return Collections.emptyMap();
        }
        return result;
    }

    public static <T extends IItem> Map<ItemId<T>, StateId<T>> fetchStateIds(IConfiguration configuration, Collection<ItemId<T>> itemIds, boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemIds.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        SubMonitor rep = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        RepoFetcher.checkCanceled((IProgressMonitor)rep);
        Map<ItemId<T>, T> itemMap = RepoFetcher.fetchCurrents(configuration, itemIds, shouldRefresh, (IProgressMonitor)rep.newChild(1));
        ArrayList items = NewCollection.arrayList();
        items.addAll(itemMap.values());
        HashMap itemStates = NewCollection.hashMap();
        for (ItemId<T> itemId : itemIds) {
            IItem item = (IItem)itemMap.get(itemId);
            if (item == null) {
                itemStates.put(itemId, new StateId(itemId, StateId.STATE_DELETED));
                continue;
            }
            if (!(item instanceof IVersionable)) continue;
            itemStates.put(itemId, new StateId((IItemHandle)((IVersionable)item)));
        }
        return itemStates;
    }

    public static <T extends IItem> Map<ItemId<T>, T> fetchCurrents(IConfiguration configuration, Collection<ItemId<T>> items, boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return RepoFetcher.fetchCurrents(configuration, items, FetchProfile.createFullProfile(), shouldRefresh, monitor);
    }

    public static Map<StateLocator<IVersionable>, IVersionable> fetchItems(Set<StateLocator<IVersionable>> toFetch, IProgressMonitor monitor) throws TeamRepositoryException {
        return RepoFetcher.fetchItems(toFetch, FetchProfile.createFullProfile(), monitor);
    }
}

