/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.internal.dto.RemoteRepoDescriptor;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class RemoteRepoDescriptorTask
extends AbstractQueuedSynchronizer {
    private static final long serialVersionUID = 9054822264172263405L;
    private static final int NEVER_RAN = 0;
    private static final int RUNNING = 1;
    private static final int RAN = 2;
    protected final WorkspaceManager wm;
    protected volatile RemoteRepoDescriptor desc;
    protected Thread fetcher;

    public RemoteRepoDescriptorTask(WorkspaceManager wm) {
        this.wm = wm;
    }

    public void reset() {
        this.compareAndSetState(2, 0);
    }

    public RemoteRepoDescriptor getIfNotFetching(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.tryAcquireShared(0) < 0) {
            return null;
        }
        return this.getDescAfterAcquire(monitor);
    }

    public RemoteRepoDescriptor get(IProgressMonitor monitor) throws TeamRepositoryException {
        RemoteRepoDescriptor result;
        while (true) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                if (!this.tryAcquireSharedNanos(0, 100000L)) {
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
            result = this.getDescAfterAcquire(monitor);
            if (result != null) break;
        }
        return result;
    }

    protected RemoteRepoDescriptor getDescAfterAcquire(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fetcher != Thread.currentThread()) {
            RemoteRepoDescriptor result = this.desc;
            if (result.getAuthToken().getUserid().equals(this.wm.teamRepository().loggedInContributor().getUserId())) {
                return result;
            }
            if (!this.compareAndSetState(2, 1)) {
                return null;
            }
        }
        boolean success = false;
        try {
            RemoteRepoDescriptor result;
            this.desc = result = this.wm.fetchRepoDescriptor(monitor);
            success = true;
            RemoteRepoDescriptor remoteRepoDescriptor = result;
            return remoteRepoDescriptor;
        }
        finally {
            if (success) {
                this.releaseShared(2);
            } else {
                this.releaseShared(0);
            }
        }
    }

    protected int tryAcquireShared(int arg) {
        block5: while (true) {
            int state = this.getState();
            switch (state) {
                case 0: {
                    if (!this.compareAndSetState(0, 1)) continue block5;
                    this.fetcher = Thread.currentThread();
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 1: {
                    return -1;
                }
            }
        }
    }

    protected boolean tryReleaseShared(int arg) {
        this.fetcher = null;
        this.setState(arg);
        return true;
    }
}

