/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChangeSetTracker {
    private Map<UUID, IChangeSetHandle> changeSets = new LinkedHashMap<UUID, IChangeSetHandle>();
    private Map<UUID, Map<UUID, IChangeSetHandle>> byComponents = new HashMap<UUID, Map<UUID, IChangeSetHandle>>();

    ChangeSetTracker() {
    }

    public List<IChangeSetHandle> getChangeSets() {
        return Collections.unmodifiableList(new ArrayList<IChangeSetHandle>(this.changeSets.values()));
    }

    public Map<UUID, Map<UUID, IChangeSetHandle>> getMap() {
        return this.byComponents;
    }

    public List<IChangeSetHandle> getByComponent(IComponentHandle component) {
        Map<UUID, IChangeSetHandle> subMap = this.byComponents.get(component.getItemId());
        if (subMap == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(new ArrayList<IChangeSetHandle>(subMap.values()));
    }

    public void addChangeSet(IComponentHandle component, IChangeSetHandle changeSet) {
        UUID csItemId = changeSet.getItemId();
        this.changeSets.put(csItemId, changeSet);
        UUID compItemId = component.getItemId();
        Map<UUID, IChangeSetHandle> subMap = this.byComponents.get(compItemId);
        if (subMap == null) {
            subMap = new LinkedHashMap<UUID, IChangeSetHandle>();
            this.byComponents.put(compItemId, subMap);
        }
        subMap.put(csItemId, changeSet);
    }

    public void removeChangeSets(List<IChangeSetHandle> changeSets, Set<UUID> staleComponents) {
        HashSet<UUID> staleIds = new HashSet<UUID>((int)((double)this.changeSets.size() / 0.75));
        for (UUID compId : staleComponents) {
            Map<UUID, IChangeSetHandle> byComponent = this.byComponents.get(compId);
            if (byComponent == null) continue;
            staleIds.addAll(byComponent.keySet());
        }
        for (IChangeSetHandle cs : changeSets) {
            if (staleIds.contains(cs.getItemId())) continue;
            this.removeChangeSet(cs);
        }
    }

    public void removeChangeSet(IChangeSetHandle changeSet) {
        UUID csItemId = changeSet.getItemId();
        this.changeSets.remove(csItemId);
        Iterator<Map<UUID, IChangeSetHandle>> it = this.byComponents.values().iterator();
        while (it.hasNext()) {
            Map<UUID, IChangeSetHandle> subMap = it.next();
            if (subMap.remove(csItemId) == null) continue;
            if (!subMap.isEmpty()) break;
            it.remove();
            break;
        }
    }

    protected IChangeSetHandle createStateHandle(IChangeSet cs) {
        return (IChangeSetHandle)cs.getItemType().createItemHandle(cs.getItemId(), cs.getStateId());
    }
}

