/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.scm.client.internal.ChangeSetTracker;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshResult;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetClientCache {
    private Map<IComponentHandle, IChangeSetHandle> currentChangeSets = new TreeMap<IComponentHandle, IChangeSetHandle>(ItemUtil.itemIdComparator);
    protected ChangeSetTracker activeTracker = new ChangeSetTracker();
    public static final IChangeSetHandle CURRENT_UNSET = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.generate(), null);

    public void updateCaches(WorkspaceRefreshResult refreshedData, Map<IComponentHandle, IChangeSetHandle> newCurrents, Set<UUID> staleComponents) {
        this.activeTracker.removeChangeSets(refreshedData.getActiveRemoved(), staleComponents);
        for (IChangeSet changeSet : refreshedData.getActiveChangeSets()) {
            if (staleComponents.contains(changeSet.getComponent().getItemId())) continue;
            this.activeTracker.addChangeSet(changeSet.getComponent(), (IChangeSetHandle)changeSet.getStateHandle());
        }
        this.updateCurrents(newCurrents);
    }

    private void updateCurrents(Map<IComponentHandle, IChangeSetHandle> newCurrents) {
        for (Map.Entry<IComponentHandle, IChangeSetHandle> entry : newCurrents.entrySet()) {
            IComponentHandle key = entry.getKey();
            if (entry.getValue() == CURRENT_UNSET) {
                this.currentChangeSets.remove(key);
                continue;
            }
            this.currentChangeSets.put(key, (IChangeSetHandle)EcoreUtil.copy((EObject)((EObject)entry.getValue())));
        }
    }

    public IComponentHandle getComponent(IChangeSetHandle cs) {
        for (Map.Entry<IComponentHandle, IChangeSetHandle> entry : this.currentChangeSets.entrySet()) {
            if (!entry.getValue().sameItemId((IItemHandle)cs)) continue;
            return entry.getKey();
        }
        for (Map.Entry<Object, Object> entry : this.activeTracker.getMap().entrySet()) {
            for (IChangeSetHandle csh : ((Map)entry.getValue()).values()) {
                if (!csh.sameItemId((IItemHandle)cs)) continue;
                return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((UUID)entry.getKey(), null);
            }
        }
        return null;
    }

    public List<IChangeSetHandle> getActiveChangeSets() {
        return this.activeTracker.getChangeSets();
    }

    public List<IChangeSetHandle> getActiveChangeSetsByComponent(IComponentHandle component) {
        return this.activeTracker.getByComponent(component);
    }

    public void addActiveChangeSet(IComponentHandle component, IChangeSetHandle changeSet) {
        this.activeTracker.addChangeSet(component, changeSet);
    }

    public IChangeSetHandle getCurrentChangeSet(IComponentHandle component) {
        return this.currentChangeSets.get(component);
    }

    public Map<IComponentHandle, IChangeSetHandle> getCurrentChangeSets() {
        return this.currentChangeSets;
    }

    public void setCurrentChangeSet(IComponentHandle component, IChangeSetHandle changeSet) {
        this.currentChangeSets.put(component, changeSet);
    }

    public void unsetCurrentChangeSet(IComponentHandle component) {
        this.currentChangeSets.put(component, null);
    }

    public IComponentHandle removeCurrent(IChangeSetHandle changeSet) {
        for (Map.Entry<IComponentHandle, IChangeSetHandle> entry : this.currentChangeSets.entrySet()) {
            if (!changeSet.sameItemId((IItemHandle)entry.getValue())) continue;
            entry.setValue(null);
            return entry.getKey();
        }
        return null;
    }
}

