/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IHistoricBaselineIterator;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.internal.dto.BaselinesInHistoryResult;
import com.ibm.team.scm.common.internal.dto.ServiceHistoryProvider;
import com.ibm.team.scm.common.internal.dto.SynchronizationInfo;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaselinesInHistoryIterator
implements IHistoricBaselineIterator {
    private final List<? extends IBaselineHandle> baselines;
    private final boolean hasPrevious;
    private final WorkspaceManager workspaceManager;

    public BaselinesInHistoryIterator(BaselinesInHistoryResult result, WorkspaceManager workspaceManager) {
        this.baselines = Collections.unmodifiableList(result.getBaselines());
        this.hasPrevious = !result.isFinished();
        this.workspaceManager = workspaceManager;
    }

    @Override
    public List<? extends IBaselineHandle> getBaselines() {
        return this.baselines;
    }

    @Override
    public IHistoricBaselineIterator getPrevious(int max, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getPrevious(max, null, monitor);
    }

    public IHistoricBaselineIterator getPrevious(int max, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        if (max < 1) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        IScmService service = this.workspaceManager.getServerConfigurationService();
        monitor.worked(5);
        SCMClientUtil.checkMonitor(monitor);
        BaselinesInHistoryResult result = service.getBaselinesInHistory(ServiceHistoryProvider.FACTORY.create(this.baselines.get(this.baselines.size() - 1)), max, BaselinesInHistoryIterator.getSyncTimes(syncInfo), BaselinesInHistoryIterator.monitorFor(monitor));
        monitor.worked(90);
        SCMClientUtil.checkMonitor(monitor);
        monitor.done();
        return new BaselinesInHistoryIterator(result, this.workspaceManager);
    }

    @Override
    public boolean hasPrevious() {
        return this.hasPrevious;
    }

    private static ISynchronizationTimes[] getSyncTimes(ISynchronizationInfo syncInfo) {
        if (syncInfo == null) {
            return null;
        }
        return ((SynchronizationInfo)syncInfo).getSyncTimes();
    }

    private static IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }
}

