/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.content;

import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedOutputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ConnectionUtil;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.serialize.IDeserializer2;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.ITeamServer;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.transport.client.ClientHttpUtil;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import com.ibm.team.repository.transport.client.ReleasingAndAbortingInputStream;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.BasicAsyncVersionedContentManagerSession;
import com.ibm.team.scm.client.content.BasicSynchronousVersionedContentManagerSession;
import com.ibm.team.scm.client.content.util.VersionedContentManagerByteArrayInputStreamPovider;
import com.ibm.team.scm.client.internal.content.BufferedRequestEntity;
import com.ibm.team.scm.client.internal.content.MonitoredInputStream;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IVersionedContent;
import com.ibm.team.scm.common.IVersionedContentService;
import com.ibm.team.scm.common.internal.ScmFactory;
import com.ibm.team.scm.common.internal.VersionedContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicVersionedContentManager<StoreContext, RetrieveContext, SessionType> {
    protected static final InvocationHandler fakeInvocationHandler = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            throw new UnsupportedOperationException();
        }
    };
    protected static final Method fetchMethod;
    protected static final Method storeMethod;
    protected static final Method getCleanupPeriodMethod;
    private static volatile int maxSimultaneousDownloads;
    protected final ITeamServer server;
    protected final IClientLibraryContext ctx;
    protected final Object serviceDelegate;

    static {
        try {
            fetchMethod = IVersionedContentService.class.getDeclaredMethod("fetchContent", new Class[0]);
            storeMethod = IVersionedContentService.class.getDeclaredMethod("storeContent", new Class[0]);
            getCleanupPeriodMethod = IVersionedContentService.class.getDeclaredMethod("getCleanupPeriod", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        maxSimultaneousDownloads = 10;
    }

    protected ClassLoader getClassLoaderForProxy(final Class proxyClass) {
        return new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return this.loadClass(name, proxyClass);
            }

            /*
             * Unable to fully structure code
             */
            private Class<?> loadClass(String name, Class<?> cl) throws ClassNotFoundException {
                try {
                    return cl.getClassLoader().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                    var7_6 = cl.getInterfaces();
                    var6_7 = var7_6.length;
                    var5_8 = 0;
                    ** while (var5_8 < var6_7)
                }
lbl-1000:
                // 1 sources

                {
                    c = var7_6[var5_8];
                    try {
                        return this.loadClass(name, c);
                    }
                    catch (ClassNotFoundException v0) {
                        ++var5_8;
                    }
                    continue;
                }
lbl15:
                // 1 sources

                throw ex;
            }
        };
    }

    protected ITeamServer getTeamServer(IClientLibraryContext context) {
        try {
            Field f = context.teamRepository().getClass().getDeclaredField("teamServer");
            f.setAccessible(true);
            return (ITeamServer)f.get(context.teamRepository());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected BasicVersionedContentManager(IClientLibraryContext context) {
        try {
            this.ctx = context;
            this.server = this.getTeamServer(context);
            this.serviceDelegate = Proxy.newProxyInstance(this.getClassLoaderForProxy(IVersionedContentService.class), new Class[]{IVersionedContentService.class}, fakeInvocationHandler);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new RuntimeException("This version of java will not work with Jazz Source Control. Please upgrade your JVM to the most recent available version.");
        }
    }

    protected InputStream wrapInputStreamForUpload(InputStream in, StoreContext context) throws TeamRepositoryException, IOException {
        return in;
    }

    protected ITeamRepository teamRepository() {
        return this.ctx.teamRepository();
    }

    protected StreamLengthUtility getStreamLengthUtility(InputStream in, StoreContext context) {
        return new StreamLengthUtility(in, context);
    }

    /*
     * Loose catch block
     */
    protected IVersionedContent storeContent(AbstractVersionedContentManagerInputStreamProvider streamProvider, ContentHash predecessorHintHash, final StoreContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionedContent iVersionedContent;
        InputStream in;
        StreamLengthUtility slu;
        block34: {
            AbstractVersionedContentManagerInputStreamProvider storeProvider;
            AbstractVersionedContentManagerInputStreamProvider wrapped;
            if (streamProvider == null) {
                throw new IllegalArgumentException();
            }
            slu = null;
            in = streamProvider.getInputStream(1);
            slu = this.getStreamLengthUtility(in, context);
            slu.run();
            long length = slu.getStreamLength();
            ContentHash hash = slu.getContentHashCode();
            in.close();
            in = null;
            byte[] bytes = slu.getInputBytes();
            if (bytes != null) {
                wrapped = streamProvider;
                storeProvider = new VersionedContentManagerByteArrayInputStreamPovider(bytes, 0, (int)length){

                    public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                        return wrapped.wrapInputStream(in);
                    }
                };
            } else {
                wrapped = streamProvider;
                storeProvider = new AbstractVersionedContentManagerInputStreamProvider(){

                    public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                        return wrapped.getInputStream(flags);
                    }

                    public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                        in = BasicVersionedContentManager.this.wrapInputStreamForUpload(in, context);
                        return wrapped.wrapInputStream(in);
                    }

                    public void dispose() throws IOException, TeamRepositoryException {
                    }
                };
            }
            IVersionedContent result = this.internalStoreContent(storeProvider, length, predecessorHintHash, hash, context, monitor);
            slu.cleanup();
            slu = null;
            streamProvider.dispose();
            streamProvider = null;
            iVersionedContent = result;
            try {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                finally {
                    if (slu != null) {
                        slu.cleanup();
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (TeamRepositoryException teamRepositoryException) {}
            if (streamProvider == null) break block34;
            try {
                streamProvider.dispose();
            }
            catch (TeamRepositoryException teamRepositoryException) {
            }
            catch (IOException iOException) {}
        }
        return iVersionedContent;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            finally {
                                if (slu != null) {
                                    slu.cleanup();
                                }
                            }
                        }
                        catch (IOException iOException) {
                        }
                        catch (TeamRepositoryException teamRepositoryException) {}
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new TeamRepositoryException((Object)this.teamRepository(), e.getMessage(), (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    if (streamProvider != null) {
                        try {
                            streamProvider.dispose();
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable2;
                }
            }
        }
    }

    protected URI getStoreURI(AbstractVersionedContentManagerInputStreamProvider in, long length, ContentHash predecessorHintHash, ContentHash contentHashCode, StoreContext context) throws TeamRepositoryException {
        try {
            URI uri = new URI(this.server.getRepositoryURL());
            String queryParms = "hashcode=" + contentHashCode.toString();
            if (predecessorHintHash != null) {
                queryParms = String.valueOf(queryParms) + "&predecessorHintHash=" + predecessorHintHash.toString();
            }
            if (length > Integer.MAX_VALUE) {
                queryParms = String.valueOf(queryParms) + "&length=" + Long.toString(length);
            }
            String path = String.valueOf(uri.getPath()) + "service" + "/" + IVersionedContentService.class.getName() + "/" + "content";
            String existingQuery = uri.getQuery();
            if (existingQuery != null && existingQuery.trim().length() != 0) {
                queryParms = String.valueOf(existingQuery.trim()) + '&' + queryParms;
            }
            uri = new URI(null, null, path, queryParms, uri.getFragment());
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), e1.getMessage(), (Throwable)e1);
        }
    }

    protected String getContentType(AbstractVersionedContentManagerInputStreamProvider in, long length, ContentHash predecessorHintHash, ContentHash hash, URI uri, StoreContext context) {
        return "application/octet-stream";
    }

    protected void invokeContentPut(AbstractVersionedContentManagerInputStreamProvider in, long length, ContentHash predecessorHintHash, ContentHash hash, URI uri, StoreContext context) throws TeamRepositoryException {
        PutMethod method = new PutMethod();
        BufferedRequestEntity requestEntity = new BufferedRequestEntity(in, length, this.getContentType(in, length, predecessorHintHash, hash, uri, context), 16384, (HttpMethod)method);
        method.setRequestEntity((RequestEntity)requestEntity);
        this.addContentStoreHeaders(method, in, length, predecessorHintHash, hash, uri, context);
        try {
            int result = this.executeMethod((HttpMethod)method);
            if (result != 201) {
                throw new TeamRepositoryException("Unexpected result code: " + result);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    protected int executeMethod(HttpMethod method) throws TeamRepositoryException {
        TeamServiceCallContextImpl.setUpCall((HttpMethod)method);
        try {
            int code = ClientHttpUtil.executeHttpMethod((RemoteTeamServer)((RemoteTeamServer)this.server), null, (HttpMethod)method, (boolean)false, (boolean)true);
            if (code == 404) {
                Throwable t = this.deserializeException(method);
                if (!(t instanceof TeamRepositoryException)) {
                    throw new TeamRepositoryException(t);
                }
                throw (TeamRepositoryException)t;
            }
            int n = code;
            return n;
        }
        catch (TeamServiceException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw e;
            }
            try {
                cause = this.deserializeException(method);
            }
            catch (Exception ex) {
                cause = ex;
            }
            try {
                e.initCause(cause);
            }
            catch (RuntimeException runtimeException) {}
            throw e;
        }
        catch (IOException e) {
            throw new TeamServiceException(e.getMessage());
        }
        finally {
            TeamServiceCallContextImpl.tearDownCall();
        }
    }

    protected Throwable deserializeException(HttpMethod method) throws TeamRepositoryException {
        InputStreamReader r;
        try {
            r = new InputStreamReader(method.getResponseBodyAsStream(), HttpUtil.CharsetEncoding.UTF8.toCharset());
        }
        catch (IOException e) {
            throw new TeamRepositoryException("Couldn't create stream from response body.", (Throwable)e);
        }
        try {
            return IDeserializer2.FACTORY.newInstance(HttpUtil.MediaType.JSON, null).deserializeException((Reader)r, this.getClass().getClassLoader(), null);
        }
        catch (SerializeException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    protected void addContentStoreHeaders(PutMethod put, AbstractVersionedContentManagerInputStreamProvider in, long length, ContentHash predecessorHintHash, ContentHash hash, URI uri, StoreContext context) throws TeamRepositoryException {
        if (length > Integer.MAX_VALUE) {
            put.setContentChunked(true);
        } else {
            put.addRequestHeader("Content-Length", Long.toString(length));
        }
        put.addRequestHeader("Content-Type", this.getContentType(in, length, predecessorHintHash, hash, uri, context));
        put.setDoAuthentication(true);
        put.setPath(uri.toString());
        put.setRequestHeader("http.useragent", this.getClass().getName());
        put.setRequestHeader("Accept", HttpUtil.MediaType.JSON.toString());
        put.setRequestHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        this.addServiceVersionHeaderForStore((HttpMethod)put, context);
        BasicVersionedContentManager.setAcceptLanguageHeader((HttpMethod)put);
        this.setUseridHeader((HttpMethod)put);
    }

    protected void addServiceVersionHeaderForStore(HttpMethod method, StoreContext ctx) {
        this.addServiceVersionHeader(method, IVersionedContentService.class.getName());
    }

    protected void addServiceVersionHeader(HttpMethod method, String serviceName) {
        ITeamService teamService = this.server.getServiceByName(serviceName);
        if (teamService == null) {
            return;
        }
        String version = teamService.getVersion();
        if (version != null && version.length() > 0) {
            method.addRequestHeader("X-com-ibm-team-service-version", version);
        }
    }

    protected long getCleanupPeriod(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final URI uri = this.getRetrieveCleanupPeriodURI();
        try {
            long l = (Long)this.ctx.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Long>(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Long run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    Long l;
                    long start = System.currentTimeMillis();
                    Method method = BasicVersionedContentManager.this.getCleanupPeriodMethodForStatistics();
                    Object delegate = BasicVersionedContentManager.this.getCleanupPeriodDelegateForStatistics();
                    BasicVersionedContentManager.this.preInvoke();
                    boolean success = false;
                    boolean connectionError = false;
                    try {
                        l = BasicVersionedContentManager.this.invokeGetCleanupPeriod(uri);
                    }
                    catch (TeamRepositoryException e) {
                        try {
                            connectionError = BasicVersionedContentManager.this.onServiceError((Exception)((Object)e));
                            throw e;
                            catch (RuntimeException e2) {
                                connectionError = BasicVersionedContentManager.this.onServiceError(e2);
                                throw e2;
                            }
                        }
                        catch (Throwable throwable) {
                            BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, delegate);
                            throw throwable;
                        }
                    }
                    BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, delegate);
                    return l;
                }
            }, (IProgressMonitor)progress.newChild(100));
            return l;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected URI getRetrieveCleanupPeriodURI() throws TeamRepositoryException {
        try {
            URI uri = new URI(this.server.getRepositoryURL());
            String path = String.valueOf(uri.getPath()) + "service" + "/" + IVersionedContentService.class.getName() + "/" + "cleanupPeriod";
            uri = new URI(null, null, path, uri.getQuery(), uri.getFragment());
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), e1.getMessage(), (Throwable)e1);
        }
    }

    protected Method getCleanupPeriodMethodForStatistics() {
        return getCleanupPeriodMethod;
    }

    protected Object getCleanupPeriodDelegateForStatistics() {
        return this.serviceDelegate;
    }

    protected long invokeGetCleanupPeriod(URI uri) throws TeamRepositoryException {
        GetMethod method = new GetMethod();
        this.addGetCleanupPeriodHeaders(method, uri);
        try {
            int read;
            int result = this.executeMethod((HttpMethod)method);
            if (result != 200) {
                throw new TeamRepositoryException("Unexpected result code: " + result);
            }
            long len = method.getResponseContentLength();
            if (len >= 256L) {
                throw new TeamRepositoryException("Response too long: " + len);
            }
            byte[] buffer = len >= 0L ? new byte[(int)len + 1] : new byte[256];
            InputStream in = method.getResponseBodyAsStream();
            if (in == null) {
                throw new TeamRepositoryException("Expected a response");
            }
            int pos = 0;
            while ((read = in.read(buffer, pos, buffer.length - pos)) != -1) {
                if ((pos += read) != buffer.length) continue;
                throw new TeamRepositoryException("Response too long");
            }
            in.close();
            try {
                String response = Charset.forName(method.getResponseCharSet()).decode(ByteBuffer.wrap(buffer, 0, pos)).toString();
                long l = Long.valueOf(response);
                return l;
            }
            catch (RuntimeException e) {
                try {
                    throw new TeamRepositoryException("Bad response", (Throwable)e);
                }
                catch (IOException e2) {
                    throw new TeamRepositoryException((Throwable)e2);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    protected void addGetCleanupPeriodHeaders(GetMethod get, URI uri) throws TeamRepositoryException {
        get.setDoAuthentication(true);
        get.setPath(uri.toString());
        get.setRequestHeader("http.useragent", this.getClass().getName());
        get.setRequestHeader("Accept", HttpUtil.MediaType.JSON.toString());
        get.addRequestHeader("Accept", HttpUtil.MediaType.ANY.toString());
        get.setRequestHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        this.addServiceVersionHeaderForGetCleanupPeriod((HttpMethod)get);
        BasicVersionedContentManager.setAcceptLanguageHeader((HttpMethod)get);
        this.setUseridHeader((HttpMethod)get);
    }

    protected void addServiceVersionHeaderForGetCleanupPeriod(HttpMethod method) {
        this.addServiceVersionHeader(method, IVersionedContentService.class.getName());
    }

    protected IVersionedContent internalStoreContent(final AbstractVersionedContentManagerInputStreamProvider in, final long length, final ContentHash predecessorHintHash, final ContentHash contentHashCode, final StoreContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            final URI uri = this.getStoreURI(in, length, predecessorHintHash, contentHashCode, context);
            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            SubMonitor cancellationChild = progress.newChild(0);
            final AbstractVersionedContentManagerInputStreamProvider provider = new AbstractVersionedContentManagerInputStreamProvider(){

                public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                    return in.getInputStream(flags);
                }

                public void dispose() throws IOException, TeamRepositoryException {
                }

                public InputStream wrapInputStream(InputStream stream) throws IOException, TeamRepositoryException {
                    progress.setWorkRemaining(100);
                    return new MonitoredInputStream(in.wrapInputStream(stream), length, (IProgressMonitor)progress.newChild(100));
                }
            };
            this.ctx.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public ITeamRestServiceClient.IRestClientConnection.Response run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    long start = System.currentTimeMillis();
                    Method method = BasicVersionedContentManager.this.getStoreMethodForStatistics(length, predecessorHintHash, contentHashCode, context);
                    Object delegate = BasicVersionedContentManager.this.getStoreDelegateForStatistics(length, predecessorHintHash, contentHashCode, context);
                    BasicVersionedContentManager.this.preInvoke();
                    boolean success = false;
                    boolean connectionError = false;
                    try {
                        BasicVersionedContentManager.this.invokeContentPut(provider, length, predecessorHintHash, contentHashCode, uri, context);
                    }
                    catch (TeamRepositoryException e) {
                        try {
                            connectionError = BasicVersionedContentManager.this.onServiceError((Exception)((Object)e));
                            throw e;
                            catch (RuntimeException e2) {
                                connectionError = BasicVersionedContentManager.this.onServiceError(e2);
                                throw e2;
                            }
                        }
                        catch (Throwable throwable) {
                            BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, delegate);
                            throw throwable;
                        }
                    }
                    BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, delegate);
                    return null;
                }
            }, (IProgressMonitor)cancellationChild);
            progress.done();
            IVersionedContent iVersionedContent = this.createVersionedContent(contentHashCode, predecessorHintHash, length, context);
            return iVersionedContent;
        }
        catch (TeamServiceException e) {
            e.setOrigin((Object)this.teamRepository());
            throw e;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected Method getStoreMethodForStatistics(long length, ContentHash predecessorHintHash, ContentHash contentHashCode, StoreContext context) {
        return fetchMethod;
    }

    protected Object getStoreDelegateForStatistics(long length, ContentHash predecessorHintHash, ContentHash contentHashCode, StoreContext context) {
        return this.serviceDelegate;
    }

    protected IVersionedContent createVersionedContent(ContentHash hash, ContentHash predecessorHintHash, long size, StoreContext context) {
        VersionedContent vc = ScmFactory.eINSTANCE.createVersionedContent();
        vc.setHash(hash);
        vc.setPredecessorHint(predecessorHintHash);
        vc.setSize(size);
        return vc;
    }

    protected void retrieveContent(IVersionableHandle versionable, IVersionedContent content, OutputStream outStream, RetrieveContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (outStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            try {
                if (content == null) {
                    throw new IllegalArgumentException();
                }
                if (versionable == null) {
                    throw new IllegalArgumentException();
                }
                if (versionable.getItemId() == null) {
                    throw new IllegalArgumentException();
                }
                if (versionable.getStateId() == null) {
                    throw new IllegalArgumentException();
                }
                this.internalRetrieveContent(versionable, content, outStream, context, monitor);
                outStream.close();
                outStream = null;
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Object)this.teamRepository(), e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (outStream != null) {
            try {
                outStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected InputStream retrieveContentStream(IVersionableHandle versionable, IVersionedContent content, RetrieveContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        if (versionable.getItemId() == null) {
            throw new IllegalArgumentException();
        }
        if (versionable.getStateId() == null) {
            throw new IllegalArgumentException();
        }
        return this.internalRetrieveContentStream(versionable, content, context, monitor);
    }

    protected InputStream internalRetrieveContentStream(final IVersionableHandle item, final IVersionedContent content, final RetrieveContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final URI uri = this.getRetrieveURI(item, content, context);
        InputStream in = (InputStream)this.ctx.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<InputStream>(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public InputStream run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                InputStream inputStream;
                long start = System.currentTimeMillis();
                Method method = BasicVersionedContentManager.this.getRetrieveMethodForStatistics(item, content, context);
                Object delegate = BasicVersionedContentManager.this.getRetrieveDelegateForStatistics(item, content, context);
                BasicVersionedContentManager.this.preInvoke();
                boolean success = false;
                boolean connectionError = false;
                try {
                    inputStream = BasicVersionedContentManager.this.invokeContentGet(item, content, uri, context);
                }
                catch (TeamRepositoryException e) {
                    try {
                        connectionError = BasicVersionedContentManager.this.onServiceError((Exception)((Object)e));
                        throw e;
                        catch (RuntimeException e2) {
                            connectionError = BasicVersionedContentManager.this.onServiceError(e2);
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, delegate);
                        throw throwable;
                    }
                }
                BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, delegate);
                return inputStream;
            }
        }, (IProgressMonitor)progress.newChild(5));
        return new MonitoredInputStream(in, content.getSize(), (IProgressMonitor)progress);
    }

    protected Method getRetrieveMethodForStatistics(IVersionableHandle item, IVersionedContent content, RetrieveContext context) {
        return fetchMethod;
    }

    protected Object getRetrieveDelegateForStatistics(IVersionableHandle item, IVersionedContent content, RetrieveContext context) {
        return this.serviceDelegate;
    }

    protected URI getRetrieveURI(IVersionableHandle handle, IVersionedContent content, RetrieveContext context) throws TeamRepositoryException {
        try {
            URI uri = new URI(this.server.getRepositoryURL());
            String path = String.valueOf(uri.getPath()) + "service" + "/" + IVersionedContentService.class.getName() + "/" + "content" + "/" + handle.getItemType().getNamespaceURI() + "/" + handle.getItemType().getName() + "/" + handle.getItemId().getUuidValue() + "/" + handle.getStateId().getUuidValue() + "/" + content.getHash();
            uri = new URI(null, null, path, uri.getQuery(), uri.getFragment());
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), e1.getMessage(), (Throwable)e1);
        }
    }

    protected void preInvoke() throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        TeamServiceCallContextImpl.checkCancelable();
        this.ensureLoggedIn();
        TeamRepository repository = (TeamRepository)this.teamRepository();
        repository.statistics().incStatisticValue("com.ibm.team.repository.beingCalledContext", (Object)repository, "debugBeingCalledFlag", 1L);
        if (repository.getDebugMode() == 1) {
            try {
                Thread.sleep(repository.getConnectionTimeout() * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected boolean onServiceError(Exception exception) throws TeamRepositoryException {
        this.ensureLoggedIn();
        boolean connectionError = ConnectionUtil.setConnectionError((Exception)exception, (TeamRepository)((TeamRepository)this.teamRepository()));
        if (exception instanceof TeamRepositoryException) {
            ((TeamRepositoryException)((Object)exception)).setOrigin((Object)this.teamRepository());
        }
        return connectionError;
    }

    protected void postInvoke(long elapsedTime, boolean errorOccured, boolean connectionError, Method method, Object delegate) {
        TeamRepository repository = (TeamRepository)this.teamRepository();
        if (!errorOccured) {
            repository.setErrorState(0, null);
        }
        repository.statistics().decStatisticValue("com.ibm.team.repository.beingCalledContext", (Object)repository, "debugBeingCalledFlag", 1L);
        if (!connectionError) {
            repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)method, "serviceMethodElapsedTime", elapsedTime);
            repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.service", delegate, "serviceElapsedTime", elapsedTime);
            repository.statistics().incStatisticValue("com.ibm.team.repository.totalContext", (Object)repository, "totalServiceElapsedTime", elapsedTime);
        }
        repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)method, "serviceMethodCallCount", 1L);
        repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.service", delegate, "serviceCallCount", 1L);
        repository.statistics().incStatisticValue("com.ibm.team.repository.totalContext", (Object)repository, "totalServiceCallCount", 1L);
    }

    protected void ensureLoggedIn() throws NotLoggedInException {
        if (!this.teamRepository().loggedIn()) {
            String uri = this.teamRepository().getRepositoryURI();
            NotLoggedInException e = new NotLoggedInException(uri);
            e.setOrigin((Object)this.teamRepository());
            throw e;
        }
    }

    protected InputStream invokeContentGet(IVersionableHandle handle, IVersionedContent content, URI uri, RetrieveContext context) throws TeamRepositoryException {
        GetMethod method = new GetMethod();
        this.addContentRetrieveHeaders(method, handle, content, uri, context);
        boolean success = false;
        try {
            int result = this.executeMethod((HttpMethod)method);
            if (result != 200) {
                throw new TeamRepositoryException("Unexpected result code: " + result);
            }
            ReleasingAndAbortingInputStream in = new ReleasingAndAbortingInputStream((HttpMethod)method);
            success = true;
            ReleasingAndAbortingInputStream releasingAndAbortingInputStream = in;
            return releasingAndAbortingInputStream;
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        finally {
            if (!success) {
                method.releaseConnection();
            }
        }
    }

    protected void addContentRetrieveHeaders(GetMethod get, IVersionableHandle handle, IVersionedContent content, URI uri, RetrieveContext context) throws TeamRepositoryException {
        get.setDoAuthentication(true);
        get.setPath(uri.toString());
        get.setRequestHeader("http.useragent", this.getClass().getName());
        get.setRequestHeader("Accept", HttpUtil.MediaType.JSON.toString());
        get.addRequestHeader("Accept", HttpUtil.MediaType.ANY.toString());
        get.setRequestHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        BasicVersionedContentManager.setAcceptLanguageHeader((HttpMethod)get);
        this.addServiceVersionHeaderForRetrieve((HttpMethod)get, context);
        this.setUseridHeader((HttpMethod)get);
    }

    protected void addServiceVersionHeaderForRetrieve(HttpMethod method, RetrieveContext ctx) {
        this.addServiceVersionHeader(method, IVersionedContentService.class.getName());
    }

    protected void internalRetrieveContent(IVersionableHandle handle, IVersionedContent content, OutputStream out, RetrieveContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        InputStream inStream = this.internalRetrieveContentStream(handle, content, context, monitor);
        try {
            try {
                UnsynchronizedBufferedOutputStream bOut = new UnsynchronizedBufferedOutputStream(out, 32768);
                BasicVersionedContentManager.read(inStream, (OutputStream)bOut);
                bOut.flushToStream();
                inStream.close();
                inStream = null;
            }
            catch (IOException e) {
                TeamRepositoryException tre = new TeamRepositoryException((Throwable)e);
                tre.setOrigin((Object)this.teamRepository());
                throw tre;
            }
        }
        catch (Throwable throwable) {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            if (monitor != null) {
                monitor.done();
            }
            throw throwable;
        }
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    protected static void read(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = new byte[32768];
        int len = in.read(bytes);
        while (len != -1) {
            out.write(bytes, 0, len);
            len = in.read(bytes);
        }
    }

    protected SessionType createAsyncSession(int threads, boolean allowFailures, String sessionName, long totalWork, IProgressMonitor monitor) {
        return (SessionType)new BasicAsyncVersionedContentManagerSession(threads, allowFailures, sessionName, totalWork, this, monitor);
    }

    protected SessionType createSyncSession(boolean allowFailures, String sessionName, long totalWork, IProgressMonitor monitor) {
        return (SessionType)new BasicSynchronousVersionedContentManagerSession(sessionName, totalWork, this, monitor);
    }

    protected SessionType createSession(int threads, boolean allowFailures, String sessionName, long totalWork, IProgressMonitor monitor) {
        if (threads < 0) {
            throw new IllegalArgumentException("Maximum number of threads must be zero or more.");
        }
        if (threads == 0) {
            return this.createSyncSession(allowFailures, sessionName, totalWork, monitor);
        }
        return this.createAsyncSession(threads, allowFailures, sessionName, totalWork, monitor);
    }

    protected SessionType createSession(String sessionName, boolean allowFailures, long totalWork, IProgressMonitor monitor) {
        return this.createSession(maxSimultaneousDownloads, allowFailures, sessionName, totalWork, monitor);
    }

    public static void setMaxSimultaneousDownloads(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Maximum number of threads must be zero or more.");
        }
        maxSimultaneousDownloads = count;
    }

    public static int getMaxSimultaneousDownloads() {
        return maxSimultaneousDownloads;
    }

    protected static void setAcceptLanguageHeader(HttpMethod method) {
        String variant;
        if (method == null) {
            throw new IllegalArgumentException("method must not be null");
        }
        Locale locale = Locale.getDefault();
        StringBuffer buffer = new StringBuffer(locale.getLanguage());
        String country = locale.getCountry();
        if (country.length() > 0) {
            buffer.append('-').append(country);
        }
        if ((variant = locale.getVariant()).length() > 0) {
            buffer.append('-').append(variant);
        }
        method.setRequestHeader("Accept-Language", buffer.toString());
    }

    protected void setUseridHeader(HttpMethod method) {
        String userid = this.server.getUserid();
        if (userid == null) {
            return;
        }
        try {
            userid = URLEncoder.encode(userid, HttpUtil.CharsetEncoding.UTF8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        method.addRequestHeader("X-com-ibm-team-userid", userid);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StreamLengthUtility {
        protected final InputStream input;
        protected byte[] inputBytes;
        protected long length = -1L;
        protected ContentHash contentHashCode;
        protected final StoreContext context;

        public StreamLengthUtility(InputStream is, StoreContext context) {
            this.input = is;
            this.context = context;
        }

        public void run() throws TeamRepositoryException {
            byte[] content = new byte[32768];
            int r = -1;
            boolean success = false;
            try {
                try {
                    DigestComputingInputStream hashCalculator = ContentHash.getDigestComputingStream((InputStream)BasicVersionedContentManager.this.wrapInputStreamForUpload(this.input, this.context));
                    int lengthSoFar = 0;
                    while (lengthSoFar != content.length) {
                        r = hashCalculator.read(content, lengthSoFar, content.length - lengthSoFar);
                        if (r == -1) break;
                        lengthSoFar += r;
                    }
                    if (r == -1) {
                        this.inputBytes = content;
                    } else {
                        while ((r = hashCalculator.read(content)) != -1) {
                        }
                    }
                    this.length = hashCalculator.getContentSize();
                    this.contentHashCode = ContentHash.valueOf((byte[])hashCalculator.getFinalDigest());
                    success = true;
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Object)BasicVersionedContentManager.this.teamRepository(), e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.length = -1L;
                    try {
                        this.input.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        this.input.close();
                    }
                    catch (IOException e) {
                        throw new TeamRepositoryException((Object)BasicVersionedContentManager.this.teamRepository(), e.getMessage(), (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (!success) {
                this.length = -1L;
                try {
                    this.input.close();
                }
                catch (IOException iOException) {}
            } else {
                try {
                    this.input.close();
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Object)BasicVersionedContentManager.this.teamRepository(), e.getMessage(), (Throwable)e);
                }
            }
        }

        public long getStreamLength() throws TeamRepositoryException {
            if (this.length == -1L) {
                this.run();
            }
            return this.length;
        }

        public byte[] getInputBytes() throws TeamRepositoryException {
            if (this.length == -1L) {
                this.run();
            }
            return this.inputBytes;
        }

        public ContentHash getContentHashCode() throws TeamRepositoryException {
            if (this.length == -1L) {
                this.run();
            }
            return this.contentHashCode;
        }

        public void cleanup() throws TeamRepositoryException {
            this.inputBytes = null;
        }
    }
}

