/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.Messages;
import com.ibm.team.scm.client.VisibilityEnum;

public class Visibility {
    private final VisibilityEnum viz;
    private final IProjectAreaHandle scope;
    public static final Visibility PUBLIC = new Visibility(VisibilityEnum.PUBLIC_TO_ALL, null);
    public static final Visibility PRIVATE = new Visibility(VisibilityEnum.PRIVATE_TO_OWNER, null);

    public Visibility(VisibilityEnum v, IProjectAreaHandle ph) {
        this.viz = v;
        this.scope = ph;
    }

    public VisibilityEnum getVisibility() {
        return this.viz;
    }

    public IProjectAreaHandle getProjectAreaScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Visibility)) {
            return false;
        }
        Visibility other = (Visibility)o;
        if (this.getVisibility() == VisibilityEnum.PROTECTED && other.getVisibility() == VisibilityEnum.PROTECTED) {
            return this.getProjectAreaScope().sameItemId((IItemHandle)other.getProjectAreaScope());
        }
        return this.getVisibility() == other.getVisibility();
    }

    public String toString() {
        if (this.viz == VisibilityEnum.PRIVATE_TO_OWNER) {
            return Messages.Visibility_0;
        }
        if (this.viz == VisibilityEnum.PUBLIC_TO_ALL) {
            return Messages.Visibility_1;
        }
        if (this.viz == VisibilityEnum.PROTECTED) {
            return Messages.Visibility_2;
        }
        return Messages.Visibility_3;
    }
}

