/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.Visibility;
import com.ibm.team.scm.client.content.IVersionedContentManager;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IWorkspaceManager
extends IEventSource {
    public static final String KNOWN_WORKSPACES = "workspaces";
    public static final String KNOWN_COMPONENTS = "components";
    public static final String KNOWN_BASELINES = "baselines";
    public static final String COMPONENT_OWNER = "component_owner";
    public static final String COMPONENT_VISIBILITY = "component_visibility";
    public static final String USER_SUSPENDED = "suspended";
    public static final String USER_LOCKS = "user_locks";
    public static final int MAX_QUERY_SIZE = 512;

    public ITeamRepository teamRepository();

    public IVersionableManager versionableManager();

    public List knownWorkspaceConnections();

    public List knownBaselineConnections();

    public List knownComponents();

    public IWorkspaceConnection getWorkspaceConnection(IWorkspaceHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List<? extends IWorkspaceConnection> getWorkspaceConnections(List<? extends IWorkspaceHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IBaselineConnection getBaselineConnection(IBaselineHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IBaselineConnection getBaselineConnection(IBaseline var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IWorkspaceConnection copyWorkspace(IAuditableHandle var1, IWorkspaceConnection var2, String var3, String var4, IProgressMonitor var5) throws TeamRepositoryException;

    public IWorkspaceConnection createWorkspace(IContributorHandle var1, String var2, String var3, IProgressMonitor var4) throws TeamRepositoryException;

    public IWorkspaceConnection createWorkspace(IContributorHandle var1, String var2, String var3, IWorkspaceConnection var4, IWorkspaceConnection var5, IProgressMonitor var6) throws TeamRepositoryException;

    public IWorkspaceConnection createWorkspace(IContributorHandle var1, String var2, String var3, IBaselineSetHandle var4, IProgressMonitor var5) throws TeamRepositoryException;

    public IWorkspaceConnection createStream(IProcessAreaHandle var1, String var2, String var3, IProgressMonitor var4) throws TeamRepositoryException;

    public List findWorkspaceDeliverRelationships(IWorkspaceHandle var1, IAuditableHandle var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List findWorkspaceAcceptRelationships(IWorkspaceHandle var1, IAuditableHandle var2, IProgressMonitor var3) throws TeamRepositoryException;

    public IItemQueryPage findWorkspacesByName(String var1, boolean var2, boolean var3, boolean var4, int var5, IProgressMonitor var6) throws TeamRepositoryException;

    public List<IWorkspaceHandle> findWorkspaces(IWorkspaceSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public IItemQueryPage fetchNextPage(IItemQueryPage var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List findItems(IItemQuery var1, Object[] var2) throws TeamRepositoryException;

    public List findItems(IItemQuery var1, Object[] var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void deleteWorkspace(IWorkspaceHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    public void setComment(IChangeSetHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void setName(IBaselineSetHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void setComment(IBaselineSetHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List findComponents(String var1, IAuditableHandle var2, boolean var3, IProgressMonitor var4) throws TeamRepositoryException;

    public List<IComponentHandle> findComponents(IComponentSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List<IAuditableHandle> findOwnersForComponents(List<? extends IComponentHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List<Visibility> findVisibilityForComponents(List<? extends IComponentHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List findBaselineSets(String var1, IProcessAreaHandle var2, boolean var3, IProgressMonitor var4) throws TeamRepositoryException;

    public List findBaselineSets(IBaselineSetSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public IComponent createComponent(String var1, IAuditableHandle var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void renameComponent(IComponentHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void setComponentOwner(IComponentHandle var1, IAuditableHandle var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void setComponentVisibility(IComponentHandle var1, Visibility var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List findAllWorkspaces(IAuditableHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public Set findAllWorkspaceNames(IAuditableHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    public Set<String> findAllComponentNames(IProgressMonitor var1) throws TeamRepositoryException;

    public List findAllBaselines(IComponentHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List<IBaselineHandle> findBaselines(IBaselineSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List<IChangeSetLinkSummary> getChangeSetLinkSummary(Collection<? extends IChangeSetHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List<IChangeSetHandle> findChangeSets(IChangeSetSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void refreshWorkspaceConnections(Collection<IWorkspaceConnection> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IVersionableLockOperationFactory lockOperationFactory();

    public void applyLockOperations(Collection<IVersionableLockOperation> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public Collection<IStreamLockReport> getLocks() throws TeamRepositoryException;

    public ILockSearchResult findLocks(ILockSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public boolean sameRepository(IConnection var1);

    public List<IChangeSetHandle> suspendedChangeSets();

    public List<IChangeSetHandle> suspendedChangeSets(IComponentHandle var1);

    public void removeSuspended(Collection var1, IProgressMonitor var2) throws TeamRepositoryException;

    public void refresh(IProgressMonitor var1) throws TeamRepositoryException;

    public IVersionedContentManager getSCMContentManager();

    public static interface IVersionableLockOperation {
    }

    public static interface IVersionableLockOperationFactory {
        public IVersionableLockOperation acquire(IVersionableHandle var1, IWorkspaceConnection var2, IComponentHandle var3);

        public IVersionableLockOperation acquireSubtree(IFolderHandle var1, IWorkspaceConnection var2, IComponentHandle var3);

        public IVersionableLockOperation release(IVersionableHandle var1, IWorkspaceConnection var2, IComponentHandle var3, boolean var4);

        public IVersionableLockOperation transfer(IVersionableHandle var1, IWorkspaceConnection var2, IComponentHandle var3, IContributorHandle var4);
    }
}

