/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.process;

import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.internal.Messages;
import com.ibm.team.scm.common.process.RepositoryRunnable;

public abstract class ProcessOverride {
    public abstract boolean shouldRun();

    public abstract IOperationReport validate() throws TeamRepositoryException;

    public Object run(RepositoryRunnable block) throws TeamRepositoryException {
        IOperationReport report = this.validate();
        if (report != null && report.getSeverity() == 4) {
            throw new TeamRepositoryException(report.getDescription());
        }
        return block.run(null);
    }

    public void validateAndThrow() throws TeamRepositoryException {
        IOperationReport report;
        if (this.shouldRun() && (report = this.validate()) != null && report.getSeverity() == 4) {
            throw new PermissionDeniedException(this.getExceptionDescription());
        }
    }

    protected String getExceptionDescription() {
        return Messages.getString("ProcessOverride.ERROR_MESSAGE");
    }
}

