/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.links;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.repository.common.AdapterManagerFactory;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.links.IComponentLinkCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericLinkCreator {
    public List<ILink> createLinks(IItemType sourceClass, Object source, IItemType targetClass, Object target, IProgressMonitor monitor) throws TeamRepositoryException {
        List<ILinkType> compatibleLinkTypes = this.getCompatibleLinkTypes(sourceClass, targetClass);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)compatibleLinkTypes.size());
        ArrayList<ILink> createdLinks = new ArrayList<ILink>(compatibleLinkTypes.size());
        for (ILinkType linkType : compatibleLinkTypes) {
            ILink link;
            IComponentLinkCreator creator = GenericLinkCreator.getAdapter(source, IComponentLinkCreator.class);
            if (creator == null || !creator.handles(linkType.getLinkTypeId()) || (link = creator.create(linkType.getLinkTypeId(), source, target, (IProgressMonitor)progress.newChild(1))) == null) continue;
            createdLinks.add(link);
        }
        return createdLinks;
    }

    public List<ILinkType> getCompatibleLinkTypes(IItemType sourceClass, IItemType targetClass) {
        Collection entries = ILinkTypeRegistry.INSTANCE.allEntries();
        ArrayList<ILinkType> compatibleLinkTypes = new ArrayList<ILinkType>();
        for (ILinkType linkType : entries) {
            if (linkType.getSourceEndPointDescriptor().getReferencedItemType() != sourceClass || linkType.getTargetEndPointDescriptor().getReferencedItemType() != targetClass) continue;
            compatibleLinkTypes.add(linkType);
        }
        return compatibleLinkTypes;
    }

    public static <T> T getAdapter(Object sourceObject, Class<T> adapter) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        if (sourceObject == null || adapter == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return (T)sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            Assert.isTrue((boolean)adapter.isInstance(result2));
            return (T)result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = AdapterManagerFactory.getAdapterManager().loadAdapter(sourceObject, adapter.getName())) != null) {
            Assert.isTrue((boolean)adapter.isInstance(result));
            return (T)result;
        }
        return null;
    }
}

