/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.internal.util.ItemId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StateId<T extends IItem> {
    public static final UUID STATE_DELETED = UUID.valueOf((String)"_hnMp4OXVEdqfgdmADyqO4w");
    private UUID stateId;
    private UUID itemId;
    private IItemType itemType;

    public StateId(IItemType type, UUID itemId, UUID stateId) {
        if (stateId == null || itemId == null || type == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.itemType = type;
        this.stateId = stateId;
        this.itemId = itemId;
    }

    public StateId(ItemId<T> item, UUID stateId) {
        if (stateId == null || item == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.itemId = item.getItemUUID();
        this.itemType = item.getItemType();
        this.stateId = stateId;
    }

    public StateId(IItemHandle handle) {
        if (handle == null) {
            throw new IllegalArgumentException("handle must not be null");
        }
        this.stateId = handle.getStateId();
        if (this.stateId == null) {
            throw new IllegalArgumentException("handle must have a state");
        }
        this.itemType = handle.getItemType();
        this.itemId = handle.getItemId();
    }

    public boolean isDeleted() {
        return this.stateId.equals((Object)STATE_DELETED);
    }

    public <K extends IItemHandle> K toHandle(Object origin) {
        if (this.stateId.equals((Object)STATE_DELETED)) {
            return null;
        }
        IItemHandle result = this.itemType.createItemHandle(origin, this.itemId, this.stateId);
        return (K)result;
    }

    public <K extends IItemHandle> K toHandle() {
        if (this.stateId.equals((Object)STATE_DELETED)) {
            return null;
        }
        IItemHandle result = this.itemType.createItemHandle(this.itemId, this.stateId);
        return (K)result;
    }

    public ItemId<T> getItemId() {
        return new ItemId(this.itemType, this.itemId);
    }

    public UUID getItemUUID() {
        return this.itemId;
    }

    public IItemType getItemType() {
        return this.itemType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StateId) {
            StateId state = (StateId)obj;
            return state.itemId.equals((Object)this.itemId) && state.stateId.equals((Object)this.stateId);
        }
        return false;
    }

    public int hashCode() {
        return this.stateId.hashCode();
    }

    public UUID getStateUUID() {
        return this.stateId;
    }

    public static <T extends IItem> StateId<T> getDeletedState(IItemType type, UUID item) {
        return new StateId<T>(type, item, STATE_DELETED);
    }

    public static <T extends IItem> StateId<T> getDeletedState(ItemId<T> item) {
        return new StateId<T>(item, STATE_DELETED);
    }

    public static <T extends IItem> StateId<T> forItem(T item) {
        return new StateId<T>((IItemHandle)item);
    }

    public static <K extends IItem, T extends K> StateId<K> upcast(StateId<T> toConvert) {
        return toConvert;
    }

    public String toString() {
        return "StateId(" + this.itemType.getName() + ", " + this.itemId.getUuidValue() + ", " + this.stateId.getUuidValue() + ")";
    }
}

