/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.dto;

import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.dto.HistoryProvider;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;

public interface ServiceHistoryProvider {
    public static final IHistoryProviderFactory FACTORY = new IHistoryProviderFactory(){

        public ServiceHistoryProvider create(IWorkspaceHandle ws, IComponentHandle c) {
            if (ws == null || c == null) {
                throw new IllegalArgumentException();
            }
            HistoryProvider p = ScmDtoFactory.eINSTANCE.createHistoryProvider();
            p.setWorkspaceComponentPair(ScmDtoFactory.eINSTANCE.createWorkspaceComponentPair());
            p.getWorkspaceComponentPair().setWorkspace(ws);
            p.getWorkspaceComponentPair().setComponent(c);
            return p;
        }

        public ServiceHistoryProvider create(ChangeHistoryHandle chh) {
            if (chh == null) {
                throw new IllegalArgumentException();
            }
            HistoryProvider p = ScmDtoFactory.eINSTANCE.createHistoryProvider();
            p.setChangeHistory(chh);
            return p;
        }

        public ServiceHistoryProvider create(IBaselineHandle bh) {
            if (bh == null) {
                throw new IllegalArgumentException();
            }
            HistoryProvider p = ScmDtoFactory.eINSTANCE.createHistoryProvider();
            p.setBaseline(bh);
            return p;
        }
    };

    public static interface IHistoryProviderFactory {
        public ServiceHistoryProvider create(IWorkspaceHandle var1, IComponentHandle var2);

        public ServiceHistoryProvider create(ChangeHistoryHandle var1);

        public ServiceHistoryProvider create(IBaselineHandle var1);
    }
}

