/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.util;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditableBatchResolver {
    private IWorkItemCommon fWorkItemCommon;
    private Map<ItemProfile<?>, Set<IAuditableHandle>> fHandles = new HashMap();
    private Map<UUID, ItemProfile<?>> fProfiles = new HashMap();
    private Map<UUID, IAuditable> fAuditables = new HashMap<UUID, IAuditable>();
    private Map<UUID, Map<UUID, IAttribute>> fAttributeMaps = new HashMap<UUID, Map<UUID, IAttribute>>();
    private Map<UUID, IEnumeration<? extends ILiteral>> fEnumerationMap = new HashMap<UUID, IEnumeration<? extends ILiteral>>();

    public AuditableBatchResolver(IWorkItemCommon workItemCommon) {
        this.fWorkItemCommon = workItemCommon;
    }

    public void add(ItemProfile<?> profile, IAuditableHandle handle) {
        Object set;
        Assert.isTrue((boolean)profile.getItemType().equals(handle.getItemType()));
        ItemProfile<?> existing = this.fProfiles.get(handle.getItemId());
        if (existing != null) {
            if (existing.contains(profile)) {
                return;
            }
            if (!profile.contains(existing)) {
                profile = profile.createExtension(existing.getProperties());
            }
            if ((set = this.fHandles.get(existing)) != null) {
                set.remove(handle);
            }
        }
        if ((set = this.fHandles.get(profile)) == null) {
            set = new ItemHandleAwareHashSet();
            this.fHandles.put(profile, (Set<IAuditableHandle>)set);
        }
        set.add((IAuditableHandle)handle);
        this.fProfiles.put(handle.getItemId(), profile);
    }

    public IAuditable get(IAuditableHandle handle) {
        return this.fAuditables.get(handle.getItemId());
    }

    public boolean resolve(IProgressMonitor monitor) throws TeamRepositoryException {
        boolean allFound = true;
        HashMap<UUID, IAuditable> map = new HashMap<UUID, IAuditable>();
        for (Map.Entry<ItemProfile<?>, Set<IAuditableHandle>> entry : this.fHandles.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            List auditables = this.fWorkItemCommon.getAuditableCommon().resolveAuditables(new ArrayList(entry.getValue()), entry.getKey(), monitor);
            for (IAuditable auditable : auditables) {
                if (auditable != null) {
                    map.put(auditable.getItemId(), auditable);
                    continue;
                }
                allFound = false;
            }
        }
        this.fAuditables = map;
        return allFound;
    }

    public boolean findCached() {
        boolean allFound = true;
        HashMap<UUID, IAuditable> map = new HashMap<UUID, IAuditable>();
        for (Map.Entry<ItemProfile<?>, Set<IAuditableHandle>> entry : this.fHandles.entrySet()) {
            for (IAuditableHandle handle : entry.getValue()) {
                IAuditable auditable = this.fWorkItemCommon.getAuditableCommon().findCachedAuditable(handle, entry.getKey());
                if (auditable != null) {
                    map.put(auditable.getItemId(), auditable);
                    continue;
                }
                allFound = false;
            }
        }
        this.fAuditables = map;
        return allFound;
    }

    IEnumeration<? extends ILiteral> resolveEnumeration(IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.fEnumerationMap.containsKey(attribute.getItemId())) {
            IEnumeration enumeration = this.fWorkItemCommon.resolveEnumeration((IAttributeHandle)attribute, monitor);
            this.fEnumerationMap.put(attribute.getItemId(), (IEnumeration<? extends ILiteral>)enumeration);
        }
        return this.fEnumerationMap.get(attribute.getItemId());
    }

    List<IAttribute> resolveAttributes(IProjectAreaHandle projectAreaHandle, List<IAttributeHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<UUID, IAttribute> attributeMap = this.getAttributeMap(projectAreaHandle, monitor);
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>(handles.size());
        for (IAttributeHandle attributeHandle : handles) {
            IAttribute attribute = attributeMap.get(attributeHandle.getItemId());
            if (attribute == null) {
                attribute = (IAttribute)this.fWorkItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)attributeHandle, IAttribute.FULL_PROFILE, monitor);
                attributeMap.put(attributeHandle.getItemId(), attribute);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    private Map<UUID, IAttribute> getAttributeMap(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<UUID, IAttribute> attributeMap = this.fAttributeMaps.get(projectAreaHandle.getItemId());
        if (attributeMap == null) {
            attributeMap = this.createAttributeMap(projectAreaHandle, monitor);
            this.fAttributeMaps.put(projectAreaHandle.getItemId(), attributeMap);
        }
        return attributeMap;
    }

    private Map<UUID, IAttribute> createAttributeMap(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        List attributes = this.fWorkItemCommon.findAttributes(projectAreaHandle, monitor);
        HashMap<UUID, IAttribute> attributeMap = new HashMap<UUID, IAttribute>();
        for (IAttribute attribute : attributes) {
            attributeMap.put(attribute.getItemId(), attribute);
        }
        return attributeMap;
    }

    public <T extends IAuditable> T resolveAuditable(IAuditableHandle handle, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return (T)this.fWorkItemCommon.getAuditableCommon().resolveAuditable(handle, profile, monitor);
    }
}

