/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.transport.client.IInternalRawRestServiceClient;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import com.ibm.team.repository.transport.client.RestClientConnectionBase;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class TeamRawRestServiceClient
implements IInternalRawRestServiceClient {
    private final RemoteTeamServer _remoteTeamServer;
    private IOAuthHandler _oauthHandler = null;

    public TeamRawRestServiceClient(RemoteTeamServer remoteTeamServer) {
        if (remoteTeamServer == null) {
            throw new IllegalArgumentException("remoteTeamServer must not be null");
        }
        this._remoteTeamServer = remoteTeamServer;
    }

    public synchronized IOAuthHandler setOAuthHandler(IOAuthHandler oauthHandler) {
        IOAuthHandler priorHandler = this._oauthHandler;
        this._oauthHandler = oauthHandler;
        return priorHandler;
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection getConnection(URI uri) throws URISyntaxException {
        if (uri == null) {
            throw new IllegalArgumentException("relative URI must not be null");
        }
        return new RawRestClientConnection(this._remoteTeamServer, uri, this._oauthHandler);
    }

    public static class RawRestClientConnection
    extends RestClientConnectionBase
    implements ITeamRawRestServiceClient.IRawRestClientConnection {
        public RawRestClientConnection(RemoteTeamServer server, URI uri, IOAuthHandler handler) throws URISyntaxException {
            super(server, uri, handler);
        }

        public void addRequestHeader(String name, String value) {
            super.addRequestHeader(name, value);
        }

        public ITeamRawRestServiceClient.IRawRestClientConnection.Response doGet() throws TeamServiceException, TeamRepositoryException {
            return super.doGet();
        }

        public ITeamRawRestServiceClient.IRawRestClientConnection.Response doHead() throws TeamServiceException, TeamRepositoryException {
            return super.doHead();
        }

        public ITeamRawRestServiceClient.IRawRestClientConnection.Response doPost(InputStream content, long contentLength, String contentType) throws TeamServiceException, TeamRepositoryException {
            return super.doPost(content, contentLength, contentType);
        }

        public ITeamRawRestServiceClient.IRawRestClientConnection.Response doPut(InputStream content, long contentLength, String contentType) throws TeamServiceException, TeamRepositoryException {
            return super.doPut(content, contentLength, contentType);
        }

        public ITeamRawRestServiceClient.IRawRestClientConnection.Response doDelete() throws TeamServiceException, TeamRepositoryException {
            return super.doDelete();
        }
    }
}

