/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSLContextUtil {
    private static final Log LOG = LogFactory.getLog(SSLContextUtil.class);
    public static final String SSL_TLS = "SSL_TLS";
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";

    public static SSLContext createSSLContext(TrustManager trustManager) {
        SSLContext context = SSLContextUtil.createSSLContext(SSL_TLS, trustManager);
        if (context == null) {
            LOG.trace((Object)"Unable to create SSL_TLS context, trying TLS");
            context = SSLContextUtil.createSSLContext(TLS, trustManager);
        }
        if (context == null) {
            LOG.trace((Object)"Unable to create TLS context, trying SSL");
            context = SSLContextUtil.createSSLContext(SSL, trustManager);
        }
        if (context == null) {
            throw new RuntimeException("No acceptable encryption algorithm found");
        }
        return context;
    }

    private static SSLContext createSSLContext(String algorithm, TrustManager trustManager) {
        SSLContext context;
        try {
            context = SSLContext.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.trace((Object)e);
            return null;
        }
        try {
            context.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            LOG.trace((Object)e);
            return null;
        }
        try {
            Socket s = context.getSocketFactory().createSocket();
            s.close();
        }
        catch (IOException e) {
            LOG.trace((Object)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            LOG.trace((Object)e);
            return null;
        }
        return context;
    }
}

