/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.WebServicesMarshaller;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HostUnknownException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.InsecureProtocolException;
import com.ibm.team.repository.common.transport.ServiceNotAvailableException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.common.transport.VersionMismatchException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.auth.TransportAuthException;
import com.ibm.team.repository.transport.auth.TransportAuthUtil;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.NoResponseException;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import com.ibm.team.repository.transport.client.RemoteTeamService;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xmlsoap.schemas.soap.envelope.Body;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class ClientHttpUtil
extends HttpUtil {
    private static final String NLS_HTTP_ERROR = "ClientHttpUtil.HttpError";
    private static final String NLS_HTTP_ERROR_AUTHENTICATION = "ClientHttpUtil.HttpError.Authentication";
    private static final String NLS_HTTP_ERROR_SERVICE = "ClientHttpUtil.HttpError.Service";
    private static final String NLS_HTTP_ERROR_TIMEOUT = "ClientHttpUtil.HttpError.Timeout";
    private static final String NLS_HTTP_ERROR_NO_RESPONSE = "ClientHttpUtil.HttpError.NoResponse";
    private static final String NLS_HTTP_ERROR_SOCKET = "ClientHttpUtil.HttpError.Socket";
    private static final String NLS_HTTP_ERROR_INVALID = "ClientHttpUtil.HttpError.Invalid";
    private static final String NLS_HTTP_ERROR_UNKNOWN_HOST = "ClientHttpUtil.HttpError.UnknownHost";
    private static final String NLS_MISSING_PASSWORD = "ClientHttpUtil.MissingPassword";
    private static final String NLS_MISSING_USERNAME = "ClientHttpUtil.MissingUsername";
    private static final String NLS_MISSING_USERNAME_PASSWORD = "ClientHttpUtil.MissingUsernamePassword";
    private static final String NLS_GENERAL_ERROR = "ClientHttpUtil.GeneralError";
    private static final String NLS_GENERAL_ERROR_UNKNOWN_SERVICE = "ClientHttpUtil.GeneralErrorUnknownService";
    private static final String NLS_UNAVAILABLE_ERROR = "ClientHttpUtil.UnavailableError";
    private static final String NLS_NOT_IMPLEMENTED_ERROR = "ClientHttpUtil.NotImplementedError";
    private static final String NLS_FORBIDDEN_ERROR = "ClientHttpUtil.ForbiddenError";
    private static final String NLS_UNAUTHORIZED_ERROR = "ClientHttpUtil.UnauthorizedError";
    private static final String NLS_SERVICE_ERROR = "ClientHttpUtil.ServiceError";
    private static final String NLS_UNEXPECTED_AUTH_ERROR = "ClientHttpUtil.UnexpectedAuthError";
    private static final Log logger = LogFactory.getLog(ClientHttpUtil.class);

    public static int executeHttpMethod(RemoteTeamServer server, RemoteTeamService service, HttpMethod method, boolean handle404, boolean wrapIOException) throws IOException, TeamServiceException {
        String message;
        if (server == null) {
            throw new IllegalArgumentException("server must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method must not be null");
        }
        int statusCode = -1;
        HttpClient httpClient = server.getHttpClient();
        httpClient.getParams().setSoTimeout(server.getConfiguration().getSocketTimeout());
        String originalPath = method.getPath();
        HostConfiguration methodConfiguration = method.getHostConfiguration();
        if (methodConfiguration != null && methodConfiguration.isHostSet()) {
            Protocol protocol = methodConfiguration.getProtocol();
            String host = methodConfiguration.getHost();
            int port = methodConfiguration.getPort();
            logger.warn((Object)NLS.bind((String)"HttpMethod should not have a defined host\n\tProtocol: {0}\n\tHost: {1}\n\tPort: {2}", (Object)protocol.toString(), (Object[])new Object[]{host, port}));
        }
        HttpState state = httpClient.getState();
        HttpState privateState = new HttpState();
        privateState.addCookies(state.getCookies());
        AuthScope as = server.getAuthScope();
        Credentials cred = state.getCredentials(as);
        if (cred != null) {
            privateState.setCredentials(as, cred);
        }
        if ((as = server.getProxyAuthScope()) != null && (cred = state.getProxyCredentials(as)) != null) {
            privateState.setProxyCredentials(as, cred);
        }
        int authCount = 0;
        while (true) {
            Header location;
            HttpClientParams params;
            try {
                method.setFollowRedirects(false);
                method.setDoAuthentication(true);
                statusCode = httpClient.executeMethod(null, method, privateState);
            }
            catch (org.apache.commons.httpclient.auth.AuthenticationException e) {
                throw new AuthenticationException(ClientHttpUtil.httpErrorMessage(NLS_HTTP_ERROR_AUTHENTICATION, httpClient, method, (Exception)((Object)e)), e);
            }
            catch (HttpException e) {
                throw new TeamServiceException(ClientHttpUtil.httpErrorMessage(NLS_HTTP_ERROR_SERVICE, httpClient, method, (Exception)((Object)e)), (Throwable)e);
            }
            catch (ConnectTimeoutException e) {
                throw new ConnectionException(ClientHttpUtil.httpErrorMessage(NLS_HTTP_ERROR_TIMEOUT, httpClient, method, (Exception)((Object)e)), (Throwable)e);
            }
            catch (NoHttpResponseException e) {
                throw new NoResponseException(ClientHttpUtil.httpErrorMessage(NLS_HTTP_ERROR_NO_RESPONSE, httpClient, method, (Exception)((Object)e)), e);
            }
            catch (SocketException e) {
                ConnectionException c = new ConnectionException(ClientHttpUtil.httpErrorMessage(NLS_HTTP_ERROR_SOCKET, httpClient, method, e));
                c.initCause((Throwable)e);
                throw c;
            }
            catch (UnresolvedAddressException e) {
                throw new HostUnknownException(ClientHttpUtil.httpErrorMessage(NLS_HTTP_ERROR_INVALID, httpClient, method, e), (Throwable)e);
            }
            catch (UnknownHostException e) {
                throw new HostUnknownException(ClientHttpUtil.httpErrorMessage(NLS_HTTP_ERROR_UNKNOWN_HOST, httpClient, method, e), (Throwable)e);
            }
            catch (IOException e) {
                if (wrapIOException) {
                    throw new TeamServiceException(ClientHttpUtil.httpErrorMessage(httpClient, method, e), (Throwable)e);
                }
                throw e;
            }
            AuthScheme authScheme = method.getHostAuthState().getAuthScheme();
            if (authScheme != null && authScheme.getSchemeName().equalsIgnoreCase("BASIC") && !(params = httpClient.getParams()).isAuthenticationPreemptive()) {
                params.setAuthenticationPreemptive(true);
            }
            if (TransportAuthUtil.formAuthRequested((HttpMethod)method)) {
                if (authCount == 1) {
                    try {
                        TransportAuthUtil.visitAuthenticatedURL((String)server.getRepositoryPath(), (HttpClient)httpClient, (HttpState)privateState);
                    }
                    catch (TransportAuthException e) {
                        throw new AuthenticationException(e.getMessage(), e.getCause());
                    }
                    ++authCount;
                    continue;
                }
                if (authCount == 2) {
                    message = NLS.bind((String)Messages.getServerString(NLS_UNEXPECTED_AUTH_ERROR), (Object)(String.valueOf(httpClient.getHostConfiguration().getHostURL()) + method.getURI()), (Object[])new Object[0]);
                    throw new AuthenticationException(message);
                }
                ++authCount;
                UsernamePasswordCredentials storedCredentials = (UsernamePasswordCredentials)privateState.getCredentials(server.getAuthScope());
                if (!TransportAuthUtil.credDefined((UsernamePasswordCredentials)storedCredentials)) {
                    ClientHttpUtil.throwEmptyCredsException(storedCredentials);
                }
                try {
                    TransportAuthUtil.formBasedAuthenticate((String)server.getRepositoryPath(), (HttpClient)httpClient, (UsernamePasswordCredentials)storedCredentials, (HttpState)privateState);
                }
                catch (TransportAuthException e) {
                    throw new AuthenticationException(e.getMessage(), e.getCause());
                }
                state.addCookies(privateState.getCookies());
                httpClient.getParams().setAuthenticationPreemptive(false);
                method.getHostAuthState().setAuthScheme(null);
                method.releaseConnection();
                method.setRequestHeader("Connection", "Close");
                method.setPath(originalPath);
                continue;
            }
            if (statusCode != 302 || (location = method.getResponseHeader("Location")) == null || !location.getValue().contains("/authenticated/identity")) break;
            String repoPath = server.getRepositoryPath();
            if (!repoPath.endsWith("/")) {
                repoPath = String.valueOf(repoPath) + "/";
            }
            repoPath = String.valueOf(repoPath) + "authenticated/identity";
            GetMethod getAuthenticatedRequest = new GetMethod(repoPath);
            try {
                httpClient.executeMethod(null, (HttpMethod)getAuthenticatedRequest, privateState);
            }
            finally {
                getAuthenticatedRequest.releaseConnection();
            }
            state.addCookies(privateState.getCookies());
            method.releaseConnection();
            method.setPath(originalPath);
        }
        state.addCookies(privateState.getCookies());
        switch (statusCode) {
            case -1: {
                throw new TeamServiceException(NLS.bind((String)Messages.getServerString(NLS_SERVICE_ERROR), (Object)(String.valueOf(httpClient.getHostConfiguration().getHostURL()) + method.getURI()), (Object[])new Object[0]));
            }
            case 401: {
                message = NLS.bind((String)Messages.getServerString(NLS_UNAUTHORIZED_ERROR), (Object)method.getURI(), (Object[])new Object[0]);
                Header[] header = method.getResponseHeaders();
                AuthenticationException exp = new AuthenticationException(message);
                exp.addHeaders(header);
                throw exp;
            }
            case 403: {
                message = NLS.bind((String)Messages.getServerString(NLS_FORBIDDEN_ERROR), (Object)method.getURI(), (Object[])new Object[0]);
                PermissionDeniedException wrappedCause = new PermissionDeniedException(message);
                throw new AuthenticationException(message, (Throwable)wrappedCause);
            }
            case 501: {
                message = NLS.bind((String)Messages.getServerString(NLS_NOT_IMPLEMENTED_ERROR), (Object)method.getURI(), (Object[])new Object[0]);
                throw new ServiceNotAvailableException(message);
            }
            case 503: {
                message = NLS.bind((String)Messages.getServerString(NLS_UNAVAILABLE_ERROR), (Object)method.getURI(), (Object[])new Object[0]);
                throw new ServiceNotAvailableException(message);
            }
            case 302: {
                String protocol = httpClient.getHostConfiguration().getProtocol().getScheme();
                if (protocol.compareToIgnoreCase("http") == 0) {
                    String message2 = NLS.bind((String)Messages.getServerString("ClientHttpUtil.ErrorInsecureHttpConnection"), (Object)method.getURI(), (Object[])new Object[]{"http", "https"});
                    throw new InsecureProtocolException(message2);
                }
                ClientHttpUtil.throwHttpClientError(service, method, statusCode);
            }
        }
        if (!handle404 && 404 == statusCode) {
            return statusCode;
        }
        if (statusCode >= 300) {
            ClientHttpUtil.throwHttpClientError(service, method, statusCode);
        }
        return statusCode;
    }

    public static void setAcceptLanguageHeader(HttpMethod method) {
        String variant;
        if (method == null) {
            throw new IllegalArgumentException("method must not be null");
        }
        Locale locale = Locale.getDefault();
        StringBuffer buffer = new StringBuffer(locale.getLanguage());
        String country = locale.getCountry();
        if (country.length() > 0) {
            buffer.append('-').append(country);
        }
        if ((variant = locale.getVariant()).length() > 0) {
            buffer.append('-').append(variant);
        }
        method.setRequestHeader("Accept-Language", buffer.toString());
    }

    private static void throwHttpClientError(RemoteTeamService service, HttpMethod method, int statusCode) throws TeamServiceException {
        Throwable cause;
        String template;
        String decodedStatusText = URLDecoder.decode(method.getStatusText());
        String message = null;
        if (service == null) {
            template = Messages.getServerString(NLS_GENERAL_ERROR_UNKNOWN_SERVICE);
            message = NLS.bind((String)template, (Object)statusCode, (Object[])new Object[]{decodedStatusText});
        } else {
            template = Messages.getServerString(NLS_GENERAL_ERROR);
            message = NLS.bind((String)template, (Object)service.toString(), (Object[])new Object[]{statusCode, decodedStatusText});
        }
        TeamServiceException exp = new TeamServiceException(message);
        exp.addHeaders(method.getResponseHeaders());
        if (service != null) {
            ClientHttpUtil.appendNestedException(service, exp, method);
        }
        if ((cause = exp.getCause()) instanceof VersionMismatchException) {
            exp = new VersionMismatchException(cause.getMessage(), (Throwable)exp);
        }
        throw exp;
    }

    private static void throwEmptyCredsException(UsernamePasswordCredentials storedCredentials) throws AuthenticationException {
        String username = null;
        String password = null;
        if (storedCredentials != null) {
            username = storedCredentials.getUserName();
            password = storedCredentials.getPassword();
            if (username.length() == 0) {
                username = null;
            }
            if (password.length() == 0) {
                password = null;
            }
        }
        if (username == null && password == null) {
            throw new AuthenticationException(Messages.getServerString(NLS_MISSING_USERNAME_PASSWORD));
        }
        if (username == null) {
            throw new AuthenticationException(Messages.getServerString(NLS_MISSING_USERNAME));
        }
        throw new AuthenticationException(Messages.getServerString(NLS_MISSING_PASSWORD));
    }

    private static String httpErrorMessage(HttpClient httpClient, HttpMethod method, Exception e) throws URIException, MalformedURLException {
        return ClientHttpUtil.httpErrorMessage(NLS_HTTP_ERROR, httpClient, method, e);
    }

    private static String httpErrorMessage(String messageKey, HttpClient httpClient, HttpMethod method, Exception e) throws URIException, MalformedURLException {
        String msg = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
        String u = ClientHttpUtil.getURL(httpClient, method);
        String s = NLS.bind((String)Messages.getServerString(messageKey), (Object)msg, (Object[])new Object[]{u});
        return s;
    }

    private static String getURL(HttpClient httpClient, HttpMethod method) throws URIException, MalformedURLException {
        HostConfiguration hostConfiguration = method.getHostConfiguration();
        if (!hostConfiguration.isHostSet()) {
            hostConfiguration = httpClient.getHostConfiguration();
        }
        String protocol = hostConfiguration.getProtocol().getScheme();
        String host = hostConfiguration.getHost();
        int port = hostConfiguration.getPort();
        URL u = new URL(protocol, host, port, method.getPath());
        String s = u.toString();
        return s;
    }

    private static void appendNestedException(RemoteTeamService service, TeamServiceException exception, HttpMethod method) {
        WebServicesMarshaller webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
        try {
            Throwable throwable;
            Fault fault;
            Envelope envelope = ClientHttpUtil.demarshallEnvelope(webServicesMarshaller, method);
            Body body = envelope.getBody();
            if (body != null && (fault = body.getFault()) != null && (throwable = ClientHttpUtil.constructExceptionFromFault(service, fault)) != null) {
                exception.initCause(throwable);
            }
        }
        catch (Throwable throwable) {}
    }

    private static Throwable constructExceptionFromFault(RemoteTeamService service, Fault fault) {
        Throwable result = MarshallerUtil.decodeFault((Fault)fault, (ClassLoader)service.getServiceClassLoader());
        return result;
    }

    private static Envelope demarshallEnvelope(WebServicesMarshaller webServicesMarshaller, HttpMethod postMethod) throws IOException, MarshallingException {
        Header[] headers = postMethod.getResponseHeaders("Content-Encoding");
        if (headers == null) {
            headers = new Header[]{};
        }
        boolean gzipped = false;
        int i = 0;
        while (i < headers.length) {
            if (headers[i].getValue().equalsIgnoreCase("gzip")) {
                gzipped = true;
            }
            ++i;
        }
        InputStream responseStream = postMethod.getResponseBodyAsStream();
        if (gzipped) {
            responseStream = new GZIPInputStream(responseStream, 8192);
        }
        return (Envelope)webServicesMarshaller.demarshalInputStreamToObject(responseStream);
    }
}

