/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client.util;

import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.internal.client.util.Messages;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class ContentUtil {
    static {
        new ContentUtil();
    }

    private ContentUtil() {
    }

    public static String getContentTypeFromFileName(String fileName) {
        ValidationHelper.validateNotEmpty((String)"fileName", (String)fileName);
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(fileName);
        if (contentType == null && fileName.toLowerCase().endsWith(".log")) {
            contentType = "text/plain";
        }
        return contentType;
    }

    public static boolean isTextContentType(String contentType) {
        return contentType != null && contentType.trim().toLowerCase().startsWith("text");
    }

    public static IContent stringToContent(ITeamRepository teamRepository, String stringContent) throws TeamRepositoryException {
        return ContentUtil.stringToContent(teamRepository, stringContent, null);
    }

    public static IContent stringToContent(ITeamRepository teamRepository, String stringContent, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IContent content = null;
        if (teamRepository != null && stringContent != null) {
            content = teamRepository.contentManager().storeContent("text/plain", stringContent, progressMonitor);
        }
        return content;
    }

    public static String contentToString(ITeamRepository teamRepository, IContent content, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        String stringContent = "";
        if (content != null && teamRepository != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);
            IContentManager contentManager = teamRepository.contentManager();
            contentManager.retrieveContent(content, (OutputStream)outputStream, progressMonitor);
            String encoding = content.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            try {
                stringContent = outputStream.toString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new TeamBuildException((Throwable)e);
            }
        }
        return stringContent;
    }

    public static File contentToFile(ITeamRepository teamRepository, IContent content, IProgressMonitor monitor, String filePath) throws TeamRepositoryException {
        File outFile;
        block26: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            outFile = null;
            if (content != null && teamRepository != null) {
                FileOutputStream outputStream = null;
                InputStream inputStream = null;
                try {
                    try {
                        outFile = new File(filePath);
                        if (!outFile.exists()) {
                            outFile.createNewFile();
                        }
                        outputStream = new FileOutputStream(outFile);
                        IContentManager contentManager = teamRepository.contentManager();
                        inputStream = contentManager.retrieveContentStream(content, monitor);
                        ContentUtil.copyFile(inputStream, outputStream, (int)content.getEstimatedConvertedLength(), monitor);
                    }
                    catch (IOException iOException) {
                        outFile = null;
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException3) {}
                        }
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return outFile;
    }

    private static void copyFile(InputStream inStream, OutputStream outStream, int length, IProgressMonitor monitor) throws IOException {
        byte[] buffer = new byte[32000];
        monitor.beginTask(Messages.ContentUtil_RETRIEVING_CONTENT_PROGRESS, length);
        try {
            int numbytes = inStream.read(buffer);
            while (numbytes > -1) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                outStream.write(buffer, 0, numbytes);
                monitor.worked(numbytes);
                numbytes = inStream.read(buffer);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static IContent stringArrayToContent(ITeamRepository teamRepository, String[] strings, char delimiter) throws TeamRepositoryException {
        if (teamRepository == null || strings == null || strings.length == 0) {
            return null;
        }
        IContent content = null;
        if (teamRepository != null && strings != null && strings.length > 0) {
            StringBuffer stringContent = new StringBuffer();
            int i = 0;
            while (i < strings.length) {
                if (strings[i] == null || strings[i].equals("")) {
                    return null;
                }
                stringContent.append(strings[i]);
                if (i < strings.length - 1) {
                    stringContent.append(delimiter);
                }
                ++i;
            }
            content = teamRepository.contentManager().storeContent("text/plain", stringContent.toString(), null);
        }
        return content;
    }

    public static String[] contentToStringArray(ITeamRepository teamRepository, IContent content, char delimiter, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (teamRepository == null || content == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        if (content != null && teamRepository != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);
            IContentManager contentManager = teamRepository.contentManager();
            contentManager.retrieveContent(content, (OutputStream)outputStream, progressMonitor);
            String stringContent = outputStream.toString();
            if (stringContent.length() > 0) {
                String delimiterString = new String(new char[]{delimiter});
                StringTokenizer tokenizer = new StringTokenizer(stringContent, delimiterString);
                while (tokenizer.hasMoreTokens()) {
                    strings.add(tokenizer.nextToken());
                }
            }
        }
        return strings.toArray(new String[strings.size()]);
    }
}

