/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common;

import com.ibm.team.filesystem.common.internal.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileLineDelimiter {
    LINE_DELIMITER_NONE(0),
    LINE_DELIMITER_LF(1),
    LINE_DELIMITER_CR(2),
    LINE_DELIMITER_CRLF(3),
    LINE_DELIMITER_PLATFORM(4);

    private static final String[] PRETTY_NAME;
    private final int dbValue;
    private static final boolean IS_CRLF_PLATFORM;
    private static final boolean IS_LF_PLATFORM;
    private static final boolean IS_CR_PLATFORM;

    static {
        PRETTY_NAME = new String[]{"None", "LF (Unix)", "CR (Mac)", "CRLF (Windows)", "Platform"};
        IS_CRLF_PLATFORM = Arrays.equals(System.getProperty("line.separator").toCharArray(), new char[]{'\r', '\n'});
        IS_LF_PLATFORM = Arrays.equals(System.getProperty("line.separator").toCharArray(), new char[]{'\n'});
        IS_CR_PLATFORM = Arrays.equals(System.getProperty("line.separator").toCharArray(), new char[]{'\r'});
    }

    private FileLineDelimiter(int dbValue) {
        this.dbValue = dbValue;
    }

    public int dbValue() {
        return this.dbValue;
    }

    public static FileLineDelimiter getLineDelimiter(int dbValue) {
        FileLineDelimiter[] fileLineDelimiterArray = FileLineDelimiter.values();
        int n = fileLineDelimiterArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileLineDelimiter delimiter = fileLineDelimiterArray[n2];
            if (delimiter.dbValue() == dbValue) {
                return delimiter;
            }
            ++n2;
        }
        return null;
    }

    public static FileLineDelimiter fromString(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < PRETTY_NAME.length) {
            if (name.equals(PRETTY_NAME[i])) {
                return FileLineDelimiter.values()[i];
            }
            ++i;
        }
        return null;
    }

    public String asQuery() throws TeamRepositoryException {
        if (this == LINE_DELIMITER_NONE) {
            return "";
        }
        if (this == LINE_DELIMITER_LF) {
            return "LF";
        }
        if (this == LINE_DELIMITER_CR) {
            return "CR";
        }
        if (this == LINE_DELIMITER_CRLF) {
            return "CRLF";
        }
        throw new TeamRepositoryException(NLS.bind((String)Messages.getString("LineDelimiter_0"), (Object)this.toString(), (Object[])new Object[0]));
    }

    public static FileLineDelimiter fromQuery(String query) {
        if (query == null || query.length() == 0) {
            return LINE_DELIMITER_NONE;
        }
        if (query.equals("LF")) {
            return LINE_DELIMITER_LF;
        }
        if (query.equals("CR")) {
            return LINE_DELIMITER_CR;
        }
        if (query.equals("CRLF")) {
            return LINE_DELIMITER_CRLF;
        }
        throw new IllegalArgumentException("Unrecognized query string for delimiter type");
    }

    public static FileLineDelimiter getPlatformDelimiter() {
        if (IS_CRLF_PLATFORM) {
            return LINE_DELIMITER_CRLF;
        }
        if (IS_LF_PLATFORM) {
            return LINE_DELIMITER_LF;
        }
        if (IS_CR_PLATFORM) {
            return LINE_DELIMITER_CR;
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return PRETTY_NAME[this.dbValue];
    }
}

