/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditableClientProcess
implements IAuditableCommonProcess {
    private IAuditableClient fAuditableClient;
    private IClientProcess fClientProcess;

    public AuditableClientProcess(IAuditableClient auditableClient, IClientProcess clientProcess) {
        this.fAuditableClient = auditableClient;
        this.fClientProcess = clientProcess;
    }

    public List getDevelopmentLines(IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ItemProfile profile = ItemProfile.createProfile((IItemType)IProjectArea.ITEM_TYPE, (String[])new String[]{ProcessCommon.getPropertyName(IProjectArea.class, (String)"developmentLines")});
        IProjectArea projectArea = (IProjectArea)this.fAuditableClient.resolveAuditable((IAuditableHandle)this.fClientProcess.getProjectArea(), profile, monitor);
        return this.fAuditableClient.resolveAuditablesPermissionAware(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
    }

    public IDevelopmentLine getDevelopmentLine(ITeamAreaHandle teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getAuditableCommon().getDevelopmentLine(teamArea, monitor);
    }

    public IProcessConfigurationData findProcessConfiguration(String configurationDataPoint, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.fClientProcess.getProjectConfigurationData(configurationDataPoint, monitor);
    }

    public IAdvisorDeclaration findAdvisorDeclaration(IProcessAreaHandle processArea, IDevelopmentLine developmentLine, String advisableOperationId, String operationAdvisorId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findAdvisorDeclaration(processArea, advisableOperationId, operationAdvisorId, monitor);
    }

    public IAdvisorDeclaration findAdvisorDeclaration(IProcessAreaHandle processArea, String advisableOperationId, String operationAdvisorId, IProgressMonitor monitor) throws TeamRepositoryException {
        IAdvisorDeclaration[] advisorDeclarations;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProcessArea area = (IProcessArea)this.fAuditableClient.resolveAuditable((IAuditableHandle)processArea, ItemProfile.createFullProfile((IItemType)processArea.getItemType()), monitor);
        IAdvisorDeclaration[] iAdvisorDeclarationArray = advisorDeclarations = this.fClientProcess.getAdvisorDeclarations(area, advisableOperationId, monitor);
        int n = advisorDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            IAdvisorDeclaration advisorDeclaration = iAdvisorDeclarationArray[n2];
            if (advisorDeclaration.getIdentifier().equals(operationAdvisorId)) {
                return advisorDeclaration;
            }
            ++n2;
        }
        return null;
    }

    public IOperationReport adviseAndExecute(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.fClientProcess.adviseAndExecute(operation, monitor);
    }

    public IDevelopmentLine findDefaultDevelopmentLine(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getAuditableCommon().findDefaultDevelopmentLine(this.getProjectArea(), monitor);
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fClientProcess.getProjectArea();
    }

    public IAuditableCommon getAuditableCommon() {
        return this.fAuditableClient;
    }

    public IProcessAttachment getProcessAttachment(String attachmentPath, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processItemService = (IProcessItemService)this.fAuditableClient.getTeamRepository().getClientLibrary(IProcessItemService.class);
        return processItemService.getProcessAttachment((IProcessContainerHandle)this.getProjectArea(), attachmentPath, monitor);
    }

    public List<IRole> getRoles(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return Arrays.asList(this.fClientProcess.getRoles(processArea, monitor));
    }

    public List<IRole> getContributorRoles(IContributorHandle contributor, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return Arrays.asList(this.fClientProcess.getContributorRoles(contributor, processArea, monitor));
    }
}

