/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client;

import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.PropertyUtil;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ItemURI;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URLDecoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIService {
    private static final String DEFAULT_ENCODING = "UTF-8";

    private URIService() {
    }

    public static URI createAuditableURI(ITeamRepository teamRepository, Object object) {
        return ItemURI.generateAuditableURI((String)teamRepository.getRepositoryURI(), (Object)object);
    }

    public static URI createAuditableURI(ITeamRepository teamRepository, IItemHandle handle) {
        return ItemURI.generateAuditableURI((String)teamRepository.getRepositoryURI(), (IItemHandle)handle);
    }

    public static URI createWorkItemURI(ITeamRepository teamRepository, int id) {
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        return ItemURI.createWorkItemURI((IAuditableCommon)auditableClient, (int)id);
    }

    public static URI createAttachmentURI(ITeamRepository teamRepository, int id) {
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        return ItemURI.createAttachmentURI((IAuditableCommon)auditableClient, (int)id);
    }

    public static URI createWorkItemCommentURI(ITeamRepository teamRepository, int id, int commentIndex) {
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        return ItemURI.createWorkItemCommentURI((IAuditableCommon)auditableClient, (int)id, (int)commentIndex);
    }

    public static URI createWorkItemCommentURI(IWorkItemHandle handle, int commentIndex) {
        ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        return ItemURI.createWorkItemCommentURI((IAuditableCommon)auditableClient, (IWorkItemHandle)handle, (int)commentIndex);
    }

    public static Object resolveObject(URI uri) throws TeamRepositoryException {
        return URIService.resolveObject(uri, null);
    }

    public static Object resolveObject(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemType itemType = URIService.findItemType(uri);
        if (itemType == null) {
            return null;
        }
        ItemProfile profile = ItemProfile.createFullProfile((IItemType)itemType);
        return URIService.resolveObject(uri, profile, monitor);
    }

    public static Object resolveObject(URI uri, ItemProfile<?> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        IItem item = URIService.resolveItem(uri, profile, monitor);
        String path = URIService.getObjectPath(uri);
        if (path == null) {
            return item;
        }
        try {
            if (item instanceof EObject) {
                return PropertyUtil.get((EObject)((EObject)item), (String)path);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (UndeclaredThrowableException ute) {
            if (ute.getUndeclaredThrowable() instanceof InvocationTargetException && ((InvocationTargetException)ute.getUndeclaredThrowable()).getTargetException() instanceof IndexOutOfBoundsException) {
                return null;
            }
            throw ute;
        }
        return null;
    }

    private static IItem resolveItem(URI uri, ItemProfile<?> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemHandle handle;
        ITeamRepository teamRepository = URIService.findTeamRepository(uri);
        if (teamRepository == null) {
            return null;
        }
        Location location = null;
        try {
            location = Location.location((URI)uri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        if (location != null && location.getItemType() != null) {
            try {
                Location fetchLocation = location;
                if (IWorkItem.ITEM_TYPE.equals(location.getItemType()) && location.getQueryString().length() > 0) {
                    URI relUri = location.toRelativeUri();
                    fetchLocation = Location.location((URI)URI.create(relUri.getPath()));
                }
                return teamRepository.itemManager().fetchPartialItem(fetchLocation, 0, profile.getProperties(), monitor);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if ((handle = URIService.resolveItemHandle(uri)) == null) {
            return null;
        }
        if (handle instanceof IAuditableHandle) {
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            return auditableClient.resolveAuditable((IAuditableHandle)handle, profile, monitor);
        }
        return null;
    }

    private static String getObjectPath(URI uri) {
        String path = uri.getFragment();
        if (path == null || path.length() == 0) {
            return URIService.getObjectPath2(uri);
        }
        return URIService.decode(path);
    }

    private static String getObjectPath2(URI uri) {
        String query = uri.getQuery();
        if (query == null || query.length() == 0) {
            return null;
        }
        String path = ItemURI.getValue((String)query, (String)"path");
        if (path == null || path.length() == 0) {
            return null;
        }
        return URIService.decode(path);
    }

    public static IItemHandle resolveItemHandle(URI uri) throws TeamRepositoryException {
        ITeamRepository teamRepository = URIService.findTeamRepository(uri);
        if (teamRepository == null) {
            return null;
        }
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IItemHandle handle = ItemURI.resolveItemHandle((IAuditableCommon)auditableClient, (URI)uri);
        if (handle != null) {
            return handle;
        }
        return ItemURI.resolveLocation((IAuditableCommon)auditableClient, (URI)uri);
    }

    public static ITeamRepository findTeamRepository(URI uri) {
        return ClientURIUtils.findTeamRepository((URI)uri);
    }

    public static ITeamRepository getLoggedInTeamRepository(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        return ClientURIUtils.getLoggedInTeamRepository((URI)uri, (IProgressMonitor)monitor);
    }

    public static URI findTeamRepositoryURI(URI uri) {
        return ClientURIUtils.findTeamRepositoryURI((URI)uri);
    }

    public static IItemType findItemType(URI uri) {
        return ItemURI.findItemType((URI)uri);
    }

    private static String decode(String string) {
        block3: {
            try {
                if (string != null) break block3;
                return null;
            }
            catch (UnsupportedEncodingException x) {
                throw new RuntimeException(x);
            }
        }
        return URLDecoder.decode(string.replaceAll("%20", "\\+"), DEFAULT_ENCODING);
    }
}

