/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.SymLinkHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.CoreException;

class Java17SymLinkHelper
extends SymLinkHelper {
    private static final String altSeparator = File.separator.equals("\\") ? "/" : null;
    final FileSystem fs = FileSystems.getDefault();
    final boolean supportsLinks;

    static Java17SymLinkHelper newInstance() {
        return new Java17SymLinkHelper();
    }

    private Java17SymLinkHelper() {
        boolean supported = true;
        try {
            this.fs.getPath(System.getProperty("user.dir")).readSymbolicLink();
        }
        catch (UnsupportedOperationException e) {
            supported = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.supportsLinks = supported;
    }

    public void createSymlink(String path, String targetPath) throws CoreException {
        try {
            this.fs.getPath(path).createSymbolicLink(this.fs.getPath(targetPath), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
        catch (UnsupportedOperationException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
    }

    public String getResolvedPath(String path) throws CoreException {
        Path p = this.fs.getPath(path).toAbsolutePath();
        Path existingParent = null;
        for (Path parent = p.getParent(); parent != null; parent = parent.getParent()) {
            BasicFileAttributeView v = (BasicFileAttributeView)parent.getFileAttributeView(BasicFileAttributeView.class, new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
            try {
                BasicFileAttributes a = v.readAttributes();
                if (!a.isDirectory()) {
                    return null;
                }
                if (existingParent != null) continue;
                existingParent = parent;
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (existingParent != null) {
            Path relativePart = existingParent.relativize(p);
            try {
                existingParent = existingParent.toRealPath(false);
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
            p = existingParent.resolve(relativePart);
        }
        p = p.normalize();
        String result = p.toString();
        if (path.endsWith(File.separator) || altSeparator != null && path.endsWith(altSeparator)) {
            BasicFileAttributeView v = (BasicFileAttributeView)p.getFileAttributeView(BasicFileAttributeView.class, new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
            try {
                BasicFileAttributes a = v.readAttributes();
                if (!a.isDirectory()) {
                    return null;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!result.endsWith(File.separator)) {
                result = result + File.separator;
            }
        }
        return result;
    }

    public boolean supportsSymLinks() {
        return this.supportsLinks;
    }
}

