/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.util;

import com.ibm.team.repository.client.IStatistics;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatisticsUtil {
    public static final String SERVICE_METHOD_TRANSPORT_TIME = "serviceMethodTransportTime";
    public static final String SERVICE_METHOD_PRE_TRANSPORT_TIME = "serviceMethodPreTransportTime";
    public static final String SERVICE_METHOD_POST_TRANSPORT_TIME = "serviceMethodPostTransportTime";
    private static StatisticsColumn nameColumn = new StatisticsColumn(){

        public String getName(IStatistics stats) {
            return "Method";
        }

        public String getValue(IStatistics stats, Method method) {
            return method.getName();
        }

        public String getValueSeparator(IStatistics stats, Method method) {
            return ": ";
        }
    };
    private static StatisticsColumn countColumn = new StatisticsColumn(){

        public String getName(IStatistics stats) {
            return "Calls";
        }

        public String getValue(IStatistics stats, Method method) {
            return Long.toString(stats.getServiceMethodCallCount(method));
        }
    };
    private static StatisticsColumn totalTimeColumn = new StatisticsColumn(){

        public String getName(IStatistics stats) {
            return "Time";
        }

        public String getValue(IStatistics stats, Method method) {
            return String.valueOf(stats.getServiceMethodElapsedTime(method)) + "ms";
        }
    };
    private static StatisticsColumn preTransColumn = new StatisticsColumn(){

        public String getName(IStatistics stats) {
            return "Serialisation";
        }

        public String getValue(IStatistics stats, Method method) {
            return "se:" + stats.getStatisticValue("com.ibm.team.repository.statistics.serviceMethod", method, StatisticsUtil.SERVICE_METHOD_PRE_TRANSPORT_TIME) + "ms";
        }
    };
    private static StatisticsColumn transportColumn = new StatisticsColumn(){

        public String getName(IStatistics stats) {
            return "Transport Time";
        }

        public String getValue(IStatistics stats, Method method) {
            return "tr:" + stats.getStatisticValue("com.ibm.team.repository.statistics.serviceMethod", method, StatisticsUtil.SERVICE_METHOD_TRANSPORT_TIME) + "ms";
        }
    };
    private static StatisticsColumn postTransColumn = new StatisticsColumn(){

        public String getName(IStatistics stats) {
            return "Deserialisation";
        }

        public String getValue(IStatistics stats, Method method) {
            return "de:" + stats.getStatisticValue("com.ibm.team.repository.statistics.serviceMethod", method, StatisticsUtil.SERVICE_METHOD_POST_TRANSPORT_TIME) + "ms";
        }
    };

    private static SortedMap<Class<?>, SortedSet<Method>> findOrderedMethods(IStatistics stats, Comparator<Class<?>> classComp, Comparator<Method> methodComp) {
        Method[] methods = stats.getServiceMethods();
        TreeMap result = new TreeMap(classComp);
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Class<?> owner = m.getDeclaringClass();
            TreeSet<Method> l = (TreeSet<Method>)result.get(owner);
            if (l == null) {
                l = new TreeSet<Method>(methodComp);
                result.put(owner, l);
            }
            l.add(m);
            ++n2;
        }
        return result;
    }

    public static void printStatistics(IStatistics stats, PrintStream stream, StatisticsColumn ... userColumns) {
        if (stats == null) {
            stream.println("<null IStatistics instance>");
            return;
        }
        stream.println("Service Trip Statistics:");
        SortedMap<Class<?>, SortedSet<Method>> orderedClasses = StatisticsUtil.findOrderedMethods(stats, new ClassNameComparator(), new MethodNameComparator());
        List<StatisticsColumn> columns = StatisticsUtil.printColumnNames(stats, stream, StatisticsUtil.findColumns(stats, userColumns, orderedClasses));
        long totalElapsedTime = 0L;
        for (Map.Entry<Class<?>, SortedSet<Method>> service : orderedClasses.entrySet()) {
            String serviceFullName = service.getKey().getName();
            String serviceName = serviceFullName.substring(serviceFullName.lastIndexOf(46) + 1);
            int serviceCallCount = 0;
            long serviceElapsedTime = 0L;
            for (Method serviceMethod : service.getValue()) {
                serviceCallCount = (int)((long)serviceCallCount + stats.getServiceMethodCallCount(serviceMethod));
                serviceElapsedTime += stats.getServiceMethodElapsedTime(serviceMethod);
            }
            totalElapsedTime += serviceElapsedTime;
            stream.println("  " + serviceName + ": " + serviceCallCount + "  " + serviceElapsedTime + "ms");
            for (Method serviceMethod : service.getValue()) {
                stream.print("    ");
                StatisticsColumn prevColumn = null;
                for (StatisticsColumn column : columns) {
                    if (prevColumn != null) {
                        stream.print(prevColumn.getValueSeparator(stats, serviceMethod));
                    }
                    prevColumn = column;
                    stream.print(column.getValue(stats, serviceMethod));
                }
                stream.println();
            }
        }
        stream.println("-- Total time in service calls: " + totalElapsedTime + "ms");
    }

    private static List<StatisticsColumn> findColumns(IStatistics stats, StatisticsColumn[] userColumns, SortedMap<Class<?>, SortedSet<Method>> orderedClasses) {
        ArrayList<StatisticsColumn> toReturn = new ArrayList<StatisticsColumn>(3 + userColumns.length);
        toReturn.add(nameColumn);
        toReturn.add(countColumn);
        toReturn.add(totalTimeColumn);
        if (StatisticsUtil.hasStat(stats, orderedClasses, SERVICE_METHOD_PRE_TRANSPORT_TIME)) {
            toReturn.add(preTransColumn);
        }
        if (StatisticsUtil.hasStat(stats, orderedClasses, SERVICE_METHOD_TRANSPORT_TIME)) {
            toReturn.add(transportColumn);
        }
        if (StatisticsUtil.hasStat(stats, orderedClasses, SERVICE_METHOD_POST_TRANSPORT_TIME)) {
            toReturn.add(postTransColumn);
        }
        StatisticsColumn[] statisticsColumnArray = userColumns;
        int n = userColumns.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticsColumn userColumn = statisticsColumnArray[n2];
            toReturn.add(userColumn);
            ++n2;
        }
        return toReturn;
    }

    private static boolean hasStat(IStatistics stats, SortedMap<Class<?>, SortedSet<Method>> orderedClasses, String stat) {
        for (Map.Entry<Class<?>, SortedSet<Method>> service : orderedClasses.entrySet()) {
            for (Method method : service.getValue()) {
                String[] names;
                String[] stringArray = names = stats.getStatisticNames("com.ibm.team.repository.statistics.serviceMethod", method);
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (stat.equals(name)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private static List<StatisticsColumn> printColumnNames(IStatistics stats, PrintStream stream, List<StatisticsColumn> columns) {
        LinkedList<StatisticsColumn> toReturn = new LinkedList<StatisticsColumn>();
        boolean needsComma = false;
        for (StatisticsColumn column : columns) {
            String columnName = column.getName(stats);
            if (columnName == null) continue;
            toReturn.add(column);
            if (needsComma) {
                stream.print(", ");
            } else {
                needsComma = true;
            }
            stream.print(columnName);
        }
        stream.println();
        return toReturn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassNameComparator
    implements Comparator<Class<?>> {
        private ClassNameComparator() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodNameComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method o1, Method o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
        }
    }

    public static abstract class StatisticsColumn {
        public abstract String getName(IStatistics var1);

        public abstract String getValue(IStatistics var1, Method var2);

        public String getValueSeparator(IStatistics stats, Method method) {
            return ", ";
        }
    }
}

