/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.client.util.RepositoryUtil;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.TeamServerConfiguration;
import com.ibm.team.repository.common.util.ExtensionReader;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class TeamRepositoryService
extends EventSource
implements ITeamRepositoryService {
    private final Collection<ITeamRepository> cachedRepositories = new HashSet<ITeamRepository>();
    private final Collection<WeakReference<ITeamRepository>> sharedRepositories = new HashSet<WeakReference<ITeamRepository>>();
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final EventListenerRegistry eventListenerRegistry = new EventListenerRegistry();
    private static final Log log = LogFactory.getLog((String)"com.ibm.team.repository");

    public TeamRepositoryService() {
        this.eventListenerRegistry.start();
    }

    public ITeamRepository getTeamRepository(String repositoryURI, int flags) {
        if (repositoryURI == null) {
            throw new IllegalArgumentException();
        }
        if ((flags & 1) != 0) {
            return new TeamRepository(repositoryURI, (flags & 2) == 0);
        }
        try {
            this.acquire();
            this.cleanOrphans();
            ITeamRepository repository = this.getSharedTeamRepository(repositoryURI);
            if (repository == null) {
                if ((flags & 4) == 0) {
                    repository = this.createSharedTeamRepository(repositoryURI, flags);
                }
            } else {
                this.shareTeamRepository(repository);
            }
            ITeamRepository iTeamRepository = repository;
            return iTeamRepository;
        }
        finally {
            this.release();
        }
    }

    public ITeamRepository getTeamRepository(String repositoryURI) {
        return this.getTeamRepository(repositoryURI, 0);
    }

    public ITeamRepository getUnmanagedRepository(String repositoryURI) {
        return this.getTeamRepository(repositoryURI, 3);
    }

    public ITeamRepository getTeamRepository(String repositoryURI, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.internalGetTeamRepository(repositoryURI, -1, monitor);
    }

    public ITeamRepository getTeamRepository(String repositoryURI, int timeoutInSeconds, IProgressMonitor monitor) throws TeamRepositoryException {
        if (timeoutInSeconds < 0) {
            throw new IllegalArgumentException();
        }
        return this.internalGetTeamRepository(repositoryURI, timeoutInSeconds, monitor);
    }

    public void addTeamRepository(ITeamRepository repository) {
        try {
            this.acquire();
            this.cleanOrphans();
            boolean found = false;
            for (WeakReference<ITeamRepository> reference : this.sharedRepositories) {
                ITeamRepository repo = (ITeamRepository)reference.get();
                if (repository != repo) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("repository instance must be a shared instance");
            }
            if (!this.cachedRepositories.contains(repository)) {
                this.cachedRepositories.add(repository);
                this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertyAdd", this, "repositories", null, repository));
            }
        }
        finally {
            this.release();
        }
    }

    public void removeTeamRepository(ITeamRepository repository) {
        try {
            this.acquire();
            this.cleanOrphans();
            boolean removed = this.cachedRepositories.remove(repository);
            if (removed) {
                this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertyRemove", this, "repositories", repository, null));
            }
        }
        finally {
            this.release();
        }
    }

    public void removeRepository(ITeamRepository repository) {
        this.removeTeamRepository(repository);
    }

    public ITeamRepository[] getTeamRepositories() {
        try {
            this.acquire();
            this.cleanOrphans();
            ITeamRepository[] iTeamRepositoryArray = this.cachedRepositories.toArray(new ITeamRepository[this.cachedRepositories.size()]);
            return iTeamRepositoryArray;
        }
        finally {
            this.release();
        }
    }

    public void addRepositoryServiceListener(ITeamRepositoryService.IRepositoryServiceListener listener) {
        this.addTypedListener("repositories", listener);
    }

    public void removeRepositoryServiceListener(ITeamRepositoryService.IRepositoryServiceListener listener) {
        this.removeTypedListener("repositories", listener);
    }

    public int getDefaultConnectionTimeout() {
        return TeamServerConfiguration.DEFAULT_SOCKET_TIMEOUT;
    }

    protected void dispatchEvents(Object typedListener, List events) {
        ITeamRepositoryService.IRepositoryServiceListener repositoryServiceListener = (ITeamRepositoryService.IRepositoryServiceListener)typedListener;
        for (IEvent event : events) {
            if (!(event instanceof IPropertyChangeEvent)) continue;
            IPropertyChangeEvent propertyChangeEvent = (IPropertyChangeEvent)event;
            if (event.getEventType() == "com.ibm.team.repository.PropertyAdd") {
                repositoryServiceListener.addedRepository((ITeamRepository)propertyChangeEvent.getNewValue());
                continue;
            }
            if (event.getEventType() != "com.ibm.team.repository.PropertyRemove") continue;
            repositoryServiceListener.removedRepository((ITeamRepository)propertyChangeEvent.getOldValue());
        }
    }

    private ITeamRepository internalGetTeamRepository(String repositoryURI, int timeoutInSeconds, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtil.beginMonitor(monitor, 100);
        try {
            ITeamRepository repository = this.getSharedTeamRepository(repositoryURI);
            if (repository == null) {
                UUID newRepoId = RepositoryUtil.getRepositoryId(repositoryURI);
                ITeamRepository tmpRepository = new TeamRepository(repositoryURI, true);
                ITeamRepository[] repositories = this.getTeamRepositories();
                int i = 0;
                while (i < repositories.length) {
                    ITeamRepository r = repositories[i];
                    if (r.getId() != null && r.getId().equals((Object)newRepoId)) {
                        repository = r;
                        repository.addAliasRepositoryURI(repositoryURI);
                        break;
                    }
                    ++i;
                }
                if (repository == null) {
                    tmpRepository.setUserId(new String());
                    tmpRepository.registerDefaultLoginHandler();
                    repository = tmpRepository;
                }
                try {
                    this.acquire();
                    tmpRepository = this.getSharedTeamRepository(repositoryURI);
                    if (tmpRepository != null) {
                        repository = tmpRepository;
                    }
                    this.shareTeamRepository(repository);
                }
                finally {
                    this.release();
                }
            } else {
                this.shareTeamRepository(repository);
            }
            if (timeoutInSeconds != -1) {
                repository.setConnectionTimeout(timeoutInSeconds);
            }
            ITeamRepository iTeamRepository = repository;
            return iTeamRepository;
        }
        finally {
            monitor.done();
        }
    }

    private ITeamRepository getSharedTeamRepository(String repositoryURI) {
        try {
            this.acquire();
            this.cleanOrphans();
            for (WeakReference<ITeamRepository> reference : this.sharedRepositories) {
                ITeamRepository repository = (ITeamRepository)reference.get();
                if (repository == null || !repository.getRepositoryURI().equals(repositoryURI) && !repository.getAliasRepositoryURIs().contains(repositoryURI)) continue;
                ITeamRepository iTeamRepository = repository;
                return iTeamRepository;
            }
            return null;
        }
        finally {
            this.release();
        }
    }

    private ITeamRepository createSharedTeamRepository(String repositoryURI, int flags) {
        try {
            this.acquire();
            this.cleanOrphans();
            TeamRepository repository = new TeamRepository(repositoryURI, (flags & 2) == 0);
            this.shareTeamRepository(repository);
            TeamRepository teamRepository = repository;
            return teamRepository;
        }
        finally {
            this.release();
        }
    }

    private void shareTeamRepository(ITeamRepository repository) {
        try {
            this.acquire();
            this.cleanOrphans();
            boolean found = false;
            for (WeakReference<ITeamRepository> reference : this.sharedRepositories) {
                if (reference.get() != repository) continue;
                found = true;
                break;
            }
            if (!found) {
                this.sharedRepositories.add(new WeakReference<ITeamRepository>(repository, this.referenceQueue));
            }
        }
        finally {
            this.release();
        }
    }

    private void cleanOrphans() {
        WeakReference reference;
        while ((reference = (WeakReference)this.referenceQueue.poll()) != null) {
            if (reference.get() != null) continue;
            this.sharedRepositories.remove(reference);
        }
    }

    private class EventListenerRegistry
    extends ExtensionReader {
        private static final String EXTENSION_POINT_ID = "eventListener";
        private final Map<IConfigurationElement, Descriptor> descriptors;

        private EventListenerRegistry() {
            super("com.ibm.team.repository.client", EXTENSION_POINT_ID);
            this.descriptors = new HashMap<IConfigurationElement, Descriptor>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean handleExtensionAdded(IConfigurationElement element) {
            if (element.getName().equals("listener")) {
                Descriptor descriptor = new Descriptor(element);
                Map<IConfigurationElement, Descriptor> map = this.descriptors;
                synchronized (map) {
                    this.descriptors.put(element, descriptor);
                    TeamRepositoryService.this.addGenericListener(descriptor.getEventCategory(), descriptor);
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean handleExtensionRemoved(IConfigurationElement element) {
            Descriptor descriptor = null;
            Map<IConfigurationElement, Descriptor> map = this.descriptors;
            synchronized (map) {
                descriptor = this.descriptors.remove(element);
                if (descriptor != null) {
                    String category = descriptor.getEventCategory();
                    TeamRepositoryService.this.removeGenericListener(descriptor.getEventCategory(), descriptor);
                    IListener listener = descriptor.getListener();
                    if (listener != null) {
                        TeamRepositoryService.this.removeGenericListener(category, listener);
                    }
                }
            }
            return descriptor != null;
        }

        private class Descriptor
        implements IListener {
            public static final String LISTENER = "listener";
            public static final String EVENT_CATEGORY = "eventCategory";
            public static final String LISTENER_CLASS = "listenerClass";
            private final IConfigurationElement element;
            private IListener listener = null;

            public Descriptor(IConfigurationElement element) {
                this.element = element;
            }

            public void handleEvents(List events) {
                IListener listener = this.createListener();
                if (listener != null) {
                    listener.handleEvents(events);
                    String category = this.getEventCategory();
                    TeamRepositoryService.this.removeGenericListener(category, this);
                    TeamRepositoryService.this.addGenericListener(this.getEventCategory(), listener);
                }
            }

            synchronized IListener createListener() {
                if (this.listener == null) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            log.error((Object)exception.getMessage(), exception);
                        }

                        public void run() throws Exception {
                            Descriptor.this.listener = (IListener)Descriptor.this.element.createExecutableExtension(Descriptor.LISTENER_CLASS);
                        }
                    });
                }
                return this.listener;
            }

            synchronized IListener getListener() {
                return this.listener;
            }

            public String getEventCategory() {
                return this.element.getAttribute(EVENT_CATEGORY);
            }
        }
    }
}

