/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.ExtensionReader;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class LoginHandlerExtensionReader
extends ExtensionReader {
    public static LoginHandlerExtensionReader INSTANCE = new LoginHandlerExtensionReader();
    private static final String EXTENSIONPOINT_ID = "loginHandler";
    protected static Log log = LogFactory.getLog(LoginHandlerExtensionReader.class);
    private final List<Descriptor> loginHandlers = new ArrayList<Descriptor>();

    private LoginHandlerExtensionReader() {
        super("com.ibm.team.repository.client", EXTENSIONPOINT_ID);
        this.earlyStart();
    }

    protected boolean handleExtensionAdded(IConfigurationElement element) {
        if (element.getName().equals("handler")) {
            Descriptor descriptor = new Descriptor(element);
            this.loginHandlers.add(descriptor);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleExtensionRemoved(IConfigurationElement element) {
        String key = Descriptor.getLoginHandlerClassName(element);
        Descriptor value = null;
        List<Descriptor> list = this.loginHandlers;
        synchronized (list) {
            int size = this.loginHandlers.size();
            int index = 0;
            boolean found = false;
            while (index < size) {
                Descriptor descriptor = this.loginHandlers.get(index);
                String loginHandlerClassName = descriptor.getLoginHandlerClassName();
                found = loginHandlerClassName.equals(key);
                if (found) break;
                ++index;
            }
            if (found) {
                value = this.loginHandlers.remove(index);
            }
        }
        boolean valid = value != null;
        return valid;
    }

    public Descriptor[] getLoginHandlers() {
        return this.loginHandlers.toArray(new Descriptor[this.loginHandlers.size()]);
    }

    public static class Descriptor {
        private IConfigurationElement element = null;
        private ITeamRepository.ILoginHandler handler;
        private IOAuthHandler oauthHandler;
        private int priority = 0;
        public static final String HANDLER = "handler";
        public static final String CLASS = "class";
        public static final String OAUTH_HANDLER_CLASS = "oauthHandlerClass";
        public static final String PRIORITY = "priority";

        private static String getLoginHandlerClassName(IConfigurationElement element) {
            String value = element.getAttribute(CLASS);
            return value;
        }

        public Descriptor(IConfigurationElement element) {
            this.element = element;
        }

        public IConfigurationElement getElement() {
            return this.element;
        }

        public IOAuthHandler getOAuthHandler() {
            if (this.oauthHandler == null) {
                try {
                    this.oauthHandler = (IOAuthHandler)this.element.createExecutableExtension(OAUTH_HANDLER_CLASS);
                }
                catch (CoreException e) {
                    this.handler = null;
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return this.oauthHandler;
        }

        public ITeamRepository.ILoginHandler getLoginHandler() {
            if (this.handler == null) {
                try {
                    this.handler = (ITeamRepository.ILoginHandler)this.element.createExecutableExtension(CLASS);
                }
                catch (CoreException e) {
                    this.handler = null;
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return this.handler;
        }

        private String getLoginHandlerClassName() {
            IConfigurationElement element = this.getElement();
            String value = element.getAttribute(CLASS);
            return value;
        }

        public int getPriority() {
            if (this.priority == 0) {
                String number = this.element.getAttribute(PRIORITY);
                try {
                    this.priority = Integer.parseInt(number);
                    if (this.priority < 0) {
                        this.priority = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.priority = 0;
                }
            }
            return this.priority;
        }
    }
}

