/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.internal.ConnectionUtil;
import com.ibm.team.repository.client.internal.SharedItemChangeEvent;
import com.ibm.team.repository.client.internal.TeamPlatformObject;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.internal.property.RepositoryClientProperties;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemStore;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.FetchResult;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ItemManager
extends TeamPlatformObject
implements IItemManager {
    private static final Log log = LogFactory.getLog((String)"com.ibm.team.repository");
    private static final boolean useItemRest = RepositoryClientProperties.INSTANCE.getBooleanProperty("com.ibm.team.repository.client.internal.useItemRest", false);
    private final CurrentStore currentStore = new CurrentStore();
    private final StateStore stateStore = new StateStore();

    static {
        if (useItemRest && log.isInfoEnabled()) {
            log.info((Object)"ItemManager will use REST services for item retrieval");
        }
    }

    ItemManager(TeamRepository repository) {
        super(repository);
    }

    public void addItemChangeListener(IItem sharedItem, ISharedItemChangeListener listener) {
        this.addTypedListener(sharedItem.getItemId(), listener);
    }

    public void addItemChangeListener(IItemType itemType, ISharedItemChangeListener listener) {
        this.addTypedListener(itemType, listener);
    }

    public void applyItemDeletes(List itemHandles) {
        this.validateItemHandles(itemHandles);
        try {
            this.acquire();
            this.applyDeletes(itemHandles);
        }
        finally {
            this.release();
        }
    }

    public List applyItemUpdates(List itemStates) {
        return this.applyItemUpdates(itemStates, true);
    }

    private List applyItemUpdates(List itemStates, boolean ignoreStateOrderLogic) {
        List newItemStates = this.getItemStatesToUpdate(itemStates);
        try {
            this.acquire();
            List list = this.applyNewStates(newItemStates, ignoreStateOrderLogic);
            return list;
        }
        finally {
            this.release();
        }
    }

    public List applyItemUpdatesAndDeletes(List itemStatesToUpdate, List itemHandlesToDelete) {
        return this.applyItemUpdatesAndDeletes(itemStatesToUpdate, itemHandlesToDelete, true);
    }

    private List applyItemUpdatesAndDeletes(List itemStatesToUpdate, List itemHandlesToDelete, boolean ignoreStateOrderLogic) {
        List newItemStates = this.getItemStatesToUpdate(itemStatesToUpdate);
        this.validateItemHandles(itemHandlesToDelete);
        try {
            this.acquire();
            List appliedStates = this.applyNewStates(newItemStates, ignoreStateOrderLogic);
            this.applyDeletes(itemHandlesToDelete);
            List list = appliedStates;
            return list;
        }
        finally {
            this.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List applyItemUpdatesOrRefresh(List itemStates, IProgressMonitor monitor) throws TeamRepositoryException {
        IItem newItemState;
        ArrayList<IItemHandle> itemsToRefresh = new ArrayList<IItemHandle>(itemStates.size());
        HashSet propertiesToRefresh = new HashSet();
        ArrayList newItemStates = new ArrayList();
        try {
            this.acquire();
            newItemStates.addAll(this.applyItemUpdates(itemStates, false));
            Iterator i = itemStates.iterator();
            Iterator j = newItemStates.iterator();
            while (i.hasNext() && j.hasNext()) {
                IItem itemState = (IItem)i.next();
                newItemState = (IItem)j.next();
                if (newItemState != null) continue;
                IItemHandle itemHandle = itemState.getItemHandle();
                itemsToRefresh.add(itemHandle);
                Set properties = ItemStore.getProperties((IItem)itemState);
                if (propertiesToRefresh == null) continue;
                if (properties == null) {
                    propertiesToRefresh = null;
                    continue;
                }
                propertiesToRefresh.addAll(properties);
            }
        }
        finally {
            this.release();
        }
        if (!itemsToRefresh.isEmpty()) {
            IFetchResult fetchResult = this.currentStore.fetchItems(itemsToRefresh, true, propertiesToRefresh, monitor);
            List refreshedItems = this.buildListFromFetchResult(fetchResult, itemStates, false);
            int j = 0;
            while (j < newItemStates.size()) {
                newItemState = (IItem)newItemStates.get(j);
                if (newItemState == null) {
                    newItemStates.set(j, refreshedItems.get(j));
                }
                ++j;
            }
        }
        return newItemStates;
    }

    public List fetchAllStateHandles(final IAuditableHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandle == null) {
            throw new IllegalArgumentException("itemHandle must not be null");
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<List>(){

            @Override
            public List run(IProgressMonitor monitor) throws TeamRepositoryException {
                return Collections.unmodifiableList(Arrays.asList(ItemManager.this.getServerRepositoryRemoteService().fetchAllStates(itemHandle)));
            }
        }, monitor);
    }

    public IItem fetchCompleteItem(IItemHandle itemHandle, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandle == null) {
            throw new IllegalArgumentException("itemHandle must not be null");
        }
        if ((flags & 2) != 0) {
            return this.internalFetchItem((IManagedItemHandle)itemHandle, null, monitor);
        }
        return this.currentStore.fetchItem((IManagedItemHandle)itemHandle, (flags & 1) != 0, null, monitor);
    }

    public IItem fetchCompleteItem(Location location, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (location == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        monitor = ClientUtil.beginMonitor(monitor, 100);
        try {
            IManagedItem item = this.internalFetchItem(location, null, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if ((flags & 2) != 0) {
                IManagedItem iManagedItem = item;
                return iManagedItem;
            }
            List items = this.applyItemUpdatesOrRefresh(Collections.singletonList(item), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (items.size() == 1 && (item = (IItem)items.get(0)) != null) {
                IManagedItem iManagedItem = item;
                return iManagedItem;
            }
            throw new ItemNotFoundException(location.toString());
        }
        finally {
            monitor.done();
        }
    }

    private List buildListFromFetchResult(IFetchResult fetchResult, List itemHandles, boolean useItemId) {
        return this.addDuplicates(itemHandles, fetchResult.getRetrievedItems(), useItemId);
    }

    public List fetchCompleteItems(List itemHandles, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        this.validateItemHandles(itemHandles);
        if ((flags & 2) != 0) {
            return this.buildListFromFetchResult(this.internalFetchItems(itemHandles, null, monitor), itemHandles, true);
        }
        return this.buildListFromFetchResult(this.currentStore.fetchItems(itemHandles, (flags & 1) != 0, null, monitor), itemHandles, true);
    }

    public IFetchResult fetchCompleteItemsPermissionAware(List itemHandles, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        this.validateItemHandles(itemHandles);
        if ((flags & 2) != 0) {
            return this.internalFetchItems(itemHandles, null, monitor);
        }
        return this.currentStore.fetchItems(itemHandles, (flags & 1) != 0, null, monitor);
    }

    private IItemHandle[] getHandleList(List locations, IProgressMonitor monitor) throws TeamRepositoryException {
        if (locations == null) {
            throw new IllegalArgumentException("locations must not be null");
        }
        final String[] uris = new String[locations.size()];
        int locNdx = 0;
        for (Object locObj : locations) {
            if (!(locObj instanceof Location)) {
                throw new IllegalArgumentException("List must contain Location");
            }
            uris[locNdx++] = ((Location)locObj).toRelativeUri().toString();
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IItemHandle[]>(){

            @Override
            public IItemHandle[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ItemManager.this.getServerRepositoryRemoteService().fetchHandlesByLocation(uris);
            }
        }, monitor);
    }

    public List fetchCompleteItemsByLocation(List locations, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtil.beginMonitor(monitor, locations.size() * 2);
        try {
            IItemHandle[] handles = this.getHandleList(locations, monitor);
            ArrayList handleList = this.copyHandles(handles, true);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, locations.size());
            List fetchList = this.fetchCompleteItems(handleList, flags, (IProgressMonitor)subMonitor);
            ArrayList arrayList = this.copyItemList(handles, fetchList);
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public IFetchResult fetchCompleteItemsByLocationPermissionAware(List locations, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtil.beginMonitor(monitor, locations.size() * 2);
        try {
            IItemHandle[] handles = this.getHandleList(locations, monitor);
            ArrayList handleList = this.copyHandles(handles, true);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, locations.size());
            IFetchResult handleFetchResult = this.fetchCompleteItemsPermissionAware(handleList, flags, (IProgressMonitor)subMonitor);
            LocationFetchResult result = new LocationFetchResult();
            result.getRetrievedItems().addAll(handleFetchResult.getRetrievedItems());
            if (!handleFetchResult.getPermissionDeniedItems().isEmpty() || !handleFetchResult.getNotFoundItems().isEmpty()) {
                HashMap handleMap = new HashMap(handles.length);
                int i = 0;
                while (i < handles.length) {
                    handleMap.put(handles[i].getItemId(), locations.get(i));
                    ++i;
                }
                result.populatePermissionDenied(handleFetchResult.getPermissionDeniedItems(), handleMap);
                result.populateNotFound(handleFetchResult.getNotFoundItems(), handleMap);
            }
            result.getNotFoundItems().addAll(this.getNotFoundLocations(locations, handles));
            LocationFetchResult locationFetchResult = result;
            return locationFetchResult;
        }
        finally {
            monitor.done();
        }
    }

    private List getNotFoundLocations(List locations, IItemHandle[] handles) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < handles.length) {
            if (handles[i] == null) {
                result.add(locations.get(i));
            }
            ++i;
        }
        return result;
    }

    public IAuditable fetchCompleteState(IAuditableHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandle == null || itemHandle.getStateId() == null) {
            throw new IllegalArgumentException("itemHandle must not be null and must not have a null state id");
        }
        return (IAuditable)this.stateStore.fetchItem((IManagedItemHandle)itemHandle, false, null, monitor);
    }

    public IAuditable fetchCompleteState(Location location, IProgressMonitor monitor) throws TeamRepositoryException {
        if (location == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        IItemHandle itemHandle = location.getItemHandle();
        if (itemHandle == null || itemHandle.getStateId() == null) {
            throw new IllegalArgumentException("itemHandle must not be null and must not have a null state id");
        }
        if (!(itemHandle instanceof IAuditableHandle)) {
            String message = String.format("itemHandle is not an instance of '%s': '%s'", IAuditableHandle.class, itemHandle);
            throw new IllegalArgumentException(message);
        }
        return this.fetchCompleteState((IAuditableHandle)itemHandle, monitor);
    }

    public List fetchCompleteStates(List itemHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        this.validateStateHandles(itemHandles);
        return this.buildListFromFetchResult(this.stateStore.fetchItems(itemHandles, false, null, monitor), itemHandles, false);
    }

    public IFetchResult fetchCompleteStatesPermissionAware(List itemHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        this.validateStateHandles(itemHandles);
        return this.stateStore.fetchItems(itemHandles, false, null, monitor);
    }

    public IItem fetchPartialItem(IItemHandle itemHandle, int flags, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandle == null) {
            throw new IllegalArgumentException("itemHandle must not be null");
        }
        if (requiredProperties == null) {
            requiredProperties = Collections.EMPTY_LIST;
        }
        if ((flags & 2) != 0) {
            return this.internalFetchItem((IManagedItemHandle)itemHandle, new HashSet(requiredProperties), monitor);
        }
        return this.currentStore.fetchItem((IManagedItemHandle)itemHandle, (flags & 1) != 0, new HashSet(requiredProperties), monitor);
    }

    public IItem fetchPartialItem(Location location, int flags, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        if (location == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        if (requiredProperties == null) {
            requiredProperties = Collections.EMPTY_LIST;
        }
        monitor = ClientUtil.beginMonitor(monitor, 100);
        try {
            IManagedItem item = this.internalFetchItem(location, new HashSet(requiredProperties), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if ((flags & 2) != 0) {
                IManagedItem iManagedItem = item;
                return iManagedItem;
            }
            List items = this.applyItemUpdatesOrRefresh(Collections.singletonList(item), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (items.size() == 1 && (item = (IItem)items.get(0)) != null) {
                IManagedItem iManagedItem = item;
                return iManagedItem;
            }
            throw new ItemNotFoundException(location.toString());
        }
        finally {
            monitor.done();
        }
    }

    public List fetchPartialItems(List itemHandles, int flags, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        this.validateItemHandles(itemHandles);
        if ((flags & 2) != 0) {
            List items = this.internalFetchItems(itemHandles, new HashSet(requiredProperties), monitor).getRetrievedItems();
            return Collections.unmodifiableList(this.addDuplicates(itemHandles, items, true));
        }
        if (requiredProperties == null) {
            requiredProperties = Collections.EMPTY_LIST;
        }
        return this.buildListFromFetchResult(this.currentStore.fetchItems(itemHandles, (flags & 1) != 0, new HashSet(requiredProperties), monitor), itemHandles, true);
    }

    public IFetchResult fetchPartialItemsPermissionAware(List itemHandles, int flags, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        this.validateItemHandles(itemHandles);
        if ((flags & 2) != 0) {
            return this.internalFetchItems(itemHandles, new HashSet(requiredProperties), monitor);
        }
        if (requiredProperties == null) {
            requiredProperties = Collections.EMPTY_LIST;
        }
        return this.currentStore.fetchItems(itemHandles, (flags & 1) != 0, new HashSet(requiredProperties), monitor);
    }

    public List fetchPartialItemsByLocation(List locations, int flags, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtil.beginMonitor(monitor, locations.size() * 2);
        try {
            IItemHandle[] handles = this.getHandleList(locations, monitor);
            ArrayList handleList = this.copyHandles(handles, true);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, locations.size());
            List fetchList = this.fetchPartialItems(handleList, flags, requiredProperties, (IProgressMonitor)subMonitor);
            ArrayList arrayList = this.copyItemList(handles, fetchList);
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public IFetchResult fetchPartialItemsByLocationPermissionAware(List locations, int flags, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtil.beginMonitor(monitor, locations.size() * 2);
        try {
            IItemHandle[] handles = this.getHandleList(locations, monitor);
            ArrayList handleList = this.copyHandles(handles, true);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, locations.size());
            IFetchResult handleFetchResult = this.fetchPartialItemsPermissionAware(handleList, flags, requiredProperties, (IProgressMonitor)subMonitor);
            LocationFetchResult result = new LocationFetchResult();
            result.getRetrievedItems().addAll(handleFetchResult.getRetrievedItems());
            if (!handleFetchResult.getPermissionDeniedItems().isEmpty() || !handleFetchResult.getNotFoundItems().isEmpty()) {
                HashMap handleMap = new HashMap(handles.length);
                int i = 0;
                while (i < handles.length) {
                    handleMap.put(handles[i].getItemId(), locations.get(i));
                    ++i;
                }
                result.populatePermissionDenied(handleFetchResult.getPermissionDeniedItems(), handleMap);
                result.populateNotFound(handleFetchResult.getNotFoundItems(), handleMap);
            }
            result.getNotFoundItems().addAll(this.getNotFoundLocations(locations, handles));
            LocationFetchResult locationFetchResult = result;
            return locationFetchResult;
        }
        finally {
            monitor.done();
        }
    }

    public IAuditable fetchPartialState(IAuditableHandle itemHandle, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandle == null || itemHandle.getStateId() == null) {
            throw new IllegalArgumentException("itemHandle must not be null and must not have a null state id");
        }
        if (requiredProperties == null) {
            requiredProperties = Collections.EMPTY_LIST;
        }
        return (IAuditable)this.stateStore.fetchItem((IManagedItemHandle)itemHandle, false, new HashSet(requiredProperties), monitor);
    }

    public IAuditable fetchPartialState(Location location, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        if (location == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        IItemHandle itemHandle = location.getItemHandle();
        if (itemHandle == null || itemHandle.getStateId() == null) {
            throw new IllegalArgumentException("itemHandle must not be null and must not have a null state id");
        }
        if (!(itemHandle instanceof IAuditableHandle)) {
            String message = String.format("itemHandle is not an instance of '%s': '%s' ", IAuditableHandle.class, itemHandle);
            throw new IllegalArgumentException(message);
        }
        if (requiredProperties == null) {
            requiredProperties = Collections.EMPTY_LIST;
        }
        return this.fetchPartialState((IAuditableHandle)itemHandle, requiredProperties, monitor);
    }

    public List fetchPartialStates(List itemHandles, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        this.validateStateHandles(itemHandles);
        if (requiredProperties == null) {
            requiredProperties = Collections.EMPTY_LIST;
        }
        return this.buildListFromFetchResult(this.stateStore.fetchItems(itemHandles, false, new HashSet(requiredProperties), monitor), itemHandles, false);
    }

    public IFetchResult fetchPartialStatesPermissionAware(List itemHandles, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        this.validateStateHandles(itemHandles);
        if (requiredProperties == null) {
            requiredProperties = Collections.EMPTY_LIST;
        }
        return this.stateStore.fetchItems(itemHandles, false, new HashSet(requiredProperties), monitor);
    }

    public IItem getImmutableState(IItem sharedItem) {
        if (sharedItem == null) {
            throw new IllegalArgumentException("sharedItem must not be null");
        }
        IItem immutableItem = ItemStore.getImmutableItem((IItem)sharedItem);
        if (immutableItem != null && immutableItem.getOrigin() == this.teamRepository()) {
            return immutableItem;
        }
        return null;
    }

    public List getKnownSharedItems(IItemType itemType) {
        if (itemType == null) {
            throw new IllegalArgumentException("itemType must not be null");
        }
        return this.currentStore.getItems(itemType);
    }

    public IItem getSharedItemIfKnown(IItemHandle itemHandle) {
        if (itemHandle == null) {
            throw new IllegalArgumentException("itemHandle must not be null");
        }
        return this.currentStore.getItem(itemHandle);
    }

    public void purgeItemChangeListener(ISharedItemChangeListener listener) {
        this.purgeTypedListener(listener);
    }

    public void refreshSharedItems(List sharedItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (sharedItems == null) {
            throw new IllegalArgumentException("sharedItems must not be null");
        }
        for (Object element : sharedItems) {
            if (element == null) {
                throw new IllegalArgumentException("sharedItems contains a null element");
            }
            if (element instanceof IItem) continue;
            String message = String.format("element is not an instance of '%s': '%s'", IItem.class, element);
            throw new IllegalArgumentException(message);
        }
        if (sharedItems.size() == 1) {
            this.currentStore.refreshItem((IManagedItemHandle)sharedItems.get(0), monitor);
        } else {
            this.currentStore.refreshItems(sharedItems, monitor);
        }
    }

    public void removeItemChangeListener(IItem sharedItem, ISharedItemChangeListener listener) {
        this.removeTypedListener(sharedItem.getItemId(), listener);
    }

    public void removeItemChangeListener(IItemType itemType, ISharedItemChangeListener listener) {
        this.removeTypedListener(itemType, listener);
    }

    protected void dispatchEvents(Object listener, List events) {
        ISharedItemChangeListener itemChangeListener = (ISharedItemChangeListener)listener;
        itemChangeListener.itemsChanged(events);
    }

    private List addDuplicates(List duplicateHandles, List cleanedupItems, boolean useItemId) {
        UUID key;
        ArrayList duplicateItems = new ArrayList(duplicateHandles.size());
        HashMap<UUID, IManagedItem> visited = new HashMap<UUID, IManagedItem>();
        for (IManagedItem item : cleanedupItems) {
            if (item == null) continue;
            key = useItemId ? item.getItemId() : ((IAuditableHandle)item).getStateId();
            visited.put(key, item);
        }
        for (IManagedItemHandle itemHandle : duplicateHandles) {
            if (itemHandle == null) {
                duplicateItems.add(null);
                continue;
            }
            key = useItemId ? itemHandle.getItemId() : ((IAuditableHandle)itemHandle).getStateId();
            duplicateItems.add(visited.get(key));
        }
        return duplicateItems;
    }

    private void applyDeletes(List itemHandles) {
        Set itemIds;
        IItemType itemType;
        this.currentStore.removeItems(itemHandles);
        IdentityHashMap itemTypes = new IdentityHashMap();
        for (IManagedItemHandle iManagedItemHandle : itemHandles) {
            itemType = iManagedItemHandle.getItemType();
            itemIds = (HashSet<UUID>)itemTypes.get(itemType);
            if (itemIds == null) {
                itemIds = new HashSet<UUID>();
                itemTypes.put(itemType, itemIds);
            }
            itemIds.add(iManagedItemHandle.getItemId());
        }
        for (Map.Entry entry : itemTypes.entrySet()) {
            itemType = (IItemType)entry.getKey();
            itemIds = (Set)entry.getValue();
            List states = this.stateStore.getItems(itemType);
            for (IManagedItem state : states) {
                if (!itemIds.contains(state.getItemId())) continue;
                this.stateStore.removeItem(state.getStateHandle());
            }
        }
    }

    private List applyNewStates(List newItemStates, boolean ignoreStateOrderLogic) {
        return this.currentStore.putItems(newItemStates, ignoreStateOrderLogic);
    }

    private ArrayList copyHandles(IItemHandle[] handles, boolean ignoreNull) {
        ArrayList<IItemHandle> handleList = new ArrayList<IItemHandle>(handles.length);
        IItemHandle[] iItemHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle handle = iItemHandleArray[n2];
            if (handle == null && !ignoreNull) {
                handleList.add(null);
            } else if (handle != null) {
                handleList.add(handle);
            }
            ++n2;
        }
        return handleList;
    }

    private ArrayList copyItemList(IItemHandle[] handles, List itemList) {
        int fetchNdx = 0;
        ArrayList<IItem> returnList = new ArrayList<IItem>(handles.length);
        IItemHandle[] iItemHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle handle = iItemHandleArray[n2];
            IItem item = null;
            if (handle != null) {
                item = (IItem)itemList.get(fetchNdx++);
            }
            returnList.add(item);
            ++n2;
        }
        return returnList;
    }

    private List getItemStatesToUpdate(List itemStates) {
        if (itemStates == null) {
            throw new IllegalArgumentException("itemStates must not be null");
        }
        ArrayList<IManagedItem> newItemStates = new ArrayList<IManagedItem>(itemStates.size());
        for (Object element : itemStates) {
            if (element == null) {
                throw new IllegalArgumentException("itemStates contains a null element");
            }
            if (!(element instanceof IManagedItem)) {
                String message = String.format("element is not an instance of '%s': '%s'", IManagedItem.class, element);
                throw new IllegalArgumentException(message);
            }
            IManagedItem item = (IManagedItem)ItemStore.getImmutableItem((IItem)((IManagedItem)element));
            if (item == null) {
                item = (IManagedItem)element;
            }
            item = (IManagedItem)EcoreUtil.copy((EObject)((EObject)item));
            newItemStates.add(item);
            Object oldOrigin = item.getOrigin();
            if (oldOrigin != null && oldOrigin != this.teamRepository()) {
                throw new IllegalArgumentException("element is from a different repository");
            }
            ClientUtil.makeImmutable(this.teamRepository(), (IItemHandle)item);
        }
        return newItemStates;
    }

    private String[] getMinimalProperties(IItemType itemType, Set properties) {
        if (properties == null) {
            return null;
        }
        List minimalProperties = ItemUtil.getMinimalPropertyNames((ItemType)((ItemType)itemType));
        if (properties.containsAll(minimalProperties)) {
            return properties.toArray(new String[properties.size()]);
        }
        HashSet actualProperties = new HashSet(properties);
        actualProperties.addAll(minimalProperties);
        return actualProperties.toArray(new String[actualProperties.size()]);
    }

    private IManagedItem internalFetchItem(IManagedItemHandle itemHandle, final Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
        final IManagedItemHandle itemHandleToFetch = itemHandle instanceof IManagedItem ? (IManagedItemHandle)((IManagedItem)itemHandle).getItemHandle() : (itemHandle.hasStateId() ? (IManagedItemHandle)itemHandle.getItemType().createItemHandle(itemHandle.getItemId(), null) : itemHandle);
        if (useItemRest) {
            Location location = Location.itemLocation((IItemHandle)itemHandle, (String)this.teamRepository().getRepositoryURI());
            return this.internalFetchRest(location, true, monitor);
        }
        FetchResult result = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<FetchResult>(){

            @Override
            public FetchResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ItemManager.this.getServerRepositoryRemoteService().fetchOrRefreshItems((IItemHandle[])new IManagedItemHandle[]{itemHandleToFetch}, ItemManager.this.getMinimalProperties(itemHandleToFetch.getItemType(), properties));
            }
        }, monitor);
        List items = result.getRetrievedItems();
        IManagedItem item = null;
        boolean permissionDenied = false;
        if (items.size() == 1) {
            item = (IManagedItem)items.get(0);
        } else if (result.getPermissionDeniedItems().size() > 0) {
            permissionDenied = true;
        }
        ClientUtil.detachItems((EObject)result);
        if (item != null) {
            return item;
        }
        if (permissionDenied) {
            throw new PermissionDeniedException(this.buildPermissionDeniedMessage((IItemHandle)itemHandle));
        }
        throw new ItemNotFoundException((IItemHandle)itemHandle);
    }

    private String buildPermissionDeniedMessage(IItemHandle handle) {
        String userid = this.teamRepository().getUserId();
        String pattern = Messages.getServerString("ItemManager.ItemFetchReadAccessError");
        String message = NLS.bind((String)pattern, (Object)userid, (Object[])new Object[]{handle.getItemType().getName()});
        return message;
    }

    private IManagedItem internalFetchItem(Location location, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
        if (location == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        IManagedItemHandle itemHandle = (IManagedItemHandle)location.getItemHandle();
        if (itemHandle != null) {
            return this.internalFetchItem(itemHandle, properties, monitor);
        }
        return this.internalFetchRest(location, true, monitor);
    }

    private IFetchResult internalFetchItems(List itemHandles, final Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
        List cleanedupItemHandles = this.removeDuplicates(itemHandles, true);
        final ArrayList<Object> itemHandlesToFetch = new ArrayList<Object>(cleanedupItemHandles.size());
        IItemType commonItemType = null;
        for (Object object : cleanedupItemHandles) {
            IManagedItemHandle itemHandle = (IManagedItemHandle)object;
            IItemType itemType = itemHandle.getItemType();
            if (commonItemType == null) {
                commonItemType = itemType;
            }
            if (properties != null && !properties.isEmpty() && itemType != commonItemType) {
                throw new IllegalArgumentException("item handles must be of the same type for partial fetch");
            }
            if (itemHandle instanceof IManagedItem) {
                itemHandlesToFetch.add(((IManagedItem)itemHandle).getItemHandle());
                continue;
            }
            if (itemHandle.hasStateId()) {
                itemHandlesToFetch.add(itemHandle.getItemType().createItemHandle(itemHandle.getItemId(), null));
                continue;
            }
            itemHandlesToFetch.add(itemHandle);
        }
        IFetchResult result = null;
        if (useItemRest) {
            result = this.internalFetchItemsRest(itemHandlesToFetch, monitor);
        } else {
            final IItemType finalCommonItemType = commonItemType;
            result = RepositoryFactory.eINSTANCE.createFetchResult();
            int left = itemHandlesToFetch.size();
            int i = 0;
            while (left > 0) {
                final int from = i * 1024;
                final int size = Math.min(1024, left);
                FetchResult thisResult = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<FetchResult>(){

                    @Override
                    public FetchResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                        return ItemManager.this.getServerRepositoryRemoteService().fetchOrRefreshItems((IItemHandle[])itemHandlesToFetch.subList(from, from + size).toArray(new IManagedItemHandle[size]), ItemManager.this.getMinimalProperties(finalCommonItemType, properties));
                    }
                }, monitor);
                result.getRetrievedItems().addAll(thisResult.getRetrievedItems());
                result.getNotFoundItems().addAll(thisResult.getNotFoundItems());
                result.getPermissionDeniedItems().addAll(thisResult.getPermissionDeniedItems());
                ClientUtil.detachItems((EObject)thisResult);
                left -= size;
                ++i;
            }
        }
        return result;
    }

    private IFetchResult internalFetchItemsRest(List itemHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtil.beginMonitor(monitor, itemHandles.size());
        try {
            FetchResult result = RepositoryFactory.eINSTANCE.createFetchResult();
            for (IManagedItemHandle itemHandle : itemHandles) {
                Location location = Location.itemLocation((IItemHandle)itemHandle, (String)this.teamRepository().getRepositoryURI());
                try {
                    result.getRetrievedItems().add(this.internalFetchRest(location, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    result.getNotFoundItems().add(itemHandle);
                }
                catch (PermissionDeniedException permissionDeniedException) {
                    result.getPermissionDeniedItems().add(itemHandle);
                }
            }
            FetchResult fetchResult = result;
            return fetchResult;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IManagedItem internalFetchRest(Location location, boolean throwNotFound, IProgressMonitor monitor) throws TeamRepositoryException {
        if (location == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        ITeamRestServiceClient restClient = this.getItemRestService();
        if (restClient == null) {
            throw new IllegalStateException("restClient must not be null");
        }
        Throwable throwable = null;
        TeamRepository repo = (TeamRepository)this.teamRepository();
        repo.setErrorState(0, null);
        final ITeamRestServiceClient.IRestClientConnection connection = restClient.getConnection(location);
        try {
            ITeamRestServiceClient.IRestClientConnection.Response response;
            IManagedItemHandle itemHandle = (IManagedItemHandle)location.getItemHandle();
            IManagedItem item = null;
            if (itemHandle != null && (item = (IManagedItem)itemHandle.getFullState()) != null && item.isComplete() && itemHandle.getStateId() != null) {
                connection.addRequestHeader("If-None-Match", itemHandle.getStateId().getUuidValue());
            }
            if ((response = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ITeamRestServiceClient.IRestClientConnection.Response>(){

                @Override
                public ITeamRestServiceClient.IRestClientConnection.Response run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    try {
                        progressMonitor.beginTask(null, -1);
                        ITeamRestServiceClient.IRestClientConnection.Response response = connection.doGet();
                        return response;
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            }, monitor)).getStatusCode() == ITeamRestServiceClient.IRestClientConnection.Response.StatusCode.NOT_MODIFIED) {
                item = (IManagedItem)EcoreUtil.copy((EObject)((EObject)item));
                ClientUtil.makeImmutable(this.teamRepository(), (IItemHandle)item);
                IManagedItem iManagedItem = item;
                return iManagedItem;
            }
            item = (IManagedItem)connection.unmarshall(response.getResponseStream());
            ClientUtil.makeImmutable(this.teamRepository(), (IItemHandle)item);
            IManagedItem iManagedItem = item;
            return iManagedItem;
        }
        catch (ItemNotFoundException e) {
            if (!throwNotFound) return null;
            throwable = e;
            throw e;
        }
        catch (AuthenticationException e) {
            if (!throwNotFound) return null;
            PermissionDeniedException pde = new PermissionDeniedException(e.getMessage(), (Throwable)e);
            throwable = pde;
            throw pde;
        }
        finally {
            if (throwable != null && throwable instanceof TeamRepositoryException) {
                TeamRepositoryException e = (TeamRepositoryException)throwable;
                e.setData((Object)location.getItemHandle());
                e.setOrigin((Object)repo);
                ConnectionUtil.setConnectionError((Exception)((Object)e), repo);
            }
            if (connection != null) {
                connection.release();
            }
        }
    }

    private IAuditable internalFetchState(IAuditableHandle itemHandle, final Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditable auditable;
        final IAuditableHandle itemHandleToFetch = itemHandle instanceof IAuditable ? (IAuditableHandle)((IAuditable)itemHandle).getStateHandle() : itemHandle;
        if (useItemRest) {
            return this.internalFetchStateRest(itemHandleToFetch, true, monitor);
        }
        FetchResult states = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<FetchResult>(){

            @Override
            public FetchResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ItemManager.this.getServerRepositoryRemoteService().fetchStates(new IAuditableHandle[]{itemHandleToFetch}, ItemManager.this.getMinimalProperties(itemHandleToFetch.getItemType(), properties));
            }
        }, monitor);
        if (states.getRetrievedItems().size() == 1 && (auditable = (IAuditable)states.getRetrievedItems().get(0)) != null) {
            return auditable;
        }
        if (states.getPermissionDeniedItems().size() > 0) {
            throw new PermissionDeniedException(this.buildPermissionDeniedMessage((IItemHandle)itemHandle));
        }
        throw new ItemNotFoundException((IItemHandle)itemHandle);
    }

    private IAuditable internalFetchStateRest(IAuditableHandle itemHandle, boolean throwNotFound, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandle == null) {
            throw new IllegalArgumentException("itemHandle must not be null");
        }
        Location location = Location.stateLocation((IItemHandle)itemHandle, (String)this.teamRepository().getRepositoryURI());
        return (IAuditable)this.internalFetchRest(location, throwNotFound, monitor);
    }

    private IFetchResult internalFetchStates(List itemHandles, final Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
        List cleanedupItemHandles = this.removeDuplicates(itemHandles, false);
        final ArrayList<Object> itemHandlesToFetch = new ArrayList<Object>(cleanedupItemHandles.size());
        IItemType commonItemType = null;
        for (Object object : cleanedupItemHandles) {
            if (object instanceof IAuditableHandle) {
                IAuditableHandle itemHandle = (IAuditableHandle)object;
                IItemType itemType = itemHandle.getItemType();
                if (commonItemType == null) {
                    commonItemType = itemType;
                }
                if (properties != null && !properties.isEmpty() && itemType != commonItemType) {
                    throw new IllegalArgumentException("item handles must be of the same type for partial fetch");
                }
                if (itemHandle instanceof IAuditable) {
                    itemHandlesToFetch.add(((IAuditable)itemHandle).getStateHandle());
                    continue;
                }
                itemHandlesToFetch.add(itemHandle);
                continue;
            }
            String message = String.format("element is not an instance of '%s': '%s'", IAuditableHandle.class, object);
            throw new IllegalArgumentException(message);
        }
        IFetchResult result = null;
        if (useItemRest) {
            result = this.internalFetchStatesRest(itemHandlesToFetch, monitor);
        } else {
            final IItemType finalCommonItemType = commonItemType;
            result = RepositoryFactory.eINSTANCE.createFetchResult();
            int left = itemHandlesToFetch.size();
            int i = 0;
            while (left > 0) {
                final int from = i * 1024;
                final int size = Math.min(1024, left);
                FetchResult thisResult = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<FetchResult>(){

                    @Override
                    public FetchResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                        return ItemManager.this.getServerRepositoryRemoteService().fetchStates(itemHandlesToFetch.subList(from, from + size).toArray(new IAuditableHandle[size]), ItemManager.this.getMinimalProperties(finalCommonItemType, properties));
                    }
                }, monitor);
                result.getRetrievedItems().addAll(thisResult.getRetrievedItems());
                result.getNotFoundItems().addAll(thisResult.getNotFoundItems());
                result.getPermissionDeniedItems().addAll(thisResult.getPermissionDeniedItems());
                ClientUtil.detachItems((EObject)thisResult);
                left -= size;
                ++i;
            }
        }
        return result;
    }

    private IFetchResult internalFetchStatesRest(List itemHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtil.beginMonitor(monitor, itemHandles.size());
        try {
            FetchResult result = RepositoryFactory.eINSTANCE.createFetchResult();
            for (IAuditableHandle itemHandle : itemHandles) {
                try {
                    result.getRetrievedItems().add(this.internalFetchStateRest(itemHandle, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    result.getNotFoundItems().add(itemHandle);
                }
                catch (PermissionDeniedException permissionDeniedException) {
                    result.getPermissionDeniedItems().add(itemHandle);
                }
            }
            FetchResult fetchResult = result;
            return fetchResult;
        }
        finally {
            monitor.done();
        }
    }

    private List removeDuplicates(List duplicateHandles, boolean useItemId) {
        ArrayList<IManagedItemHandle> cleanedupHandles = new ArrayList<IManagedItemHandle>(duplicateHandles.size());
        HashSet<UUID> visited = new HashSet<UUID>();
        for (IManagedItemHandle itemHandle : duplicateHandles) {
            UUID key;
            if (itemHandle == null) continue;
            UUID uUID = key = useItemId ? itemHandle.getItemId() : ((IAuditableHandle)itemHandle).getStateId();
            if (visited.contains(key)) continue;
            visited.add(key);
            cleanedupHandles.add(itemHandle);
        }
        return cleanedupHandles;
    }

    private void validateItemHandles(List itemHandles) {
        if (itemHandles == null) {
            throw new IllegalArgumentException("itemHandles must not be null");
        }
        for (Object element : itemHandles) {
            if (element == null) {
                throw new IllegalArgumentException("itemHandles contains a null element");
            }
            if (element instanceof IManagedItemHandle) continue;
            String message = String.format("element is not an instance of '%s': '%s'", IManagedItemHandle.class, element);
            throw new IllegalArgumentException(message);
        }
    }

    private void validateStateHandles(List itemHandles) {
        if (itemHandles == null) {
            throw new IllegalArgumentException("itemHandles must not be null");
        }
        for (Object element : itemHandles) {
            if (element == null) {
                throw new IllegalArgumentException("itemHandles contains a null element");
            }
            if (!(element instanceof IAuditableHandle)) {
                String message = String.format("element is not an instance of '%s': '%s'", IAuditableHandle.class, element);
                throw new IllegalArgumentException(message);
            }
            if (((IManagedItemHandle)element).getStateId() != null) continue;
            String message = String.format("itemHandle does not have a state id: '%s'", element);
            throw new IllegalArgumentException(message);
        }
    }

    private abstract class AbstractStore
    extends ItemStore {
        public AbstractStore(boolean useItemId) {
            super(useItemId, true);
        }

        public abstract IManagedItem fetchItem(IManagedItemHandle var1, boolean var2, Set var3, IProgressMonitor var4) throws TeamRepositoryException;

        public abstract IFetchResult fetchItems(List var1, boolean var2, Set var3, IProgressMonitor var4) throws TeamRepositoryException;

        protected void notifyDecrease(IItemType itemType, long size, long count) {
            ItemManager.this.teamRepository().statistics().decStatisticValue("com.ibm.team.repository.statistics.itemType", itemType, "itemTypeCacheSize", size);
            ItemManager.this.teamRepository().statistics().decStatisticValue("com.ibm.team.repository.totalContext", ItemManager.this.teamRepository(), "totalCacheSize", size);
            ItemManager.this.teamRepository().statistics().decStatisticValue("com.ibm.team.repository.statistics.itemType", itemType, "itemTypeCacheCount", count);
            ItemManager.this.teamRepository().statistics().decStatisticValue("com.ibm.team.repository.totalContext", ItemManager.this.teamRepository(), "totalCacheCount", count);
        }

        protected void notifyIncrease(IItemType itemType, long size, long count) {
            ItemManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.statistics.itemType", itemType, "itemTypeCacheSize", size);
            ItemManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.totalContext", ItemManager.this.teamRepository(), "totalCacheSize", size);
            ItemManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.statistics.itemType", itemType, "itemTypeCacheCount", count);
            ItemManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.totalContext", ItemManager.this.teamRepository(), "totalCacheCount", count);
        }

        protected void notifyItemChanged(IItem item, IItem beforeState, IItem afterState) {
            ItemManager.this.queueEvent(new SharedItemChangeEvent(ItemManager.this, item, beforeState, afterState));
        }

        protected void notifyItemHit(IManagedItemHandle itemHandle) {
            this.notifyItemStatistic(itemHandle, "itemTypeCacheHits", "totalCacheHits");
        }

        protected void notifyItemHits(List itemHandles) {
            this.notifyItemStatistics(itemHandles, "itemTypeCacheHits", "totalCacheHits");
        }

        protected void notifyItemMiss(IManagedItemHandle itemHandle) {
            this.notifyItemStatistic(itemHandle, "itemTypeCacheMisses", "totalCacheMisses");
        }

        protected void notifyItemMisses(List itemHandles) {
            this.notifyItemStatistics(itemHandles, "itemTypeCacheMisses", "totalCacheMisses");
        }

        protected void notifyItemRefresh(IManagedItemHandle itemHandle) {
            this.notifyItemStatistic(itemHandle, "itemTypeCacheRefreshes", "totalCacheRefreshes");
        }

        protected void notifyItemRefreshes(List itemHandles) {
            this.notifyItemStatistics(itemHandles, "itemTypeCacheRefreshes", "totalCacheRefreshes");
        }

        protected void notifyItemStatistic(IManagedItemHandle itemHandle, String itemTypeStatistic, String totalStatistic) {
            ItemManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.statistics.itemType", itemHandle.getItemType(), itemTypeStatistic, 1L);
            ItemManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.totalContext", ItemManager.this.teamRepository(), totalStatistic, 1L);
        }

        protected void notifyItemStatistics(List itemHandles, String itemTypeStatistic, String totalStatistic) {
            long total = 0L;
            for (IManagedItemHandle itemHandle : itemHandles) {
                if (itemHandle == null) continue;
                ItemManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.statistics.itemType", itemHandle.getItemType(), itemTypeStatistic, 1L);
                ++total;
            }
            ItemManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.totalContext", ItemManager.this.teamRepository(), totalStatistic, total);
        }

        protected IManagedItem retrieveItem(IManagedItemHandle itemHandle, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
            Object item = null;
            ItemNotFoundException itemNotFoundException = null;
            try {
                item = this.usesItemId() ? ItemManager.this.internalFetchItem(itemHandle, properties, monitor) : ItemManager.this.internalFetchState((IAuditableHandle)itemHandle, properties, monitor);
            }
            catch (ItemNotFoundException e) {
                itemNotFoundException = e;
            }
            try {
                ItemManager.this.acquire();
                if (item != null) {
                    item = (IManagedItem)this.putItem((IItem)item, false);
                } else {
                    this.removeItem((IItemHandle)itemHandle);
                }
            }
            finally {
                ItemManager.this.release();
            }
            if (itemNotFoundException != null) {
                throw itemNotFoundException;
            }
            if (item == null) {
                item = this.fetchItem(itemHandle, true, properties, (IProgressMonitor)new NullProgressMonitor());
            }
            return item;
        }

        /*
         * WARNING - void declaration
         */
        protected IFetchResult retrieveItems(List itemHandles, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
            void var7_8;
            ArrayList<IManagedItem> items = null;
            IFetchResult fetchResult = null;
            if (this.usesItemId()) {
                fetchResult = ItemManager.this.internalFetchItems(itemHandles, properties, monitor);
                items = new ArrayList<IManagedItem>(ItemManager.this.buildListFromFetchResult(fetchResult, itemHandles, true));
            } else {
                fetchResult = ItemManager.this.internalFetchStates(itemHandles, properties, monitor);
                items = new ArrayList(ItemManager.this.buildListFromFetchResult(fetchResult, itemHandles, false));
            }
            Iterator handleIterator = itemHandles.iterator();
            boolean bl = false;
            int count = items.size();
            while (var7_8 < count) {
                IManagedItem item = (IManagedItem)items.get((int)var7_8);
                IManagedItemHandle itemHandle = (IManagedItemHandle)handleIterator.next();
                if (item != null) {
                    try {
                        ItemManager.this.acquire();
                        item = (IManagedItem)this.putItem((IItem)item, false);
                    }
                    finally {
                        ItemManager.this.release();
                    }
                    if (item == null) {
                        try {
                            item = this.fetchItem(itemHandle, true, properties, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (ItemNotFoundException itemNotFoundException) {
                            try {
                                ItemManager.this.acquire();
                                this.removeItem((IItemHandle)itemHandle);
                            }
                            finally {
                                ItemManager.this.release();
                            }
                        }
                    }
                    items.set((int)var7_8, item);
                } else {
                    try {
                        ItemManager.this.acquire();
                        this.removeItem((IItemHandle)itemHandle);
                    }
                    finally {
                        ItemManager.this.release();
                    }
                }
                ++var7_8;
            }
            fetchResult.getRetrievedItems().clear();
            for (Object e : items) {
                if (e == null) continue;
                fetchResult.getRetrievedItems().add(e);
            }
            return fetchResult;
        }

        protected boolean statisticsEnabled() {
            return ItemManager.this.teamRepository().statistics().enabled();
        }
    }

    private class CurrentStore
    extends AbstractStore {
        public CurrentStore() {
            super(true);
        }

        public IManagedItem fetchItem(IManagedItemHandle itemHandle, boolean refresh, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = ClientUtil.beginMonitor(monitor, 100);
            try {
                IManagedItem storedItem = null;
                Set storedProperties = null;
                try {
                    ItemManager.this.acquire();
                    storedItem = (IManagedItem)this.getItem((IItemHandle)itemHandle);
                    storedProperties = this.getProperties((IItemHandle)itemHandle);
                }
                finally {
                    ItemManager.this.release();
                }
                if (!refresh && storedItem != null && CurrentStore.contains((Set)storedProperties, (Set)properties)) {
                    this.notifyItemHit(itemHandle);
                    IManagedItem iManagedItem = storedItem;
                    return iManagedItem;
                }
                if (refresh) {
                    this.notifyItemRefresh(itemHandle);
                } else {
                    this.notifyItemMiss(itemHandle);
                }
                IManagedItem iManagedItem = this.retrieveItem(itemHandle, storedItem == null ? properties : CurrentStore.addAll((Set)storedProperties, (Set)properties), (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                return iManagedItem;
            }
            finally {
                monitor.done();
            }
        }

        public IFetchResult fetchItems(List itemHandles, boolean refresh, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = ClientUtil.beginMonitor(monitor, 100);
            try {
                ArrayList<IManagedItem> items = new ArrayList<IManagedItem>(itemHandles);
                ArrayList<IManagedItemHandle> storedItemHandles = new ArrayList<IManagedItemHandle>(itemHandles.size());
                ArrayList<IManagedItemHandle> nonStoredItemHandles = new ArrayList<IManagedItemHandle>(itemHandles.size());
                Set allProperties = properties;
                try {
                    ItemManager.this.acquire();
                    int index = 0;
                    for (IManagedItemHandle itemHandle : itemHandles) {
                        IManagedItem storedItem = (IManagedItem)this.getItem((IItemHandle)itemHandle);
                        Set storedProperties = this.getProperties((IItemHandle)itemHandle);
                        if (!refresh && storedItem != null && CurrentStore.contains((Set)storedProperties, (Set)properties)) {
                            storedItemHandles.add(itemHandle);
                            items.set(index, storedItem);
                        } else {
                            items.set(index, null);
                            nonStoredItemHandles.add(itemHandle);
                            if (storedItem != null) {
                                allProperties = CurrentStore.addAll((Set)allProperties, (Set)storedProperties);
                            }
                        }
                        ++index;
                    }
                }
                finally {
                    ItemManager.this.release();
                }
                if (!storedItemHandles.isEmpty()) {
                    this.notifyItemHits(storedItemHandles);
                }
                FetchResult fetchResult = null;
                if (!nonStoredItemHandles.isEmpty()) {
                    if (refresh) {
                        this.notifyItemRefreshes(nonStoredItemHandles);
                    } else {
                        this.notifyItemMisses(nonStoredItemHandles);
                    }
                    fetchResult = this.retrieveItems(nonStoredItemHandles, allProperties, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    for (Object e : items) {
                        if (e == null) continue;
                        fetchResult.getRetrievedItems().add(e);
                    }
                } else {
                    fetchResult = RepositoryFactory.eINSTANCE.createFetchResult();
                    fetchResult.getRetrievedItems().addAll(items);
                }
                FetchResult fetchResult2 = fetchResult;
                return fetchResult2;
            }
            finally {
                monitor.done();
            }
        }

        public IManagedItem refreshItem(IManagedItemHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = ClientUtil.beginMonitor(monitor, 100);
            try {
                IManagedItem storedItem = null;
                Set storedProperties = null;
                try {
                    ItemManager.this.acquire();
                    storedItem = (IManagedItem)this.getItem((IItemHandle)itemHandle);
                    storedProperties = this.getProperties((IItemHandle)itemHandle);
                }
                finally {
                    ItemManager.this.release();
                }
                if (storedItem == null) {
                    return null;
                }
                this.notifyItemRefresh(itemHandle);
                IManagedItem iManagedItem = this.retrieveItem(itemHandle, storedProperties, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                return iManagedItem;
            }
            finally {
                monitor.done();
            }
        }

        public List refreshItems(List itemHandles, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = ClientUtil.beginMonitor(monitor, 100);
            try {
                ArrayList<IManagedItem> storedItems = new ArrayList<IManagedItem>(itemHandles.size());
                Set allProperties = new HashSet();
                try {
                    ItemManager.this.acquire();
                    for (IManagedItemHandle itemHandle : itemHandles) {
                        IManagedItem storedItem = (IManagedItem)this.getItem((IItemHandle)itemHandle);
                        if (storedItem == null) continue;
                        Set storedProperties = this.getProperties((IItemHandle)itemHandle);
                        storedItems.add(storedItem);
                        allProperties = CurrentStore.addAll(allProperties, (Set)storedProperties);
                    }
                }
                finally {
                    ItemManager.this.release();
                }
                if (storedItems.isEmpty()) {
                    ArrayList<IManagedItem> arrayList = storedItems;
                    return arrayList;
                }
                this.notifyItemRefreshes(storedItems);
                IFetchResult result = this.retrieveItems(storedItems, allProperties, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                List list = result.getRetrievedItems();
                return list;
            }
            finally {
                monitor.done();
            }
        }
    }

    private class LocationFetchResult
    implements IFetchResult {
        private List retrievedItems = new ArrayList();
        private List notFoundLocations = new ArrayList();
        private List permissionDeniedLocations = new ArrayList();

        private LocationFetchResult() {
        }

        public List getMissingItems() {
            ArrayList result = new ArrayList(this.getNotFoundItems());
            result.addAll(this.getPermissionDeniedItems());
            return Collections.unmodifiableList(result);
        }

        public List getNotFoundItems() {
            return this.notFoundLocations;
        }

        public List getPermissionDeniedItems() {
            return this.permissionDeniedLocations;
        }

        public List getRetrievedItems() {
            return this.retrievedItems;
        }

        public boolean hasMissingItems() {
            return this.hasNotFoundItems() || this.hasPermissionDeniedItems();
        }

        public boolean hasNotFoundItems() {
            return !this.notFoundLocations.isEmpty();
        }

        public boolean hasPermissionDeniedItems() {
            return !this.permissionDeniedLocations.isEmpty();
        }

        public void populatePermissionDenied(List deniedHandles, Map uuidsToLocations) {
            for (IItemHandle deniedHandle : deniedHandles) {
                this.getPermissionDeniedItems().add(uuidsToLocations.get(deniedHandle.getItemId()));
            }
        }

        public void populateNotFound(List notFoundHandles, Map uuidsToLocations) {
            for (IItemHandle notFoundHandle : notFoundHandles) {
                this.getNotFoundItems().add(uuidsToLocations.get(notFoundHandle.getItemId()));
            }
        }
    }

    private class StateStore
    extends AbstractStore {
        public StateStore() {
            super(false);
        }

        public IManagedItem fetchItem(IManagedItemHandle itemHandle, boolean refresh, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = ClientUtil.beginMonitor(monitor, 100);
            try {
                IManagedItem storedItem = null;
                Set storedProperties = null;
                try {
                    ItemManager.this.acquire();
                    storedItem = (IManagedItem)this.getItem((IItemHandle)itemHandle);
                    storedProperties = this.getProperties((IItemHandle)itemHandle);
                }
                finally {
                    ItemManager.this.release();
                }
                if (storedItem != null && StateStore.contains((Set)storedProperties, (Set)properties)) {
                    this.notifyItemHit(itemHandle);
                    IManagedItem iManagedItem = storedItem;
                    return iManagedItem;
                }
                IManagedItem currentItem = (IManagedItem)ItemManager.this.currentStore.getItem((IItemHandle)itemHandle);
                if (currentItem != null) {
                    if ((currentItem = (IManagedItem)StateStore.getImmutableItem((IItem)currentItem)).sameStateId((IItemHandle)itemHandle) && StateStore.contains((Set)StateStore.getProperties((IItem)currentItem), (Set)properties)) {
                        this.notifyItemHit(itemHandle);
                        try {
                            ItemManager.this.acquire();
                            currentItem = (IManagedItem)this.putItem((IItem)currentItem, false);
                        }
                        finally {
                            ItemManager.this.release();
                        }
                    } else {
                        currentItem = null;
                    }
                }
                if (currentItem == null) {
                    this.notifyItemMiss(itemHandle);
                    currentItem = this.retrieveItem(itemHandle, storedItem == null ? properties : StateStore.addAll((Set)storedProperties, (Set)properties), (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                }
                IManagedItem iManagedItem = currentItem;
                return iManagedItem;
            }
            finally {
                monitor.done();
            }
        }

        public IFetchResult fetchItems(List itemHandles, boolean refresh, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = ClientUtil.beginMonitor(monitor, 100);
            try {
                ArrayList<IManagedItem> items = new ArrayList<IManagedItem>(itemHandles);
                ArrayList<IManagedItemHandle> storedItemHandles = new ArrayList<IManagedItemHandle>(itemHandles.size());
                ArrayList<IManagedItemHandle> nonStoredItemHandles = new ArrayList<IManagedItemHandle>(itemHandles.size());
                Set allProperties = properties;
                try {
                    ItemManager.this.acquire();
                    int index = 0;
                    for (IManagedItemHandle itemHandle : itemHandles) {
                        IManagedItem storedItem = (IManagedItem)this.getItem((IItemHandle)itemHandle);
                        Set storedProperties = this.getProperties((IItemHandle)itemHandle);
                        if (storedItem != null && StateStore.contains((Set)storedProperties, (Set)properties)) {
                            storedItemHandles.add(itemHandle);
                            items.set(index, storedItem);
                        } else {
                            Object currentItem = (IManagedItem)ItemManager.this.currentStore.getItem((IItemHandle)itemHandle);
                            if (currentItem != null) {
                                currentItem = (currentItem = (IManagedItem)StateStore.getImmutableItem((IItem)currentItem)).sameStateId((IItemHandle)itemHandle) && StateStore.contains((Set)StateStore.getProperties((IItem)currentItem), (Set)properties) ? (IManagedItem)this.putItem((IItem)currentItem, false) : null;
                            }
                            if (currentItem == null) {
                                items.set(index, null);
                                nonStoredItemHandles.add(itemHandle);
                                if (storedItem != null) {
                                    allProperties = StateStore.addAll((Set)allProperties, (Set)storedProperties);
                                }
                            } else {
                                storedItemHandles.add(itemHandle);
                                items.set(index, (IManagedItem)currentItem);
                            }
                        }
                        ++index;
                    }
                }
                finally {
                    ItemManager.this.release();
                }
                if (!storedItemHandles.isEmpty()) {
                    this.notifyItemHits(storedItemHandles);
                }
                FetchResult fetchResult = null;
                if (!nonStoredItemHandles.isEmpty()) {
                    this.notifyItemMisses(nonStoredItemHandles);
                    fetchResult = this.retrieveItems(nonStoredItemHandles, allProperties, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    for (Object e : items) {
                        if (e == null) continue;
                        fetchResult.getRetrievedItems().add(e);
                    }
                } else {
                    fetchResult = RepositoryFactory.eINSTANCE.createFetchResult();
                    fetchResult.getRetrievedItems().addAll(items);
                }
                FetchResult fetchResult2 = fetchResult;
                return fetchResult2;
            }
            finally {
                monitor.done();
            }
        }
    }
}

