/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.client.workitems.internal.Messages;
import com.ibm.team.filesystem.client.workitems.internal.WorkItemUtils;
import com.ibm.team.filesystem.client.workitems.operations.ISubmitForReviewOperation;
import com.ibm.team.filesystem.client.workitems.operations.SubmitForReviewParameter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitForReviewOperation
extends ChangeHistoryChangeSetsOperation
implements ISubmitForReviewOperation {
    private SubmitForReviewParameter submitForReviewParameter;
    private final Map<IWorkspaceConnection, List<IChangeSet>> sourceToChangeSets;
    private SuspendDilemmaHandler baseProblemHandler;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;

    public SubmitForReviewOperation(SuspendDilemmaHandler handler) {
        super((ChangeHistoryChangeSetsDilemmaHandler)handler);
        this.baseProblemHandler = handler;
        this.sourceToChangeSets = new HashMap<IWorkspaceConnection, List<IChangeSet>>();
    }

    public void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = this.submitForReviewParameter.getRepo();
        HashMap<IChangeSetHandle, IWorkspaceConnection> changeSetToSource = new HashMap<IChangeSetHandle, IWorkspaceConnection>();
        for (SubmitForReviewParameter.ChangeSetReview changeSetToReview : this.submitForReviewParameter.getChangeSetReviews()) {
            changeSetToSource.put(changeSetToReview.getChangeSet(), changeSetToReview.getSource());
        }
        ArrayList itemHandles = new ArrayList(changeSetToSource.keySet());
        List fullChangeSets = repo.itemManager().fetchCompleteItems(itemHandles, 0, (IProgressMonitor)progress.newChild(1));
        final HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        ArrayList determinants = new ArrayList();
        int i = 0;
        for (IChangeSet changeSet : fullChangeSets) {
            IWorkspaceConnection connection = (IWorkspaceConnection)changeSetToSource.get(itemHandles.get(i));
            affectedConfigurations.add(new ConfigurationDescriptor((IConnection)connection, changeSet.getComponent()));
            List<IChangeSet> changeSets = this.sourceToChangeSets.get(connection);
            if (changeSets == null) {
                changeSets = new ArrayList<IChangeSet>();
                this.sourceToChangeSets.put(connection, changeSets);
            }
            changeSets.add(changeSet);
            ++i;
        }
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SubmitForReviewOperation.this.submitForReview(affectedConfigurations, monitor);
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.SubmitForReviewOperation_1, (IProgressMonitor)progress.newChild(98));
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    private void submitForReview(Set<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (this.verifyInSyncEnabled() && !this.baseProblemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            SubMonitor iterMonitor = monitor.newChild(1);
            iterMonitor.setWorkRemaining(affectedConfigurations.size());
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.baseProblemHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationDescriptor descriptor : affectedConfigurations) {
                verifyOp.addToVerify(descriptor.getConnection((IProgressMonitor)iterMonitor.newChild(1)), descriptor.componentHandle);
            }
            verifyOp.run((IProgressMonitor)monitor.newChild(1));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)monitor.newChild(1));
        try {
            if (!this.submitForReviewParameter.isSuspend()) {
                this.checkinPendingChanges(affectedConfigurations, (ChangeHistoryChangeSetsDilemmaHandler)this.baseProblemHandler, true, (IProgressMonitor)monitor.newChild(15));
            }
            ArrayList<IWorkItemHandle> workItems = new ArrayList<IWorkItemHandle>(this.submitForReviewParameter.getWorkItems());
            Iterator i = workItems.iterator();
            while (i.hasNext()) {
                if (i.next() != null) continue;
                i.remove();
            }
            ITeamRepository repo = this.submitForReviewParameter.getRepo();
            List fullWorkItems = repo.itemManager().fetchCompleteItems(workItems, 0, (IProgressMonitor)monitor.newChild(1));
            SubMonitor loopProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(15), (int)(fullWorkItems.size() * this.submitForReviewParameter.getChangeSetReviews().size()));
            for (IWorkItemHandle workItemToAssign : fullWorkItems) {
                boolean associated = false;
                for (SubmitForReviewParameter.ChangeSetReview changeSetReview : this.submitForReviewParameter.getChangeSetReviews()) {
                    if (!WorkItemUtils.isWorkItemAssociated(workItemToAssign, repo, changeSetReview.getChangeSet())) continue;
                    associated = true;
                    break;
                }
                if (associated) continue;
                IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
                for (SubmitForReviewParameter.ChangeSetReview changeSetReview : this.submitForReviewParameter.getChangeSetReviews()) {
                    workItemManager.createLink(changeSetReview.getSource().getResolvedWorkspace(), changeSetReview.getChangeSet(), new IWorkItemHandle[]{workItemToAssign}, (IProgressMonitor)loopProgress.newChild(1));
                }
            }
            ISuspendOperation op = IOperationFactory.instance.getSuspendOperation(this.baseProblemHandler);
            if (this.submitForReviewParameter.isSuspend()) {
                op.setRefreshBeforeRun(this.getRefreshBeforeRun());
                if (this.nonAtomicCommitIsAnOption) {
                    op.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                } else {
                    op.disableNonAtomicCommit();
                }
                this.disableVerifyInSync((IFileSystemOperation)op);
            }
            if (this.submitForReviewParameter.isSuspend()) {
                for (Map.Entry<IWorkspaceConnection, List<IChangeSet>> entry : this.sourceToChangeSets.entrySet()) {
                    op.suspend(entry.getKey(), (Collection)entry.getValue());
                }
            }
            this.submitChangesForReview(new ArrayList<IWorkItem>(fullWorkItems), this.submitForReviewParameter.getReviewers(), this.submitForReviewParameter.getComment(), this.submitForReviewParameter.getSubject(), (IProgressMonitor)monitor.newChild(15));
            if (this.submitForReviewParameter.isSuspend()) {
                op.run((IProgressMonitor)monitor.newChild(15));
            }
            loopProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(15));
            loopProgress.setWorkRemaining(this.sourceToChangeSets.size());
            for (Map.Entry<IWorkspaceConnection, List<IChangeSet>> entry : this.sourceToChangeSets.entrySet()) {
                entry.getKey().ensureClosed((Collection)entry.getValue(), (IProgressMonitor)loopProgress.newChild(1));
            }
        }
        finally {
            copyFileAreaLock.release((IProgressMonitor)monitor.newChild(1));
        }
    }

    private void submitChangesForReview(List<IWorkItem> workItems, IContributorHandle[] reviewers, String comment, String subject, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask(Messages.SubmitForReviewOperation_0, 3);
            for (IWorkItem workItem : workItems) {
                WorkItemUtils.createReviewTask((ITeamRepository)workItem.getOrigin(), workItem, WorkItemApprovals.REVIEW_TYPE.getIdentifier(), subject, Arrays.asList(reviewers), true, comment, true, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void submitForReview(SubmitForReviewParameter reviewParameter) {
        this.submitForReviewParameter = reviewParameter;
    }

    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
        super.disableNonAtomicCommit();
    }

    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
        super.enableNonAtomicCommit(numberUploads);
    }

    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        for (Map.Entry<IWorkspaceConnection, List<IChangeSet>> entry : this.sourceToChangeSets.entrySet()) {
            ChangeSetRefreshUtils.refreshLocalForRemoval((IFilesystemRefresher)refresher, affectedAreas, (IWorkspaceConnection)entry.getKey(), entry.getValue(), (IProgressMonitor)progress);
        }
    }
}

