/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.client.workitems.internal.Messages;
import com.ibm.team.filesystem.client.workitems.operations.ICheckinAndDeliverOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckinAndDeliverOperation
extends FileSystemOperation
implements ICheckinAndDeliverOperation {
    private IWorkItemHandle workItem;
    private final DeliverDilemmaHandler dilemmaHandler;
    private String changeSetComment;
    private List<CheckInAndDeliverRequest> requests = new ArrayList<CheckInAndDeliverRequest>();
    private boolean refreshBeforeRun;
    private int nonAtomicCommitFileUploadLimit = 200;
    private boolean nonAtomicCommitIsAnOption = true;

    public CheckinAndDeliverOperation(DeliverDilemmaHandler dilemmaHandler) {
        super((DilemmaHandler)dilemmaHandler);
        this.dilemmaHandler = dilemmaHandler;
    }

    @Override
    public void changeSetLinkage(IWorkItemHandle workItem, String changeSetComment) {
        this.workItem = workItem;
        this.changeSetComment = changeSetComment;
    }

    @Override
    public void add(IWorkspaceConnection source, IWorkspaceConnection target, IChangeHistorySyncReport report, IComponentHandle component, List<ILocalChange> localChanges) {
        CheckInAndDeliverRequest request = new CheckInAndDeliverRequest();
        request.component = component;
        request.source = source;
        request.target = target;
        request.localChanges = localChanges;
        request.report = report;
        this.requests.add(request);
    }

    public void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CheckinAndDeliverOperation_PROGRESS_DELIVER, (int)100);
        IDeliverOperation deliverOperation = IOperationFactory.instance.getDeliverOperation(this.dilemmaHandler);
        this.configureCheckinOptions((ICheckinOptions)deliverOperation);
        deliverOperation.setRefreshBeforeRun(this.refreshBeforeRun);
        SubMonitor loopProgress = progress.newChild(75).setWorkRemaining(this.requests.size());
        for (CheckInAndDeliverRequest request : this.requests) {
            this.checkIn(request, deliverOperation, (IProgressMonitor)loopProgress.newChild(1));
        }
        deliverOperation.run((IProgressMonitor)progress.newChild(25));
    }

    private void configureCheckinOptions(ICheckinOptions operation) {
        if (this.nonAtomicCommitIsAnOption) {
            operation.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
        } else {
            operation.disableNonAtomicCommit();
        }
    }

    private void checkIn(CheckInAndDeliverRequest request, IDeliverOperation deliverOperation, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CheckinAndDeliverOperation_PROGRESS_MESSAGE, (int)100);
        IWorkspaceConnection source = request.source;
        IWorkspaceConnection target = request.target;
        List<ILocalChange> localChanges = request.localChanges;
        IChangeHistorySyncReport report = request.report;
        IComponentHandle component = request.component;
        ICheckinOperation checkInOperation = IOperationFactory.instance.getCheckinOperation(this.dilemmaHandler.getCommitDilemmaHandler());
        this.configureCheckinOptions((ICheckinOptions)checkInOperation);
        checkInOperation.setRefreshBeforeRun(this.refreshBeforeRun);
        checkInOperation.requestCheckin(source, component, localChanges.toArray(new ILocalChange[0]), null, this.changeSetComment, (IProgressMonitor)progress.newChild(5));
        checkInOperation.run((IProgressMonitor)progress.newChild(55));
        Collection committedChangeSets = checkInOperation.getCommittedChangeSets();
        report = source.compareTo((IFlowNodeConnection)target, WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO, Collections.EMPTY_LIST, (IProgressMonitor)progress.newChild(10));
        progress.setTaskName(Messages.CheckinAndDeliverOperation_PROGRESS_MESSAGE_CHECKIN);
        IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)source.teamRepository().getClientLibrary(IFileSystemWorkItemManager.class);
        ArrayList outgoingHandles = new ArrayList(committedChangeSets);
        List outgoing = source.teamRepository().itemManager().fetchCompleteItems(outgoingHandles, 0, (IProgressMonitor)progress.newChild(5));
        SubMonitor loopProgress = progress.newChild(10).setWorkRemaining(outgoing.size() * 2);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)source.teamRepository());
        for (IChangeSet changeSet : outgoing) {
            if (changeSet == null || !changeSet.isActive()) continue;
            String trimmedComment = this.changeSetComment.trim();
            if (trimmedComment.length() > 0) {
                manager.setComment((IChangeSetHandle)changeSet, this.changeSetComment, (IProgressMonitor)loopProgress.newChild(1));
            }
            if (this.workItem == null) continue;
            workItemManager.createLink(source.getResolvedWorkspace(), (IChangeSetHandle)changeSet, new IWorkItemHandle[]{this.workItem}, (IProgressMonitor)loopProgress.newChild(1));
        }
        deliverOperation.deliver(source, target, report, component);
    }

    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    public boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    public void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    private static class CheckInAndDeliverRequest {
        public IWorkspaceConnection source;
        public IWorkspaceConnection target;
        public List<ILocalChange> localChanges;
        public IChangeHistorySyncReport report;
        public List<IChangeSetHandle> changeSets;
        public IComponentHandle component;

        private CheckInAndDeliverRequest() {
        }
    }
}

