/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.OperationOptions;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.client.workitems.IWorkItemOperationFactory;
import com.ibm.team.filesystem.client.workitems.internal.operations.CheckinAndDeliverOperation;
import com.ibm.team.filesystem.client.workitems.internal.operations.DeliverAndFixOperation;
import com.ibm.team.filesystem.client.workitems.internal.operations.SubmitForReviewOperation;
import com.ibm.team.filesystem.client.workitems.operations.ICheckinAndDeliverOperation;
import com.ibm.team.filesystem.client.workitems.operations.IDeliverAndFixOperation;
import com.ibm.team.filesystem.client.workitems.operations.ISubmitForReviewOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemOperationFactory
implements IWorkItemOperationFactory {
    private static IWorkItemOperationFactory operationFactory;

    public static IWorkItemOperationFactory getInstance() {
        if (operationFactory == null) {
            operationFactory = new WorkItemOperationFactory();
        }
        return operationFactory;
    }

    private WorkItemOperationFactory() {
    }

    private <T extends IFileSystemOperation> T configure(T object) {
        OperationOptions options = IOperationFactory.instance.getOperationOptions();
        options.configureOperation(object);
        return object;
    }

    @Override
    public IDeliverAndFixOperation getDeliverAndResolveOperation(DeliverDilemmaHandler dilemmaHandler) {
        return this.configure(new DeliverAndFixOperation(dilemmaHandler));
    }

    @Override
    public ISubmitForReviewOperation getSubmitForReviewOperation(SuspendDilemmaHandler dilemmaHandler) {
        return this.configure(new SubmitForReviewOperation(dilemmaHandler));
    }

    @Override
    public ICheckinAndDeliverOperation getCheckinAndDeliverOperation(DeliverDilemmaHandler dilemmaHandler) {
        return this.configure(new CheckinAndDeliverOperation(dilemmaHandler));
    }
}

