/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliver;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.workitems.internal.BackupUtil;
import com.ibm.team.filesystem.client.workitems.internal.CommitUtil;
import com.ibm.team.filesystem.client.workitems.internal.CoreUtil;
import com.ibm.team.filesystem.client.workitems.internal.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliverResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.NonAtomicCheckInDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.ComponentLockReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.FilesystemRestClientDTOlocksFactory;
import com.ibm.team.filesystem.common.internal.rest.client.locks.StreamLockReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.VersionableLockDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DeliverUtil {
    public static DeliverDilemmaHandler getDeliverDilemmaHandler(ParmsDeliver parms, final DeliverResultDTO result) {
        final BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), backupDilemmaHandler);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, outOfSyncDilemmaHandler, backupDilemmaHandler, (List<LineDelimiterErrorDTO>)result.getLineDelimiterFailures(), (List<EncodingErrorDTO>)result.getEncodingFailures(), (List<NonAtomicCheckInDTO>)result.getNonAtomicCheckInOffers());
        final int uncheckedInChanges = DeliverUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final int flowComponents = DeliverUtil.getFlowComponentsDilemaValue(parms.deliverDilemmaHandler);
        final int flowToNonDefaultTarget = DeliverUtil.getFlowToNonDefaultTarget(parms.deliverDilemmaHandler);
        DeliverDilemmaHandler handler = new DeliverDilemmaHandler(){

            public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
                for (ConfigurationDescriptor configuration : changes.keySet()) {
                    result.getConfigurationsWithUnCheckedInChanges().add(CoreUtil.translateConfigurationDescriptor(configuration));
                }
                return uncheckedInChanges;
            }

            public int notDefaultTarget(Collection<IWorkspaceConnection> targets) {
                result.setFlowToNonDefaultTarget(true);
                return flowToNonDefaultTarget;
            }

            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            public int deliverCombinedProblem(IWorkspaceConnection workspaceConnection, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, TeamRepositoryException exception) {
                return super.deliverCombinedProblem(workspaceConnection, syncReport, baselines, changeSets, exception);
            }

            public int componentsToBeAddedOrRemoved(List<IComponentHandle> added, List<IComponentHandle> removed) {
                result.setComponentsToFlow(true);
                return flowComponents;
            }

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            public int lockBeingHeld(IStreamLockReport lock, IWorkspaceConnection workspaceConnection, int requestsLeft) {
                return 0;
            }

            public Map<IStreamLockReport, IWorkspaceConnection> locksToRelease(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
                    result.getLocksToRelease().add(DeliverUtil.getStreamLockReportDTO(entry.getValue(), entry.getKey()));
                }
                return Collections.EMPTY_MAP;
            }

            public void locksWereHeld(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
                    result.getLocksWereHeld().add(DeliverUtil.getStreamLockReportDTO(entry.getValue(), entry.getKey()));
                }
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        return handler;
    }

    public static StreamLockReportDTO getStreamLockReportDTO(IWorkspaceConnection wc, IStreamLockReport report) {
        StreamLockReportDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createStreamLockReportDTO();
        result.setStreamItemId(report.getStream().getItemId().getUuidValue());
        if (wc != null) {
            result.setStreamName(wc.getName());
        }
        for (IComponentLockReport clr : report.getComponentLocks()) {
            result.getComponentLockReports().add(DeliverUtil.getComponentLockReportDTO(clr));
        }
        return result;
    }

    private static ComponentLockReportDTO getComponentLockReportDTO(IComponentLockReport report) {
        ComponentLockReportDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createComponentLockReportDTO();
        result.setComponentItemId(report.getComponent().getItemId().getUuidValue());
        for (IVersionableLock lock : report.getLocks()) {
            result.getVersionableLocks().add(DeliverUtil.getVersionableLockDTO(lock));
        }
        return result;
    }

    private static VersionableLockDTO getVersionableLockDTO(IVersionableLock lock) {
        VersionableLockDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createVersionableLockDTO();
        result.setContributorItemId(lock.getContributor().getItemId().getUuidValue());
        result.setVersionableItemId(lock.getVersionable().getItemId().getUuidValue());
        return result;
    }

    public static int getUncheckedInChangesInstruction(ParmsPendingChangesDilemmaHandler changeDilemmaHandlerParm) {
        int uncheckedInChangesInstruction = 2;
        if (changeDilemmaHandlerParm != null) {
            uncheckedInChangesInstruction = DeliverUtil.getInstruction(changeDilemmaHandlerParm.pendingChangesInstruction);
        }
        return uncheckedInChangesInstruction;
    }

    public static int getFlowComponentsDilemaValue(ParmsDeliverDilemmaHandler deliverParms) {
        int flowComponents;
        if (deliverParms == null) {
            flowComponents = 0;
        } else if ("continue".equals(deliverParms.flowComponents)) {
            flowComponents = 0;
        } else if (deliverParms.flowComponents == null) {
            flowComponents = 0;
        } else if ("cancel".equals(deliverParms.flowComponents)) {
            flowComponents = 1;
        } else if ("fail".equals(deliverParms.flowComponents)) {
            flowComponents = 2;
        } else if ("no".equals(deliverParms.flowComponents)) {
            flowComponents = 3;
        } else {
            throw new IllegalArgumentException("The value of flowComponents must be one of cancel, continue, no or fail");
        }
        return flowComponents;
    }

    public static int getFlowToNonDefaultTarget(ParmsDeliverDilemmaHandler deliverParms) {
        int flowToNonDefaultTarget;
        if (deliverParms == null) {
            flowToNonDefaultTarget = 0;
        } else if ("continue".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 0;
        } else if (deliverParms.flowToNonDefault == null) {
            flowToNonDefaultTarget = 0;
        } else if ("cancel".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 1;
        } else if ("fail".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 2;
        } else {
            throw new IllegalArgumentException("The value of flowToNonDefault must be one of cancel, continue, no or fail");
        }
        return flowToNonDefaultTarget;
    }

    private static int getInstruction(String instruction) {
        int uncheckedInChangesInstruction = 2;
        if ("continue".equals(instruction)) {
            uncheckedInChangesInstruction = 0;
        } else if (instruction == null) {
            uncheckedInChangesInstruction = 2;
        } else if ("cancel".equals(instruction)) {
            uncheckedInChangesInstruction = 1;
        } else if ("fail".equals(instruction)) {
            uncheckedInChangesInstruction = 2;
        } else if ("no".equals(instruction)) {
            uncheckedInChangesInstruction = 3;
        } else {
            throw new IllegalArgumentException("The value of uncheckedInChangesInstruction must be one of cancel, continue, no or fail");
        }
        return uncheckedInChangesInstruction;
    }
}

