/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.GapChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConnectionDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.SandboxDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.Visibility;
import com.ibm.team.scm.client.VisibilityEnum;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreUtil {
    public static ShareDTO translateShare(IShare share) {
        ShareDTO translation = FilesystemRestClientDTOcoreFactory.eINSTANCE.createShareDTO();
        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
        translation.setComponentItemId(sharingDescriptor.getComponent().getItemId().getUuidValue());
        translation.setComponentName(sharingDescriptor.getComponentName());
        translation.setRootVersionableItemId(sharingDescriptor.getRootVersionable().getItemId().getUuidValue());
        translation.setRootVersionableItemType(CoreUtil.getVersionableItemType(sharingDescriptor.getRootVersionable()));
        translation.setSandboxPath(share.getSandbox().getRoot().toOSString());
        translation.setPath(CoreUtil.translatePath(share.getPath()));
        translation.setContextItemId(sharingDescriptor.getConnectionHandle().getItemId().getUuidValue());
        translation.setIsWorkspaceContext(sharingDescriptor.getConnectionHandle() instanceof IWorkspaceHandle);
        translation.setContextName(sharingDescriptor.getConnectionName());
        translation.setRepositoryURL(sharingDescriptor.getRepositoryUri());
        return translation;
    }

    public static String translatePathToString(PathDTO path) {
        StringBuffer buf = new StringBuffer();
        for (String seg : path.getSegments()) {
            buf.append('/');
            buf.append(seg);
        }
        return buf.toString();
    }

    public static PathDTO translatePath(IPath path) {
        return CoreUtil.translatePath(path.segments());
    }

    public static PathDTO translatePath(IShareable shareable) {
        return CoreUtil.translatePath(shareable.getLocalPath());
    }

    public static PathDTO translatePath(String path) {
        return CoreUtil.translatePath(new Path(path).segments());
    }

    public static PathDTO translatePath(String[] pathSegments) {
        PathDTO path = FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO();
        path.getSegments().addAll(Arrays.asList(pathSegments));
        return path;
    }

    public static PathDTO translatePath(IAncestorReport report) {
        PathDTO path = FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO();
        Iterator iPairs = report.getNameItemPairs().iterator();
        iPairs.next();
        while (iPairs.hasNext()) {
            path.getSegments().add(((INameItemPair)iPairs.next()).getName());
        }
        return path;
    }

    public static ConfigurationDescriptorDTO translateConfigurationDescriptor(ConfigurationDescriptor descriptor) {
        ConfigurationDescriptorDTO configurationDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationDescriptorDTO();
        ConnectionDescriptorDTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptorDTO();
        connectionDescriptor.setRepositoryURL(descriptor.uri);
        connectionDescriptor.setContextItemId(descriptor.connectionHandle.getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(descriptor.connectionHandle instanceof IWorkspaceHandle);
        configurationDescriptor.setConnection(connectionDescriptor);
        configurationDescriptor.setComponentItemId(descriptor.componentHandle.getItemId().getUuidValue());
        return configurationDescriptor;
    }

    public static BaselineDTO translateBaseline(IBaselineConnection baselineConnection, HashMap<UUID, IContributor> contributors) {
        return CoreUtil.translateBaseline(baselineConnection.teamRepository(), baselineConnection.getResolvedBaseline(), contributors);
    }

    public static HashMap<UUID, IContributor> fetchCreatorAndGetModifiedBy(ITeamRepository repo, List<IBaseline> baselines, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, IContributorHandle> contributorHandles = new HashMap<UUID, IContributorHandle>();
        for (IBaseline baseline : baselines) {
            IContributorHandle contributor = baseline.getCreator();
            contributorHandles.put(contributor.getItemId(), contributor);
            contributor = baseline.getModifiedBy();
            if (contributor == null) continue;
            contributorHandles.put(contributor.getItemId(), contributor);
        }
        List contributors = repo.itemManager().fetchCompleteItems(new ArrayList(contributorHandles.values()), 0, monitor);
        HashMap<UUID, IContributor> result = new HashMap<UUID, IContributor>();
        for (IContributorHandle contributor : contributors) {
            result.put(contributor.getItemId(), (IContributor)contributor);
        }
        return result;
    }

    public static BaselineDTO translateBaseline(ITeamRepository repository, IBaseline baseline, HashMap<UUID, IContributor> contributors) {
        BaselineDTO baselineDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineDTO();
        baselineDTO.setItemId(baseline.getItemId().getUuidValue());
        baselineDTO.setRepositoryURL(repository.getRepositoryURI());
        baselineDTO.setId(baseline.getId());
        baselineDTO.setName(baseline.getName());
        baselineDTO.setComment(baseline.getComment());
        baselineDTO.setComponentItemId(baseline.getComponent().getItemId().getUuidValue());
        baselineDTO.setCreationDate(baseline.getCreationDate().getTime());
        baselineDTO.setCreatorContributorItemId(baseline.getCreator().getItemId().getUuidValue());
        baselineDTO.setModifiedDate(baseline.modified().getTime());
        baselineDTO.setModifierContributorItemId(baseline.getModifiedBy().getItemId().getUuidValue());
        IContributor contributor = contributors.get(baseline.getCreator().getItemId());
        if (contributor != null) {
            baselineDTO.setCreatorContributorName(contributor.getName());
        }
        if ((contributor = contributors.get(baseline.getModifiedBy().getItemId())) != null) {
            baselineDTO.setModifierContributorName(contributor.getName());
        }
        return baselineDTO;
    }

    public static BaselineSetDTO translateBaselineSet(ITeamRepository repository, IBaselineSet baselineSet) {
        BaselineSetDTO baselineSetDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineSetDTO();
        baselineSetDTO.setComment(baselineSet.getComment());
        baselineSetDTO.setCreationDate(baselineSet.getCreationDate().getTime());
        baselineSetDTO.setCreatorContributorItemId(baselineSet.getCreator().getItemId().getUuidValue());
        baselineSetDTO.setItemId(baselineSet.getItemId().getUuidValue());
        baselineSetDTO.setModifiedDate(baselineSet.modified().getTime());
        baselineSetDTO.setModifierContributorItemId(baselineSet.getModifiedBy().getItemId().getUuidValue());
        baselineSetDTO.setName(baselineSet.getName());
        baselineSetDTO.setOwnerWorkspaceItemId(baselineSet.getOwner().getItemId().getUuidValue());
        baselineSetDTO.setRepositoryURL(repository.getRepositoryURI());
        for (IBaselineHandle baselineHandle : baselineSet.getBaselines()) {
            baselineSetDTO.getBaselineItemIds().add(baselineHandle.getItemId().getUuidValue());
        }
        return baselineSetDTO;
    }

    public static ProblemChangeSetsDTO translateProblemChangeSetsDTO(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changeSets) {
        ProblemChangeSetsDTO problemChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createProblemChangeSetsDTO();
        problemChangeSetsDTO.setRepositoryURL(workspace.teamRepository().getRepositoryURI());
        problemChangeSetsDTO.setWorkspaceItemId(workspace.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle iChangeSetHandle : changeSets) {
            problemChangeSetsDTO.getChangeSetItemIds().add(iChangeSetHandle.getItemId().getUuidValue());
        }
        return problemChangeSetsDTO;
    }

    public static GapChangeSetsDTO translateGapProblemChangeSetsDTO(IWorkspaceConnection workspace, Collection<IChangeSetHandle> changeSets, boolean handlingSuspended) {
        GapChangeSetsDTO gapChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createGapChangeSetsDTO();
        gapChangeSetsDTO.setRepositoryURL(workspace.teamRepository().getRepositoryURI());
        gapChangeSetsDTO.setWorkspaceItemId(workspace.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle changeSet : changeSets) {
            gapChangeSetsDTO.getChangeSetItemIds().add(changeSet.getItemId().getUuidValue());
        }
        gapChangeSetsDTO.setHandlingSuspended(handlingSuspended);
        return gapChangeSetsDTO;
    }

    private static String visibilityToString(Visibility visibility) {
        if (visibility.getVisibility().equals((Object)VisibilityEnum.PRIVATE_TO_OWNER)) {
            return "private";
        }
        if (visibility.getVisibility().equals((Object)VisibilityEnum.PUBLIC_TO_ALL)) {
            return "public";
        }
        return "project";
    }

    private static WorkspaceFlowEntryDTO translateFlowEntry(IFlowEntry entry, IWorkspaceHandle defaultCollaborationHandle, IWorkspaceHandle currentCollaborationHandle, ITeamRepository repo) {
        WorkspaceFlowEntryDTO flowEntry = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceFlowEntryDTO();
        flowEntry.setRepositoryURL(repo.getRepositoryURI());
        flowEntry.setWorkspaceItemId(entry.getFlowNode().getItemId().getUuidValue());
        boolean isCurrentFlow = false;
        if (currentCollaborationHandle != null) {
            isCurrentFlow = currentCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode());
        }
        flowEntry.setCurrentFlow(isCurrentFlow);
        boolean isDefaultFlow = false;
        if (defaultCollaborationHandle != null) {
            isDefaultFlow = defaultCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode());
        }
        flowEntry.setDefaultFlow(isDefaultFlow);
        List componentScopes = entry.getComponentScopes();
        for (IComponentHandle componentHandle : componentScopes) {
            flowEntry.getScopedComponentItemIds().add(componentHandle.getItemId().getUuidValue());
        }
        return flowEntry;
    }

    public static ShareableDTO translateShareable(IShareable shareable) {
        ShareableDTO shareableDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createShareableDTO();
        if (shareable != null) {
            shareableDTO.setSandboxPath(shareable.getSandbox().getRoot().toOSString());
            shareableDTO.setRelativePath(CoreUtil.translatePath(shareable.getLocalPath()));
        }
        return shareableDTO;
    }

    public static SandboxDTO translateSandbox(ISandbox sandbox, boolean computeFully, IProgressMonitor progress) throws FileSystemClientException {
        SandboxDTO dto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createSandboxDTO();
        dto.setSandboxPath(sandbox.getRoot().toOSString());
        dto.setCaseSensitive(Boolean.valueOf(sandbox.isCaseSensitive()));
        if (computeFully) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
            List shares = dto.getAllShares();
            IShare[] iShareArray = sandbox.allShares((IProgressMonitor)monitor.newChild(1));
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                shares.add(CoreUtil.translateShare(share));
                ++n2;
            }
            dto.setCorrupted(Boolean.valueOf(sandbox.isCorrupted((IProgressMonitor)monitor.newChild(1))));
        }
        return dto;
    }

    public static String getVersionableItemType(IItemType itemType) {
        if (IFileItem.ITEM_TYPE.equals(itemType)) {
            return "file";
        }
        if (IFolder.ITEM_TYPE.equals(itemType)) {
            return "folder";
        }
        if (ISymbolicLink.ITEM_TYPE.equals(itemType)) {
            return "symbolic_link";
        }
        return "";
    }

    public static String getVersionableItemType(IVersionableHandle versionableHandle) {
        if (versionableHandle instanceof IFileItemHandle) {
            return "file";
        }
        if (versionableHandle instanceof IFolderHandle) {
            return "folder";
        }
        if (versionableHandle instanceof ISymbolicLinkHandle) {
            return "symbolic_link";
        }
        return "";
    }
}

