/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser.data;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.parser.data.JUnitParserErrorData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestCaseData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestClassData;
import java.util.Hashtable;

public class JUnitParserTestSuiteData {
    private final String fTestSuiteName;
    private final int fTestCount;
    private final int fErrorCount;
    private final int fFailureCount;
    private final long fTimeTaken;
    private JUnitParserErrorData fErrorData;
    private Hashtable<String, JUnitParserTestClassData> fTestClasses = new Hashtable();

    public JUnitParserTestSuiteData(String testSuiteName, int testCount, int failureCount, int errorCount, long timeTaken) throws IllegalArgumentException {
        ValidationHelper.validateNotEmpty((String)"testSuiteName", (String)testSuiteName);
        this.fTestSuiteName = testSuiteName;
        this.fTestCount = testCount;
        this.fFailureCount = failureCount;
        this.fErrorCount = errorCount;
        this.fTimeTaken = timeTaken;
    }

    public void addTestCase(JUnitParserTestCaseData testCase) {
        ValidationHelper.validateNotNull((String)"testCase", (Object)testCase);
        String className = testCase.getTestClassName();
        JUnitParserTestClassData testClass = this.fTestClasses.get(className);
        if (testClass == null) {
            testClass = new JUnitParserTestClassData(className, this.fTestClasses.size() + 1);
            this.fTestClasses.put(className, testClass);
        }
        testClass.addTestCase(testCase);
    }

    public JUnitParserTestClassData[] getTestClasses() {
        return this.fTestClasses.values().toArray(new JUnitParserTestClassData[this.fTestClasses.size()]);
    }

    public String getTestSuiteName() {
        return this.fTestSuiteName;
    }

    public int getTestCount() {
        return this.fTestCount;
    }

    public int getFailureCount() {
        return this.fFailureCount;
    }

    public int getErrorCount() {
        return this.fErrorCount;
    }

    public long getTimeTaken() {
        return this.fTimeTaken;
    }

    public JUnitParserErrorData getErrorData() {
        return this.fErrorData;
    }

    public void setErrorData(JUnitParserErrorData errorData) {
        this.fErrorData = errorData;
    }

    public boolean isError() {
        return this.getErrorData() != null;
    }
}

