/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal.util;

import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.common.util.NLS;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class MonitoredInputStream
extends FilterInputStream {
    private final int numAttempts;
    private final IProgressMonitor monitor;
    private final long estimatedBytes;
    private long readBytes;
    private boolean cancellable;
    private final String estimatedBytesHumanReadable;
    private final long startTime;

    public MonitoredInputStream(InputStream in, int numAttempts, long estimatedBytes, IProgressMonitor monitor) {
        super(in);
        this.numAttempts = numAttempts;
        this.estimatedBytes = estimatedBytes;
        this.readBytes = 0L;
        this.cancellable = true;
        this.monitor = monitor;
        if (this.monitor != null) {
            this.monitor.beginTask(null, (int)estimatedBytes);
        }
        this.estimatedBytesHumanReadable = ClientUtil.bytesAsHumanReadable(estimatedBytes);
        this.startTime = System.currentTimeMillis();
    }

    public void close() throws IOException {
        int attempts = 0;
        boolean stop = false;
        while (!stop) {
            try {
                this.in.close();
                stop = true;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.cancelIfRequested();
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(Messages.getServerString("_NoId.MonitoredInputStream.CloseTimeout"));
            }
        }
        if (this.monitor != null) {
            this.monitor.subTask(new String());
            this.monitor.done();
        }
    }

    public int read() throws IOException {
        int attempts = 0;
        while (true) {
            this.cancelIfRequested();
            try {
                int b = this.in.read();
                if (b != -1) {
                    this.advance(1L);
                }
                return b;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(Messages.getServerString("_NoId.MonitoredInputStream.ReadTimeout"));
            }
            break;
        }
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        int attempts = 0;
        while (true) {
            this.cancelIfRequested();
            try {
                int count = this.in.read(buffer, off, len);
                if (count > 0) {
                    this.advance(count);
                }
                return count;
            }
            catch (InterruptedIOException e) {
                int count = e.bytesTransferred;
                if (count <= 0) continue;
                this.advance(count);
                return count;
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(Messages.getServerString("_NoId.MonitoredInputStream.ReadTimeout"));
            }
            break;
        }
    }

    public long skip(long count) throws IOException {
        int attempts = 0;
        while (true) {
            this.cancelIfRequested();
            try {
                long skipped = this.in.skip(count);
                if (skipped > 0L) {
                    this.advance(skipped);
                }
                return skipped;
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred == 0) continue;
                return e.bytesTransferred;
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(Messages.getServerString("_NoId.MonitoredInputStream.ReadTimeout"));
            }
            break;
        }
    }

    public void setIsCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private void cancelIfRequested() {
        if (this.cancellable && this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void advance(long count) {
        if (this.monitor != null) {
            this.readBytes += count;
            if (this.readBytes <= this.estimatedBytes) {
                this.monitor.worked((int)count);
            }
            if (this.startTime + 1000L < System.currentTimeMillis()) {
                String msg = NLS.bind((String)Messages.getServerString("_NoId.MonitoredInputStream.TransferStatus"), (Object)ClientUtil.bytesAsHumanReadable(this.readBytes), (Object[])new Object[]{this.estimatedBytesHumanReadable});
                this.monitor.subTask(msg);
            }
        }
    }
}

