/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItemType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class Statistics
extends EventSource
implements IStatistics {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private final TeamRepository repository;
    private final Map contextTypesMap;
    private final Object lock;
    private boolean enabled = false;

    public Statistics(TeamRepository repository) {
        this.repository = repository;
        this.contextTypesMap = new HashMap();
        this.lock = new Object();
    }

    public final ITeamRepository teamRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getContextTypes() {
        Object object = this.lock;
        synchronized (object) {
            this.enabled = true;
            Set contextTypes = this.contextTypesMap.keySet();
            if (contextTypes.isEmpty()) {
                return EMPTY_STRINGS;
            }
            return contextTypes.toArray(new String[contextTypes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getContexts(String contextType) {
        Object object = this.lock;
        synchronized (object) {
            this.enabled = true;
            Map contextsMap = (Map)this.contextTypesMap.get(contextType);
            if (contextsMap == null) {
                return EMPTY_OBJECTS;
            }
            Set contexts = contextsMap.keySet();
            if (contexts.isEmpty()) {
                return EMPTY_OBJECTS;
            }
            return contexts.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStatisticNames(String contextType, Object context) {
        Object object = this.lock;
        synchronized (object) {
            this.enabled = true;
            Map contextsMap = (Map)this.contextTypesMap.get(contextType);
            if (contextsMap == null) {
                return EMPTY_STRINGS;
            }
            Map statisticsMap = (Map)contextsMap.get(context);
            if (statisticsMap == null) {
                return EMPTY_STRINGS;
            }
            Set statisticNames = statisticsMap.keySet();
            if (statisticNames.isEmpty()) {
                return EMPTY_STRINGS;
            }
            return statisticNames.toArray(new String[statisticNames.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStatisticValue(String contextType, Object context, String statisticName) {
        Object object = this.lock;
        synchronized (object) {
            StatisticValue statisticValue;
            block8: {
                Map statisticsMap;
                block7: {
                    Map contextsMap;
                    block6: {
                        this.enabled = true;
                        contextsMap = (Map)this.contextTypesMap.get(contextType);
                        if (contextsMap != null) break block6;
                        return 0L;
                    }
                    statisticsMap = (Map)contextsMap.get(context);
                    if (statisticsMap != null) break block7;
                    return 0L;
                }
                statisticValue = (StatisticValue)statisticsMap.get(statisticName);
                if (statisticValue != null) break block8;
                return 0L;
            }
            return statisticValue.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setStatisticValue(String contextType, Object context, String statisticName, long value) {
        if (!this.enabled()) {
            return 0L;
        }
        long oldValue = 0L;
        long newValue = 0L;
        Object object = this.lock;
        synchronized (object) {
            StatisticValue statisticValue;
            HashMap<String, StatisticValue> statisticsMap;
            IdentityHashMap contextsMap = (IdentityHashMap)this.contextTypesMap.get(contextType);
            if (contextsMap == null) {
                contextsMap = new IdentityHashMap(0);
                this.contextTypesMap.put(contextType, contextsMap);
            }
            if ((statisticsMap = (HashMap<String, StatisticValue>)contextsMap.get(context)) == null) {
                statisticsMap = new HashMap<String, StatisticValue>();
                contextsMap.put(context, statisticsMap);
            }
            if ((statisticValue = (StatisticValue)statisticsMap.get(statisticName)) == null) {
                statisticValue = new StatisticValue();
                statisticsMap.put(statisticName, statisticValue);
            }
            oldValue = statisticValue.value;
            statisticValue.value = newValue = value;
        }
        if (oldValue != newValue) {
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", context, statisticName, new Long(oldValue), new Long(newValue), -1, contextType));
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incStatisticValue(String contextType, Object context, String statisticName, long add) {
        if (!this.enabled()) {
            return 0L;
        }
        long oldValue = 0L;
        long newValue = 0L;
        Object object = this.lock;
        synchronized (object) {
            StatisticValue statisticValue;
            HashMap<String, StatisticValue> statisticsMap;
            IdentityHashMap contextsMap = (IdentityHashMap)this.contextTypesMap.get(contextType);
            if (contextsMap == null) {
                contextsMap = new IdentityHashMap(0);
                this.contextTypesMap.put(contextType, contextsMap);
            }
            if ((statisticsMap = (HashMap<String, StatisticValue>)contextsMap.get(context)) == null) {
                statisticsMap = new HashMap<String, StatisticValue>();
                contextsMap.put(context, statisticsMap);
            }
            if ((statisticValue = (StatisticValue)statisticsMap.get(statisticName)) == null) {
                statisticValue = new StatisticValue();
                statisticsMap.put(statisticName, statisticValue);
            }
            oldValue = statisticValue.value;
            statisticValue.value = newValue = oldValue + add;
        }
        if (oldValue != newValue) {
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", context, statisticName, new Long(oldValue), new Long(newValue), -1, contextType));
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decStatisticValue(String contextType, Object context, String statisticName, long remove) {
        if (!this.enabled()) {
            return 0L;
        }
        long oldValue = 0L;
        long newValue = 0L;
        Object object = this.lock;
        synchronized (object) {
            StatisticValue statisticValue;
            block11: {
                Map statisticsMap;
                block10: {
                    Map contextsMap;
                    block9: {
                        contextsMap = (Map)this.contextTypesMap.get(contextType);
                        if (contextsMap != null) break block9;
                        return 0L;
                    }
                    statisticsMap = (Map)contextsMap.get(context);
                    if (statisticsMap != null) break block10;
                    return 0L;
                }
                statisticValue = (StatisticValue)statisticsMap.get(statisticName);
                if (statisticValue != null) break block11;
                return 0L;
            }
            oldValue = statisticValue.value;
            newValue = oldValue - remove;
            if (newValue < 0L) {
                newValue = 0L;
            }
            statisticValue.value = newValue;
        }
        if (oldValue != newValue) {
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", context, statisticName, new Long(oldValue), new Long(newValue), -1, contextType));
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStatisticValue(String contextType, Object context, String statisticName) {
        if (!this.enabled()) {
            return;
        }
        long oldValue = 0L;
        long newValue = 0L;
        Object object = this.lock;
        synchronized (object) {
            Map contextsMap = (Map)this.contextTypesMap.get(contextType);
            if (contextsMap == null) {
                return;
            }
            Map statisticsMap = (Map)contextsMap.get(context);
            if (statisticsMap == null) {
                return;
            }
            StatisticValue statisticValue = (StatisticValue)statisticsMap.get(statisticName);
            if (statisticValue == null) {
                return;
            }
            oldValue = statisticValue.value;
            statisticValue.value = newValue = 0L;
        }
        if (oldValue != newValue) {
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", context, "totalCacheSize", new Long(oldValue), new Long(newValue), -1, contextType));
        }
    }

    public IItemType[] getItemTypes() {
        Object[] contexts = this.getContexts("com.ibm.team.repository.statistics.itemType");
        return Arrays.asList(contexts).toArray(new IItemType[contexts.length]);
    }

    public long getItemTypeCacheSize(IItemType itemType) {
        return this.getStatisticValue("com.ibm.team.repository.statistics.itemType", itemType, "itemTypeCacheSize");
    }

    public long getItemTypeCacheCount(IItemType itemType) {
        return this.getStatisticValue("com.ibm.team.repository.statistics.itemType", itemType, "itemTypeCacheCount");
    }

    public long getItemTypeCacheHits(IItemType itemType) {
        return this.getStatisticValue("com.ibm.team.repository.statistics.itemType", itemType, "itemTypeCacheHits");
    }

    public long getItemTypeCacheMisses(IItemType itemType) {
        return this.getStatisticValue("com.ibm.team.repository.statistics.itemType", itemType, "itemTypeCacheMisses");
    }

    public long getItemTypeCacheRefreshes(IItemType itemType) {
        return this.getStatisticValue("com.ibm.team.repository.statistics.itemType", itemType, "itemTypeCacheRefreshes");
    }

    public Method[] getServiceMethods() {
        Object[] contexts = this.getContexts("com.ibm.team.repository.statistics.serviceMethod");
        return Arrays.asList(contexts).toArray(new Method[contexts.length]);
    }

    public long getServiceMethodCallCount(Method method) {
        return this.getStatisticValue("com.ibm.team.repository.statistics.serviceMethod", method, "serviceMethodCallCount");
    }

    public long getServiceMethodElapsedTime(Method method) {
        return this.getStatisticValue("com.ibm.team.repository.statistics.serviceMethod", method, "serviceMethodElapsedTime");
    }

    public Object[] getServices() {
        Object[] contexts = this.getContexts("com.ibm.team.repository.statistics.service");
        return Arrays.asList(contexts).toArray(new Object[contexts.length]);
    }

    public long getServiceCallCount(Object service) {
        return this.getStatisticValue("com.ibm.team.repository.statistics.service", service, "serviceCallCount");
    }

    public long getServiceElapsedTime(Object service) {
        return this.getStatisticValue("com.ibm.team.repository.statistics.service", service, "serviceElapsedTime");
    }

    public long getTotalCacheSize() {
        return this.getStatisticValue("com.ibm.team.repository.totalContext", this.teamRepository(), "totalCacheSize");
    }

    public long getTotalCacheCount() {
        return this.getStatisticValue("com.ibm.team.repository.totalContext", this.teamRepository(), "totalCacheCount");
    }

    public long getTotalCacheHits() {
        return this.getStatisticValue("com.ibm.team.repository.totalContext", this.teamRepository(), "totalCacheHits");
    }

    public long getTotalCacheMisses() {
        return this.getStatisticValue("com.ibm.team.repository.totalContext", this.teamRepository(), "totalCacheMisses");
    }

    public long getTotalCacheRefreshes() {
        return this.getStatisticValue("com.ibm.team.repository.totalContext", this.teamRepository(), "totalCacheRefreshes");
    }

    public long getTotalServiceCallCount() {
        return this.getStatisticValue("com.ibm.team.repository.totalContext", this.teamRepository(), "totalServiceCallCount");
    }

    public long getTotalServiceElapsedTime() {
        return this.getStatisticValue("com.ibm.team.repository.totalContext", this.teamRepository(), "totalServiceElapsedTime");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enabled() {
        boolean hasListeners = this.hasGenericListeners();
        Object object = this.lock;
        synchronized (object) {
            if (!this.enabled) {
                this.enabled = hasListeners;
            }
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        Object object = this.lock;
        synchronized (object) {
            this.enabled = true;
        }
    }

    private static class StatisticValue {
        public long value = 0L;

        private StatisticValue() {
        }
    }
}

