/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ConnectionUtil;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.IRepositoryRemoteService;
import com.ibm.team.repository.common.internal.util.ComponentRegistry;
import com.ibm.team.repository.common.internal.util.IComponentElementDescriptor;
import com.ibm.team.repository.common.internal.util.IModelElementDescriptor;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HostUnknownException;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceInterfaceProxy
implements InvocationHandler {
    private final Object delegate;
    private final String serviceName;
    private final TeamRepository repository;

    static Object newServiceInterfaceProxy(Class<?> interfaceClass, Object serviceImplementation, TeamRepository repository) {
        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new ServiceInterfaceProxy(serviceImplementation, interfaceClass.getName(), repository));
    }

    protected ServiceInterfaceProxy(Object delegate, String serviceName, TeamRepository repository) {
        this.delegate = delegate;
        this.serviceName = serviceName;
        this.repository = repository;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        long start = System.currentTimeMillis();
        boolean connectionError = false;
        try {
            try {
                ThreadCheck.checkLongOpsAllowed();
                TeamServiceCallContextImpl.checkCancelable();
                this.validateServiceCall(method);
                result = this.invokeServiceCall(method, args);
                this.repository.setErrorState(0, null);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (this.couldHaveLoggedIn(cause)) {
                        this.ensureLoggedIn(method);
                    }
                    if (cause instanceof Exception) {
                        connectionError = ConnectionUtil.setConnectionError((Exception)cause, this.repository);
                    }
                    if (cause instanceof TeamRepositoryException) {
                        ((TeamRepositoryException)cause).setOrigin((Object)this.repository);
                    }
                    throw cause;
                }
                throw e;
            }
        }
        finally {
            if (!connectionError) {
                long elapsedTime = System.currentTimeMillis() - start;
                this.repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", method, "serviceMethodElapsedTime", elapsedTime);
                this.repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.service", this.delegate, "serviceElapsedTime", elapsedTime);
                this.repository.statistics().incStatisticValue("com.ibm.team.repository.totalContext", this.repository, "totalServiceElapsedTime", elapsedTime);
            }
            this.repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", method, "serviceMethodCallCount", 1L);
            this.repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.service", this.delegate, "serviceCallCount", 1L);
            this.repository.statistics().incStatisticValue("com.ibm.team.repository.totalContext", this.repository, "totalServiceCallCount", 1L);
        }
        if (result instanceof EObject) {
            ClientUtil.makeImmutable((ITeamRepository)this.repository, (EObject)result);
        } else if (result instanceof Collection) {
            ClientUtil.makeImmutable((ITeamRepository)this.repository, (Collection)result);
        } else if (result instanceof Object[]) {
            ClientUtil.makeImmutable((ITeamRepository)this.repository, (Object[])result);
        }
        return result;
    }

    private boolean couldHaveLoggedIn(Throwable th) {
        if (th instanceof HostUnknownException) {
            return false;
        }
        if (th instanceof AuthenticationException) {
            return false;
        }
        return !(th instanceof ConnectionException);
    }

    private Object invokeServiceCall(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Object result;
        try {
            this.repository.statistics().incStatisticValue("com.ibm.team.repository.beingCalledContext", this.repository, "debugBeingCalledFlag", 1L);
            if (this.repository.getDebugMode() == 1) {
                try {
                    Thread.sleep(this.repository.getConnectionTimeout() * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
            result = method.invoke(this.delegate, args);
        }
        finally {
            this.repository.statistics().decStatisticValue("com.ibm.team.repository.beingCalledContext", this.repository, "debugBeingCalledFlag", 1L);
        }
        return result;
    }

    protected boolean shouldValidate() {
        return true;
    }

    private void validateServiceCall(Method method) throws TeamRepositoryException {
        IComponentElementDescriptor componentElementDescriptor;
        if (!this.shouldValidate()) {
            return;
        }
        this.ensureLoggedIn(method);
        String serviceUri = this.serviceName;
        if (serviceUri.equals(Object.class.getName())) {
            return;
        }
        if (serviceUri.equals(ITeamRestServiceClient.IRestClientConnection.class.getName())) {
            serviceUri = ((ITeamRestServiceClient.IRestClientConnection)this.delegate).getServiceUri();
        }
        if ((componentElementDescriptor = ComponentRegistry.INSTANCE.getComponentDescriptorForServiceUri(serviceUri)) == null) {
            String message = NLS.bind((String)Messages.getServerString("ServiceInterfaceProxy.ServiceNotAccessible"), (Object)serviceUri, (Object[])new Object[0]);
            throw new TeamRepositoryException(message);
        }
        IModelElementDescriptor modelElementDescriptor = componentElementDescriptor.getModelElementDescriptor();
        if (modelElementDescriptor == null) {
            return;
        }
        String modelUri = modelElementDescriptor.getUriAttribute();
        String localVersion = ComponentRegistry.INSTANCE.getModelVersion(modelUri);
        String remoteVersion = this.repository.getRemoteVersion(modelUri);
        if (!remoteVersion.equals(localVersion)) {
            String message = this.repository.getRepositoryBuildId() == null || this.repository.getRepositoryVersion() == null ? NLS.bind((String)Messages.getServerString("ServiceInterfaceProxy.VersionMismatch"), (Object)modelUri, (Object[])new Object[]{remoteVersion, localVersion}) : NLS.bind((String)Messages.getServerString("ServiceInterfaceProxy.VersionMismatchWithRepoDetails"), (Object)modelUri, (Object[])new Object[]{remoteVersion, localVersion, this.repository.getRepositoryVersion(), this.repository.getRepositoryBuildId()});
            throw new TeamRepositoryException((Object)this.repository, message);
        }
    }

    private void ensureLoggedIn(Method method) throws NotLoggedInException {
        if (!this.isLoginMethod(method) && this.repository.getState() == 3) {
            String uri = this.repository == null ? "" : this.repository.getRepositoryURI();
            NotLoggedInException e = new NotLoggedInException(uri);
            e.setOrigin((Object)this.repository);
            throw e;
        }
    }

    private boolean isLoginMethod(Method method) {
        return method.getDeclaringClass() == IRepositoryRemoteService.class && (method.getName().equals("describe") || method.getName().equals("fetchDynamicPackages"));
    }
}

