/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.IContentManagerInputStreamProvider;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.IUploadHandler;
import com.ibm.team.repository.client.internal.CombinedCancellationMonitor;
import com.ibm.team.repository.client.internal.ProgressHandlingContentManagerSession;
import com.ibm.team.repository.client.internal.ProgressTrackingInputStream;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.util.ThreadPool;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class AsyncContentManagerSession
extends ProgressHandlingContentManagerSession {
    private final IContentManager manager;
    private final ThreadPool threadPool;

    public AsyncContentManagerSession(int numThreads, boolean allowFailures, String name, int totalWork, IContentManager manager, IProgressMonitor mon) {
        super(name, totalWork, false, mon);
        this.manager = manager;
        this.threadPool = new ThreadPool(numThreads, allowFailures);
    }

    public void join() throws TeamRepositoryException {
        try {
            this.threadPool.join();
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.getServerString("AsyncContentManagerSession.FileTransferInterrupt"), (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void internalRetrieveContent(final IContent content, final IDownloadHandler handler) throws TeamRepositoryException {
        final AsyncContentManagerSession session = this;
        ThreadPool.Task task = new ThreadPool.Task(){

            public IStatus run(IProgressMonitor mon) {
                try {
                    AsyncContentManagerSession.this.handleCancel(content, handler);
                    handler.downloadStart(content);
                    ProgressTrackingInputStream in = new ProgressTrackingInputStream(AsyncContentManagerSession.this.manager.retrieveContentStream(content, (IProgressMonitor)new CombinedCancellationMonitor(mon, AsyncContentManagerSession.this)), session);
                    try {
                        handler.downloadStreamAcquired(content, in);
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                    AsyncContentManagerSession.this.handleCancel(content, handler);
                    handler.downloadCompleted(content);
                    AsyncContentManagerSession.this.handleCancel(content, handler);
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    MultiStatus statusToReturn;
                    block13: {
                        statusToReturn = null;
                        if (e.getCause() instanceof CoreException) {
                            statusToReturn = new MultiStatus("com.ibm.team.repository.client", 0, Messages.getServerString("AsyncContentManagerSession.ContentRetrievalError"), (Throwable)e);
                            statusToReturn.add(((CoreException)e.getCause()).getStatus());
                        } else {
                            statusToReturn = new Status(4, "com.ibm.team.repository.client", 0, Messages.getServerString("AsyncContentManagerSession.ContentRetrievalError"), (Throwable)e);
                        }
                        try {
                            handler.downloadFailed(content, e);
                        }
                        catch (Exception exception) {
                            Status anotherError = new Status(4, "com.ibm.team.repository.client", 0, Messages.getServerString("AsyncContentManagerSession.HandlerNotificationError"), (Throwable)e);
                            if (statusToReturn instanceof MultiStatus) {
                                statusToReturn.add((IStatus)anotherError);
                                break block13;
                            }
                            statusToReturn = new MultiStatus("com.ibm.team.repository.client", 0, new IStatus[]{statusToReturn, anotherError}, Messages.getServerString("AsyncContentManagerSession.ContentRetrievalError"), null);
                        }
                    }
                    return statusToReturn;
                }
            }
        };
        try {
            this.threadPool.addTask(task);
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    protected void internalStoreContent(final IUploadHandler handler) throws TeamRepositoryException {
        ThreadPool.Task task = new ThreadPool.Task(){

            public IStatus run(IProgressMonitor mon) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)new CombinedCancellationMonitor(mon, AsyncContentManagerSession.this), (int)100);
                while (true) {
                    try {
                        AsyncContentManagerSession.this.handleCancel(handler);
                        IContentManagerInputStreamProvider streamProvider = handler.getStreamProvider();
                        String contentType = handler.getContentType();
                        String characterEncoding = handler.getCharacterEncoding();
                        LineDelimiter lineDelimiter = handler.getLineDelimiter();
                        UUID predecessorId = handler.getPredecessorContentId();
                        handler.uploadStart();
                        final IContentManagerInputStreamProvider wrappedStreamProvider = streamProvider;
                        IContentManagerInputStreamProvider overridenProvider = new IContentManagerInputStreamProvider(){

                            public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                                return wrappedStreamProvider.getInputStream(flags);
                            }

                            public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                                return new ProgressTrackingInputStream(wrappedStreamProvider.wrapInputStream(in), AsyncContentManagerSession.this);
                            }
                        };
                        IContent content = AsyncContentManagerSession.this.manager.storeContent(contentType, characterEncoding, lineDelimiter, overridenProvider, predecessorId, (IProgressMonitor)progress.newChild(99));
                        overridenProvider = null;
                        AsyncContentManagerSession.this.handleCancel(handler);
                        handler.uploadCompleted(content);
                        AsyncContentManagerSession.this.handleCancel(handler);
                        return Status.OK_STATUS;
                    }
                    catch (TeamRepositoryException e) {
                        MultiStatus statusToReturn;
                        block10: {
                            statusToReturn = null;
                            if (e.getCause() instanceof CoreException) {
                                statusToReturn = new MultiStatus("com.ibm.team.repository.client", 0, Messages.getServerString("AsyncContentManagerSession.ErrorStoringContent"), (Throwable)e);
                                statusToReturn.add(((CoreException)e.getCause()).getStatus());
                            } else {
                                statusToReturn = new Status(4, "com.ibm.team.repository.client", 0, Messages.getServerString("AsyncContentManagerSession.ErrorStoringContent"), (Throwable)e);
                            }
                            try {
                                progress.setWorkRemaining(101);
                                if (handler.uploadFailed(e, (IProgressMonitor)progress.newChild(1))) {
                                    continue;
                                }
                                break block10;
                            }
                            catch (Exception exception) {
                                Status anotherError = new Status(4, "com.ibm.team.repository.client", 0, Messages.getServerString("AsyncContentManagerSession.ErrorNotifyingHandler"), (Throwable)e);
                                if (statusToReturn instanceof MultiStatus) {
                                    statusToReturn.add((IStatus)anotherError);
                                } else {
                                    statusToReturn = new MultiStatus("com.ibm.team.repository.client", 0, new IStatus[]{statusToReturn, anotherError}, Messages.getServerString("AsyncContentManagerSession.ErrorStoringContent"), null);
                                }
                                break block10;
                            }
                            continue;
                        }
                        return statusToReturn;
                    }
                    break;
                }
            }
        };
        try {
            this.threadPool.addTask(task);
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    private void handleCoreException(CoreException e) throws TeamRepositoryException {
        IStatus status = e.getStatus();
        assert (status.isOK()) : "Unexpected status value. An OK status should not be thrown.";
        if (status.matches(8)) {
            throw new OperationCanceledException();
        }
        try {
            throw new TeamRepositoryException(NLS.bind((String)Messages.getServerString("AsyncContentManagerSession.FileTransferError"), (Object)e.getStatus().getException().getMessage(), (Object[])new Object[0]), (Throwable)e);
        }
        catch (NullPointerException nullPointerException) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.getServerString("AsyncContentManagerSession.FileTransferError"), (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
        }
    }

    private void handleCancel(IContent content, IDownloadHandler handler) throws TeamRepositoryException {
        if (this.isCanceled()) {
            handler.downloadCanceled(content);
            throw new OperationCanceledException();
        }
    }

    private void handleCancel(IUploadHandler handler) throws TeamRepositoryException {
        if (this.isCanceled()) {
            handler.uploadCanceled();
            throw new OperationCanceledException();
        }
    }

    public boolean isCanceled() {
        boolean canceled = super.isCanceled();
        if (canceled) {
            this.threadPool.setCancellation(Status.CANCEL_STATUS);
        }
        return canceled || this.threadPool.isCanceled();
    }

    public IStatus[] getErrorStatus() {
        return this.threadPool.getErrorStatus();
    }
}

