/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.specification;

import com.ibm.team.process.internal.common.InternalProcessCommon;
import com.ibm.team.process.internal.common.model.AbstractElementBuilder;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationBuilder;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationElement;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.TeamConfigurationElement;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessSpecificationModel
extends AbstractModel {
    public static final int COMPLETE = 2;
    public static final int ITERATION_STRUCTURE_ONLY = 4;
    private final int fFlags;

    public ProcessSpecificationModel() {
        this(2);
    }

    public ProcessSpecificationModel(int flags) {
        this.fFlags = flags;
    }

    protected ModelGenerator createModelGenerator() {
        ModelGenerator generator = new ModelGenerator(this);
        if ((this.fFlags & 4) != 0) {
            generator.setDirective(ElementBuilderDirectives.ITERATION_STRUCTURE_ONLY, Boolean.TRUE);
        }
        return generator;
    }

    public ProcessSpecificationElement getRoot() {
        List childElements = this.getChildElements();
        if (childElements.size() > 0) {
            return (ProcessSpecificationElement)childElements.get(0);
        }
        return null;
    }

    public static String toXMLData(ProcessSpecificationElement settings) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = settings.createElement(document);
            root.setAttribute("xmlns", "http://com.ibm.team.process");
            document.appendChild(root);
            return AbstractModel.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            InternalProcessCommon.log(e);
        }
        catch (TransformerException e) {
            InternalProcessCommon.log(e);
        }
        catch (IOException e) {
            InternalProcessCommon.log(e);
        }
        return null;
    }

    public AbstractElementBuilder getRootBuilder() {
        return new ProcessSpecificationBuilder();
    }

    public TeamConfigurationElement getTeamConfiguration() {
        return (TeamConfigurationElement)super.getTeamConfiguration();
    }

    public ProjectConfigurationElement getProjectConfiguration() {
        ProcessSpecificationElement root = this.getRoot();
        if (root instanceof ProcessSpecificationElement) {
            return root.getProjectConfiguration();
        }
        return null;
    }
}

