/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.settings;

import com.ibm.team.process.common.IRole2;
import com.ibm.team.process.internal.common.model.AbstractElement;
import org.xml.sax.Attributes;

public class RoleDefinition
extends AbstractElement
implements IRole2 {
    private int fCardinality = 0;
    public static final String STRING_CARDINALITY_SINGLE = "single";
    public static final String STRING_CARDINALITY_MANY = "many";

    public RoleDefinition(AbstractElement parent, String namespaceURI, String name, Attributes attributes) {
        super(parent, namespaceURI, name, attributes);
        this.processAttributes();
    }

    protected void processAttributes() {
        String cardinality = this.getAttribute("cardinality");
        if (cardinality != null) {
            this.fCardinality = cardinality.equalsIgnoreCase(STRING_CARDINALITY_SINGLE) ? 1 : 0;
        }
    }

    public int getCardinality() {
        return this.fCardinality;
    }

    public String getDescription() {
        return this.getAttribute("description");
    }

    public String getId() {
        return this.getAttribute("role-id");
    }

    public String getRoleName() {
        return this.getAttribute("name");
    }

    public String getRoleLabel() {
        String label = this.getRoleName();
        if (label != null && label.trim().length() > 0) {
            return label;
        }
        return this.getId();
    }

    public String toXML(String prefix, String lineDelimiter) {
        StringBuilder sb = new StringBuilder();
        this.toXML(prefix, lineDelimiter, sb, false);
        return sb.toString();
    }

    public void toXML(String prefix, String lineDelimiter, StringBuilder sb) {
        this.toXML(prefix, lineDelimiter, sb, true);
    }

    protected void toXML(String prefix, String lineDelimiter, StringBuilder sb, boolean appendPrefix) {
        String roleName;
        if (appendPrefix) {
            sb.append(prefix);
        }
        sb.append('<').append("role-definition").append(' ').append("cardinality").append("=\"").append(this.getAttribute("cardinality")).append('\"');
        String description = this.getDescription();
        if (description != null && description.length() > 0) {
            sb.append(' ').append("description").append("=\"").append(description).append('\"');
        }
        if ((roleName = this.getRoleName()) == null || roleName.trim().length() == 0) {
            roleName = "";
        }
        sb.append(' ').append("name").append("=\"").append(roleName).append('\"');
        sb.append(' ').append("role-id").append("=\"").append(this.getAttribute("role-id")).append('\"');
        sb.append("/>\n");
    }
}

