/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.workingcopies.IContributorListWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessAttachmentsWorkingCopy;
import com.ibm.team.process.client.workingcopies.ITeamWorkingCopy;
import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.client.workingcopies.IWorkingCopyListener;
import com.ibm.team.process.client.workingcopies.IWorkingCopyManager;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessContainer;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamData;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.process.internal.client.workingcopies.ContentWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.ContributorListWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.ExecUtil;
import com.ibm.team.process.internal.client.workingcopies.FileURLWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.IPropertyWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.client.workingcopies.ProcessAttachmentsWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.ServerRequest;
import com.ibm.team.process.internal.client.workingcopies.StringWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.TeamWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.UpdateRequest;
import com.ibm.team.process.internal.common.RolePersistence;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;

public abstract class ProcessAreaWorkingCopy
implements IProcessAreaWorkingCopy {
    protected ITeamRepository fCachedTeamRepository;
    protected IProcessItemService fCachedService;
    private IProcessArea fProcessAreaState;
    private StringWorkingCopy fName;
    private StringWorkingCopy fSummary;
    private ContentWorkingCopy fDescription;
    private ContributorListWorkingCopy fAdministrators;
    private TeamWorkingCopy fTeam;
    private StringWorkingCopy fProcessName;
    private StringWorkingCopy fProcessSummary;
    private FileURLWorkingCopy fProcessContentURL;
    private ContentWorkingCopy fProcessCustomization;
    private CustomizationState fCustomizationState;
    private ProcessAttachmentsWorkingCopy fProcessAttachments;
    private int fUpdateContextRequested;
    private boolean fIsDirty = false;
    private boolean fDerivedIsDirty = false;
    private ListenerList fListenerList = new ListenerList();
    private WorkingCopyListener fWorkingCopyListener = new WorkingCopyListener();
    private Set fPropertyWorkingCopies = new HashSet();
    private SharedItemChangeListener fSharedItemChangeListener = new SharedItemChangeListener();
    private Object fSaveMutex = new Object();

    protected ProcessAreaWorkingCopy(IProcessArea processArea, boolean listenToProjectArea) {
        if (processArea == null) {
            throw new IllegalArgumentException(Messages.getString("ProcessAreaWorkingCopy.1"));
        }
        if (processArea.isWorkingCopy()) {
            throw new IllegalArgumentException(Messages.getString("ProcessAreaWorkingCopy.2"));
        }
        this.fCachedTeamRepository = (ITeamRepository)processArea.getOrigin();
        this.fCachedService = (IProcessItemService)this.fCachedTeamRepository.getClientLibrary(IProcessItemService.class);
        IItemManager itemManager = this.fCachedTeamRepository.itemManager();
        this.fProcessAreaState = (IProcessArea)itemManager.getImmutableState((IItem)processArea);
        if (this.fProcessAreaState != null) {
            this.fCustomizationState = new CustomizationState(this.fProcessAreaState);
            itemManager.addItemChangeListener((IItem)processArea, (ISharedItemChangeListener)this.fSharedItemChangeListener);
            itemManager.addItemChangeListener(IContributor.ITEM_TYPE, (ISharedItemChangeListener)this.fSharedItemChangeListener);
            if (listenToProjectArea) {
                itemManager.addItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)this.fSharedItemChangeListener);
            }
        } else {
            this.fProcessAreaState = processArea;
            this.fCustomizationState = new CustomizationState(this.fProcessAreaState);
        }
    }

    public final void requestUpdateContext() {
        ++this.fUpdateContextRequested;
    }

    public final void releaseUpdateContext() {
        --this.fUpdateContextRequested;
    }

    protected final IUpdateContext getUpdateContext() {
        if (this.fUpdateContextRequested > 0) {
            IWorkingCopyManager manager = this.fCachedService.getWorkingCopyManager();
            return manager.getUpdateContext();
        }
        return null;
    }

    public final void addWorkingCopyListener(IWorkingCopyListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public final void removeWorkingCopyListener(IWorkingCopyListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    public final IProcessArea getUnderlyingProcessArea() {
        return this.fProcessAreaState;
    }

    public final IProcessItem getUnderlyingProcessItem() {
        return this.getUnderlyingProcessArea();
    }

    public void asyncInitialize(Collection propertyIds) {
        if (propertyIds == null) {
            this.getDescription();
            this.getAdministrators();
            this.getTeam();
            this.getProcessAttachments();
            this.getProcessCustomization();
        } else {
            if (propertyIds.contains("descriptionDetails")) {
                this.getDescription();
            }
            if (propertyIds.contains("administrators")) {
                this.getAdministrators();
            }
            if (propertyIds.contains("teamMembers")) {
                this.getTeam();
            }
            if (propertyIds.contains("processAttachments")) {
                this.getProcessAttachments();
            }
            if (propertyIds.contains("processCustomization")) {
                this.getProcessCustomization();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getName() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fName == null) {
            ProcessAreaWorkingCopy processAreaWorkingCopy = this;
            synchronized (processAreaWorkingCopy) {
                if (this.fName == null) {
                    this.fName = new StringWorkingCopy(this.fProcessAreaState.getName());
                    this.addPropertyWorkingCopy(this.fName);
                }
            }
        }
        return this.fName == null ? null : this.fName.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getSummary() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fSummary == null) {
            ProcessAreaWorkingCopy processAreaWorkingCopy = this;
            synchronized (processAreaWorkingCopy) {
                if (this.fSummary == null) {
                    this.fSummary = new StringWorkingCopy(this.fProcessAreaState.getDescription().getSummary());
                    this.addPropertyWorkingCopy(this.fSummary);
                }
            }
        }
        return this.fSummary == null ? null : this.fSummary.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getDescription() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fDescription == null) {
            ProcessAreaWorkingCopy processAreaWorkingCopy = this;
            synchronized (processAreaWorkingCopy) {
                if (this.fDescription == null) {
                    ContentWorkingCopy description = new ContentWorkingCopy(this.fCachedTeamRepository, "text/xml", "UTF8");
                    this.addPropertyWorkingCopy(description);
                    description.asyncUpdate(this.fProcessAreaState.getDescription().getDetails(), 1, this.getUpdateContext(), null);
                    this.fDescription = description;
                }
            }
        }
        return this.fDescription == null ? null : this.fDescription.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContributorListWorkingCopy getAdministrators() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fAdministrators == null) {
            ProcessAreaWorkingCopy processAreaWorkingCopy = this;
            synchronized (processAreaWorkingCopy) {
                if (this.fAdministrators == null) {
                    ContributorListWorkingCopy administrators = new ContributorListWorkingCopy(this.fCachedTeamRepository);
                    this.addPropertyWorkingCopy(administrators);
                    administrators.asyncUpdate(new AdministratorProvider(this.fProcessAreaState), 1, this.getUpdateContext(), null);
                    this.fAdministrators = administrators;
                }
            }
        }
        return this.fAdministrators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITeamWorkingCopy getTeam() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fTeam == null) {
            ProcessAreaWorkingCopy processAreaWorkingCopy = this;
            synchronized (processAreaWorkingCopy) {
                if (this.fTeam == null) {
                    TeamWorkingCopy team = new TeamWorkingCopy(this.fCachedTeamRepository, this);
                    this.addPropertyWorkingCopy(team);
                    team.asyncUpdate(new TeamProvider(this.fProcessAreaState), 1, this.getUpdateContext(), null);
                    this.fTeam = team;
                }
            }
        }
        return this.fTeam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getProcessCustomization() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fProcessCustomization == null && this.fCustomizationState.isCustomized()) {
            ProcessAreaWorkingCopy processAreaWorkingCopy = this;
            synchronized (processAreaWorkingCopy) {
                if (this.fProcessCustomization == null && this.fCustomizationState.isCustomized()) {
                    ContentWorkingCopy processCustomization = new ContentWorkingCopy(this.fCachedTeamRepository, "text/xml", "UTF8");
                    this.addPropertyWorkingCopy(processCustomization);
                    IContent content = (IContent)this.fProcessAreaState.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                    processCustomization.asyncUpdate(content, 1, this.getUpdateContext(), null);
                    this.fProcessCustomization = processCustomization;
                }
            }
        }
        return this.fProcessCustomization == null || !this.fCustomizationState.isCustomized() ? null : this.fProcessCustomization.getDocument();
    }

    public void resetProcessCustomization() {
        if (!this.isDisposed() && this.fProcessCustomization != null && this.fProcessCustomization.isDirty()) {
            IContent content = (IContent)this.fProcessAreaState.getProcessData().get("com.ibm.team.internal.process.settings.xml");
            this.fProcessCustomization.asyncUpdate(content, 1, this.getUpdateContext(), null);
            this.fProcessCustomization.setDirty(false);
            this.updateDirtyState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcessAttachmentsWorkingCopy getProcessAttachments() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fProcessAttachments == null) {
            ProcessAreaWorkingCopy processAreaWorkingCopy = this;
            synchronized (processAreaWorkingCopy) {
                if (this.fProcessAttachments == null) {
                    ProcessAttachmentsWorkingCopy attachments = new ProcessAttachmentsWorkingCopy(this.fCachedTeamRepository);
                    this.addPropertyWorkingCopy(attachments);
                    attachments.asyncUpdate((IProcessContainer)this.fProcessAreaState, 1, this.getUpdateContext(), null);
                    this.fProcessAttachments = attachments;
                }
            }
        }
        return this.fProcessAttachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getProcessName() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fProcessName == null) {
            ProcessAreaWorkingCopy processAreaWorkingCopy = this;
            synchronized (processAreaWorkingCopy) {
                if (this.fProcessName == null) {
                    this.fProcessName = new StringWorkingCopy(this.fProcessAreaState.getProcessName());
                    this.addPropertyWorkingCopy(this.fProcessName);
                }
            }
        }
        return this.fProcessName == null ? null : this.fProcessName.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getProcessSummary() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fProcessSummary == null) {
            ProcessAreaWorkingCopy processAreaWorkingCopy = this;
            synchronized (processAreaWorkingCopy) {
                if (this.fProcessSummary == null) {
                    this.fProcessSummary = new StringWorkingCopy(this.fProcessAreaState.getProcessSummary());
                    this.addPropertyWorkingCopy(this.fProcessSummary);
                }
            }
        }
        return this.fProcessSummary == null ? null : this.fProcessSummary.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getProcessContentURL() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fProcessContentURL == null) {
            ProcessAreaWorkingCopy processAreaWorkingCopy = this;
            synchronized (processAreaWorkingCopy) {
                if (this.fProcessContentURL == null) {
                    this.fProcessContentURL = new FileURLWorkingCopy(this.fProcessAreaState.getProcessContentPath());
                    this.addPropertyWorkingCopy(this.fProcessContentURL);
                }
            }
        }
        return this.fProcessContentURL == null ? null : this.fProcessContentURL.getDocument();
    }

    public String computeProcessContentURLValue() {
        if (this.isDisposed()) {
            return null;
        }
        return this.fProcessContentURL == null ? null : this.fProcessContentURL.getURL();
    }

    public final boolean isDirty() {
        if (!this.isDisposed()) {
            return this.fDerivedIsDirty || this.fIsDirty;
        }
        return false;
    }

    private final void handlePropertyMarkedAsDirty() {
        if (!this.isDirty()) {
            this.fDerivedIsDirty = true;
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "dirtyState", Boolean.FALSE, Boolean.TRUE));
        } else {
            this.fDerivedIsDirty = true;
        }
    }

    protected final void markDirty(boolean markDrivedIsDirty) {
        if (!this.isDirty()) {
            this.fIsDirty = true;
            if (markDrivedIsDirty) {
                this.fDerivedIsDirty = true;
            }
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "dirtyState", Boolean.FALSE, Boolean.TRUE));
        } else {
            this.fIsDirty = true;
            if (markDrivedIsDirty) {
                this.fDerivedIsDirty = true;
            }
        }
    }

    private final void markNotDirty() {
        if (this.isDirty()) {
            this.fIsDirty = false;
            if (this.fDerivedIsDirty) {
                for (IPropertyWorkingCopy wc : this.fPropertyWorkingCopies) {
                    wc.setDirty(false);
                }
                this.fDerivedIsDirty = false;
            }
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "dirtyState", Boolean.TRUE, Boolean.FALSE));
        }
    }

    protected final void updateDirtyState() {
        boolean wasDirty = this.isDirty();
        this.fDerivedIsDirty = this.computeDerivedDirtyState();
        boolean isDirty = this.isDirty();
        if (wasDirty != this.isDirty()) {
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "dirtyState", wasDirty, isDirty));
        }
    }

    private boolean computeDerivedDirtyState() {
        for (IPropertyWorkingCopy wc : this.fPropertyWorkingCopies) {
            if (!wc.isDirty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ProcessAreaWorkingCopy processAreaWorkingCopy = this;
        synchronized (processAreaWorkingCopy) {
            this.fCachedTeamRepository.itemManager().purgeItemChangeListener((ISharedItemChangeListener)this.fSharedItemChangeListener);
            Iterator e = this.fPropertyWorkingCopies.iterator();
            while (e.hasNext()) {
                IPropertyWorkingCopy wc = (IPropertyWorkingCopy)e.next();
                wc.removeWorkingCopyListener(this.fWorkingCopyListener);
                wc.dispose();
                e.remove();
            }
            this.fProcessAreaState = null;
        }
    }

    public final boolean isDisposed() {
        return this.fProcessAreaState == null;
    }

    protected final void fireWorkingCopyChanged(WorkingCopyChangeEvent event) {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IWorkingCopyListener listener = (IWorkingCopyListener)listeners[i];
            listener.workingCopyChanged(event);
            ++i;
        }
    }

    protected final void addPropertyWorkingCopy(IPropertyWorkingCopy workingCopy) {
        this.fPropertyWorkingCopies.add(workingCopy);
        workingCopy.addWorkingCopyListener(this.fWorkingCopyListener);
    }

    protected final void removePropertyWorkingCopy(IPropertyWorkingCopy workingCopy) {
        if (this.fPropertyWorkingCopies.remove(workingCopy)) {
            workingCopy.removeWorkingCopyListener(this.fWorkingCopyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.isDirty()) {
            return;
        }
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getString("ProcessAreaWorkingCopy.7"), 1600);
        try {
            boolean saveProcessArea = false;
            final IProcessArea mutableProcessArea = (IProcessArea)this.fCachedService.getMutableCopy((IProcessItem)this.fProcessAreaState);
            final ArrayList<IProcessArea> itemsToSave = new ArrayList<IProcessArea>();
            if (this.fDerivedIsDirty) {
                boolean[] save;
                IContent content;
                if (this.fName != null && this.fName.isDirty()) {
                    mutableProcessArea.setName(this.fName.getDocument().get());
                    saveProcessArea = true;
                }
                if (this.fSummary != null && this.fSummary.isDirty()) {
                    mutableProcessArea.getDescription().setSummary(this.fSummary.getDocument().get());
                    saveProcessArea = true;
                }
                if (this.fDescription != null && this.fDescription.isDirty()) {
                    content = this.fDescription.syncSave((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    mutableProcessArea.getDescription().setDetails(content);
                    saveProcessArea = true;
                } else {
                    monitor.worked(100);
                }
                if (this.fAdministrators != null && this.fAdministrators.isDirty()) {
                    save = new boolean[1];
                    ContributorListWorkingCopy.IContributorContainer container = new ContributorListWorkingCopy.IContributorContainer(){

                        public void setContributors(IContributorHandle[] contributors) {
                            mutableProcessArea.setAdministrators(contributors);
                            save[0] = true;
                        }
                    };
                    this.fAdministrators.syncSave(container, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    saveProcessArea = saveProcessArea || save[0];
                } else {
                    monitor.worked(100);
                }
                if (this.fTeam != null && this.fTeam.isDirty()) {
                    mutableProcessArea.removeAllMembers();
                    mutableProcessArea.getTeamData().clear();
                    save = new boolean[1];
                    TeamWorkingCopy.IContributorRoleContainer roleContainer = new TeamWorkingCopy.IContributorRoleContainer(){

                        public void setContributors(IContributorHandle[] contributors) {
                            int i = 0;
                            while (i < contributors.length) {
                                mutableProcessArea.addMember(contributors[i]);
                                ++i;
                            }
                            save[0] = true;
                        }

                        public void setRoleData(IContributorHandle contributorHandle, String roleData) {
                            RolePersistence.setPersistedRoleData((ITeamData)mutableProcessArea.getTeamData(), (IContributorHandle)contributorHandle, (String)roleData);
                            save[0] = true;
                        }
                    };
                    this.fTeam.syncSave(roleContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    saveProcessArea = saveProcessArea || save[0];
                } else {
                    monitor.worked(100);
                }
                if (this.fProcessAttachments != null && this.fProcessAttachments.isDirty()) {
                    if (this.fProcessAttachments.syncSave((IProcessContainer)mutableProcessArea, itemsToSave, (IProgressMonitor)new SubProgressMonitor(monitor, 300))) {
                        saveProcessArea = true;
                    }
                } else {
                    monitor.worked(300);
                }
                if (this.fProcessCustomization != null && this.fProcessCustomization.isDirty() && !this.fCustomizationState.customizationDiscarded()) {
                    content = this.fProcessCustomization.syncSave((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    Map processData = mutableProcessArea.getProcessData();
                    if (content != null) {
                        processData.put("com.ibm.team.internal.process.settings.xml", content);
                    } else {
                        processData.remove("com.ibm.team.internal.process.settings.xml");
                    }
                    saveProcessArea = true;
                } else {
                    monitor.worked(100);
                }
                if (this.fProcessName != null && this.fProcessName.isDirty()) {
                    mutableProcessArea.setProcessName(this.fProcessName.getDocument().get());
                    saveProcessArea = true;
                }
                if (this.fProcessSummary != null && this.fProcessSummary.isDirty()) {
                    mutableProcessArea.setProcessSummary(this.fProcessSummary.getDocument().get());
                    saveProcessArea = true;
                }
                if (this.fProcessContentURL != null && this.fProcessContentURL.isDirty()) {
                    mutableProcessArea.setProcessContentPath(this.fProcessContentURL.getDocument().get());
                    saveProcessArea = true;
                }
                if (this.doSavePropertyWorkingCopies(mutableProcessArea, itemsToSave, (IProgressMonitor)new SubProgressMonitor(monitor, 600))) {
                    saveProcessArea = true;
                }
            } else {
                monitor.worked(1200);
            }
            if (this.fCustomizationState.customizationDiscarded()) {
                if (this.fProcessCustomization != null) {
                    this.removePropertyWorkingCopy(this.fProcessCustomization);
                    this.fProcessCustomization.dispose();
                    this.fProcessCustomization = null;
                }
                Map processData = mutableProcessArea.getProcessData();
                processData.remove("com.ibm.team.internal.process.settings.xml");
            }
            if (saveProcessArea || this.fIsDirty) {
                itemsToSave.add(mutableProcessArea);
            }
            final ArrayList savedItemTrap = new ArrayList();
            Object object = this.fSaveMutex;
            synchronized (object) {
                if (!itemsToSave.isEmpty()) {
                    ServerRequest saveRequest = new ServerRequest(Messages.getString("ProcessAreaWorkingCopy.8")){

                        public void execute(IProgressMonitor monitor) throws TeamRepositoryException {
                            if (itemsToSave.size() == 1) {
                                IProcessItem savedItem = ProcessAreaWorkingCopy.this.fCachedService.save((IProcessItem)itemsToSave.get(0), monitor);
                                savedItemTrap.add(savedItem);
                            } else {
                                IProcessItem[] savedItems = ProcessAreaWorkingCopy.this.fCachedService.save(itemsToSave.toArray(new IProcessItem[itemsToSave.size()]), monitor);
                                savedItemTrap.addAll(Arrays.asList(savedItems));
                            }
                        }
                    };
                    ExecUtil.syncExec(saveRequest, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
                } else {
                    monitor.worked(300);
                }
                for (IProcessItem processItem : savedItemTrap) {
                    if (!mutableProcessArea.sameItemId((IItemHandle)processItem)) continue;
                    this.fProcessAreaState = (IProcessArea)this.fCachedTeamRepository.itemManager().getImmutableState((IItem)processItem);
                    break;
                }
                this.markNotDirty();
            }
            savedItemTrap.clear();
        }
        finally {
            monitor.done();
        }
    }

    protected boolean doSavePropertyWorkingCopies(IProcessArea mutableProcessArea, List processItemsToSaveCollector, IProgressMonitor monitor) throws TeamRepositoryException {
        return false;
    }

    public void createProcessCustomization() {
        if (!this.isDisposed() && !this.fCustomizationState.isCustomized()) {
            this.createProcessCustomization(true);
        }
    }

    private void createProcessCustomization(boolean markDirty) {
        if (!this.isDisposed()) {
            if (!this.fCustomizationState.isCustomized()) {
                IDocument document;
                this.fCustomizationState.requestCustomization();
                if (this.fProcessCustomization != null && (document = this.fProcessCustomization.getDocument()) != null) {
                    document.set("");
                }
                if (markDirty) {
                    this.markDirty(true);
                }
            }
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "processCustomization", null, Boolean.TRUE));
        }
    }

    public void discardProcessCustomization() {
        if (!this.isDisposed() && this.fCustomizationState.isCustomized()) {
            this.discardProcessCustomization(true);
        }
    }

    private void discardProcessCustomization(boolean markDirty) {
        if (!this.isDisposed()) {
            boolean fireEvent = false;
            if (this.fCustomizationState.isCustomized()) {
                this.fCustomizationState.discardCustomization();
                fireEvent = true;
                if (markDirty) {
                    this.markDirty(false);
                }
            }
            if (this.fProcessCustomization != null) {
                fireEvent = true;
            }
            if (fireEvent) {
                this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "processCustomization", Boolean.FALSE, null));
            }
        }
    }

    public void addMembers(IContributor[] contributors) {
        ITeamWorkingCopy team = this.getTeam();
        if (team != null) {
            team.addContributors(contributors);
        }
    }

    public List getMembers() {
        ITeamWorkingCopy team = this.getTeam();
        if (team != null) {
            return team.getContributors();
        }
        return null;
    }

    public void removeMembers(IContributorHandle[] contributors) {
        ITeamWorkingCopy team = this.getTeam();
        if (team != null) {
            team.removeContributors(contributors);
        }
    }

    public IRole[] getRoleCast(IContributorHandle contributor) {
        ITeamWorkingCopy team = this.getTeam();
        if (team != null) {
            return team.getRoleCast(contributor);
        }
        return null;
    }

    public void setRoleCast(IContributorHandle contributor, IRole[] roleCast) {
        ITeamWorkingCopy team = this.getTeam();
        if (team != null) {
            team.setRoleCast(contributor, roleCast);
        }
    }

    protected void handleWorkingCopyChanged(WorkingCopyChangeEvent event) {
        Boolean newValue;
        if ("dirtyState".equals(event.getProperty()) && (newValue = (Boolean)event.getNewValue()).booleanValue()) {
            this.handlePropertyMarkedAsDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProcessAreaChanged(IProcessArea before, IProcessArea after, IProcessArea shared) {
        if (after == null) {
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "underlyingObject", before, null));
            return;
        }
        if (!this.isDirty()) {
            Object object = this.fSaveMutex;
            synchronized (object) {
                IProcessArea current = (IProcessArea)this.fCachedTeamRepository.itemManager().getImmutableState((IItem)shared);
                if (!this.fProcessAreaState.sameStateId((IItemHandle)current)) {
                    this.fProcessAreaState = current;
                    this.reinitializeFromProcessArea(this.fProcessAreaState, 0);
                }
            }
        }
    }

    private void reinitializeFromProcessArea(IProcessArea processArea, int flags) {
        if (this.fName != null) {
            this.fName.asyncUpdate(processArea.getName(), this.getUpdateContext());
        }
        if (this.fSummary != null) {
            this.fSummary.asyncUpdate(processArea.getDescription().getSummary(), this.getUpdateContext());
        }
        if (this.fDescription != null) {
            this.fDescription.asyncUpdate(processArea.getDescription().getDetails(), flags, this.getUpdateContext(), null);
        }
        if (this.fTeam != null) {
            this.fTeam.asyncUpdate(new TeamProvider(processArea), flags, this.getUpdateContext(), null);
        }
        if (this.fAdministrators != null) {
            this.fAdministrators.asyncUpdate(new AdministratorProvider(processArea), flags, this.getUpdateContext(), null);
        }
        if (this.fProcessName != null) {
            this.fProcessName.asyncUpdate(processArea.getProcessName(), this.getUpdateContext());
        }
        if (this.fProcessSummary != null) {
            this.fProcessSummary.asyncUpdate(processArea.getProcessSummary(), this.getUpdateContext());
        }
        if (this.fProcessContentURL != null) {
            this.fProcessContentURL.asyncUpdate(processArea.getProcessContentPath(), this.getUpdateContext());
        }
        if (this.fProcessAttachments != null) {
            this.fProcessAttachments.asyncUpdate((IProcessContainer)processArea, flags, this.getUpdateContext(), null);
        }
        this.reinitializeProcessCustomization(processArea, flags);
        this.doReinitializeFromProcessArea(processArea, flags);
    }

    private void reinitializeProcessCustomization(IProcessArea processArea, int flags) {
        IContent customization = (IContent)processArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
        if (customization == null) {
            if (this.fProcessCustomization != null) {
                if (this.fCustomizationState.isCustomized()) {
                    this.fCustomizationState.reset(processArea);
                    this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "processCustomization", Boolean.FALSE, null));
                } else {
                    this.fCustomizationState.reset(processArea);
                }
            }
        } else if (this.fProcessCustomization == null || !this.fCustomizationState.isCustomized()) {
            this.fCustomizationState.reset(processArea);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "processCustomization", null, Boolean.TRUE));
        } else {
            this.fCustomizationState.reset(processArea);
            this.fProcessCustomization.asyncUpdate(customization, flags, this.getUpdateContext(), null);
        }
    }

    protected void doReinitializeFromProcessArea(IProcessArea processArea, int flags) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleContainingProjectAreaChanged(IProjectArea before, IProjectArea after) {
        Object object = this.fSaveMutex;
        synchronized (object) {
            this.doHandleContainingProjectAreaChanged(before, after);
        }
    }

    protected void doHandleContainingProjectAreaChanged(IProjectArea before, IProjectArea after) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTeamMemberChanged(ISharedItemChangeEvent event) {
        IContributor after = (IContributor)event.getAfterState();
        Object object = this.fSaveMutex;
        synchronized (object) {
            if (this.fAdministrators != null) {
                this.fAdministrators.handleContributorChanged(after, this.getUpdateContext(), null);
            }
            if (this.fTeam != null) {
                this.fTeam.handleContributorChanged(after, this.getUpdateContext(), null);
            }
        }
    }

    public void asyncRefresh() {
        UpdateRequest request = new UpdateRequest(Messages.getString("ProcessAreaWorkingCopy.10")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus execute(IUpdateContext context, IProgressMonitor monitor) {
                try {
                    List fetchItems = ProcessAreaWorkingCopy.this.fCachedTeamRepository.itemManager().fetchCompleteItems(ProcessAreaWorkingCopy.this.computeItemsToRefresh(), 1, monitor);
                    for (IItem item : fetchItems) {
                        Object object = ProcessAreaWorkingCopy.this.fSaveMutex;
                        synchronized (object) {
                            if (ProcessAreaWorkingCopy.this.fProcessAreaState.sameItemId((IItemHandle)item)) {
                                ProcessAreaWorkingCopy.this.fProcessAreaState = (IProcessArea)ProcessAreaWorkingCopy.this.fCachedTeamRepository.itemManager().getImmutableState(item);
                                ProcessAreaWorkingCopy.this.markNotDirty();
                                ProcessAreaWorkingCopy.this.reinitializeFromProcessArea(ProcessAreaWorkingCopy.this.fProcessAreaState, 1);
                            }
                        }
                    }
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException x) {
                    if (ProcessAreaWorkingCopy.this.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "com.ibm.team.process.client", 0, x.getMessage(), (Throwable)x);
                }
            }
        };
        ExecUtil.asyncExec(request, this.getUpdateContext(), null);
    }

    protected List computeItemsToRefresh() {
        ArrayList<IItemHandle> items = new ArrayList<IItemHandle>();
        items.add(this.fProcessAreaState.getItemHandle());
        return items;
    }

    protected IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    private class AdministratorProvider
    implements ContributorListWorkingCopy.IContributorProvider {
        private IProcessArea fProcessArea;

        public AdministratorProvider(IProcessArea processArea) {
            this.fProcessArea = processArea;
        }

        public List getContributorHandles() {
            return Arrays.asList(this.fProcessArea.getAdministrators());
        }
    }

    private static class CustomizationState {
        private boolean fCustomizationDiscarded = false;
        private boolean fCustomizationRequested = false;
        private IProcessArea fProcessArea = null;

        public CustomizationState(IProcessArea processArea) {
            this.fProcessArea = processArea;
        }

        public void reset(IProcessArea processArea) {
            this.internalReset();
            this.fProcessArea = processArea;
        }

        private void internalReset() {
            this.fCustomizationDiscarded = false;
            this.fCustomizationRequested = false;
        }

        public boolean isCustomized() {
            return (this.fCustomizationRequested || this.hasCustomization()) && !this.fCustomizationDiscarded;
        }

        private boolean hasCustomization() {
            return this.fProcessArea.getProcessData().get("com.ibm.team.internal.process.settings.xml") != null;
        }

        public void requestCustomization() {
            this.internalReset();
            if (!this.hasCustomization()) {
                this.fCustomizationRequested = true;
            }
        }

        public void discardCustomization() {
            this.internalReset();
            if (this.hasCustomization()) {
                this.fCustomizationDiscarded = true;
            }
        }

        public boolean customizationDiscarded() {
            return this.fCustomizationDiscarded;
        }
    }

    private class SharedItemChangeListener
    implements ISharedItemChangeListener {
        private SharedItemChangeListener() {
        }

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                IItem sharedItem = event.getSharedItem();
                if (sharedItem instanceof IProcessArea) {
                    IProcessArea processArea = (IProcessArea)sharedItem;
                    if (!ProcessCommon.requiredPropertiesSet((IProcessItem)processArea, (int)0)) continue;
                    if (processArea.sameItemId((IItemHandle)ProcessAreaWorkingCopy.this.fProcessAreaState)) {
                        IProcessArea before = (IProcessArea)event.getBeforeState();
                        IProcessArea after = (IProcessArea)event.getAfterState();
                        IProcessArea shared = (IProcessArea)event.getSharedItem();
                        ProcessAreaWorkingCopy.this.handleProcessAreaChanged(before, after, shared);
                        continue;
                    }
                    if (!(sharedItem instanceof IProjectArea)) continue;
                    IProjectArea projectArea = (IProjectArea)sharedItem;
                    IProcessArea shared = ProcessAreaWorkingCopy.this.fProcessAreaState;
                    if (shared == null || !projectArea.sameItemId((IItemHandle)shared.getProjectArea())) continue;
                    IProjectArea before = (IProjectArea)event.getBeforeState();
                    IProjectArea after = (IProjectArea)event.getAfterState();
                    ProcessAreaWorkingCopy.this.handleContainingProjectAreaChanged(before, after);
                    continue;
                }
                if (!(sharedItem instanceof IContributor)) continue;
                ProcessAreaWorkingCopy.this.handleTeamMemberChanged(event);
            }
        }
    }

    private class TeamProvider
    implements TeamWorkingCopy.IContributorAndRoleProvider {
        private IProcessArea fProcessArea;
        private ITeamData fTeamData;

        public TeamProvider(IProcessArea processArea) {
            this.fProcessArea = processArea;
            this.fTeamData = this.fProcessArea.getTeamData();
        }

        public TeamProvider(IProcessArea processArea, ITeamData teamData) {
            this.fProcessArea = processArea;
            this.fTeamData = teamData;
        }

        public IRole[] computeAvailableRoles(IProgressMonitor monitor) throws TeamRepositoryException {
            monitor.beginTask(Messages.getString("ProcessAreaWorkingCopy.0"), 1000);
            try {
                if (ProcessAreaWorkingCopy.this.fCachedService != null) {
                    IClientProcess process = ProcessAreaWorkingCopy.this.fCachedService.getClientProcess(this.fProcessArea, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                    IRole[] iRoleArray = process.getRoles(this.fProcessArea, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                    return iRoleArray;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                monitor.done();
            }
            return new IRole[0];
        }

        public String getRoleData(IContributorHandle contributorHandle) {
            return RolePersistence.getPersistentRoleData((ITeamData)this.fTeamData, (IContributorHandle)contributorHandle);
        }

        public List getContributorHandles() {
            IContributorHandle[] contributorHandles = this.fProcessArea.getMembers();
            return Arrays.asList(contributorHandles);
        }
    }

    private class WorkingCopyListener
    implements IWorkingCopyListener {
        private WorkingCopyListener() {
        }

        public void workingCopyChanged(WorkingCopyChangeEvent event) {
            ProcessAreaWorkingCopy.this.handleWorkingCopyChanged(event);
        }
    }
}

