/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProcessItemsSaveRunnable
extends ProcessRunnable {
    private ProcessClientService fProcessClient;
    private IProcessItem[] fSavedItems;
    protected IProcessItem[] fItemsToSave;

    public ProcessItemsSaveRunnable(IProcessItem[] processItems, ProcessClientService processService) {
        this.fItemsToSave = processItems;
        this.fProcessClient = processService;
    }

    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
        IItemsResponse response = this.fProcessClient.doSaveProcessItems(this.fItemsToSave, monitor);
        IItem[] items = response.getClientItems();
        this.fSavedItems = new IProcessItem[items.length];
        System.arraycopy(items, 0, this.fSavedItems, 0, items.length);
        return response.getOperationReport();
    }

    public IProcessItem[] getSavedItems() {
        return this.fSavedItems;
    }

    public boolean equals(Object obj) {
        IProcessItem[] otherItems;
        if (obj instanceof ProcessItemsSaveRunnable && (otherItems = ((ProcessItemsSaveRunnable)((Object)obj)).fItemsToSave).length == this.fItemsToSave.length) {
            int i = 0;
            while (i < otherItems.length) {
                if (!otherItems[i].sameItemId((IItemHandle)this.fItemsToSave[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

