/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.tar;

import com.ibm.team.internal.repository.rcp.dbhm.CachedDiskBackedHashMap;
import com.ibm.team.internal.repository.rcp.tar.TarEntry;
import com.ibm.team.internal.repository.rcp.tar.TarInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarFile {
    private final RandomAccessFile file;
    private final String name;
    private final Map<String, TarEntry> entries;
    private final Object lock = new Object();
    private final CountDownLatch allDone = new CountDownLatch(1);
    private IOException[] exception = new IOException[1];

    public TarFile(File f, EntryFilter filter) throws IOException {
        this.file = new RandomAccessFile(f, "r");
        try {
            this.name = f.getPath();
            this.entries = this.createEntriesMap();
            RandomAccessFileInputStream entriesInputStream = new RandomAccessFileInputStream(this.file.getChannel(), 0L, this.file.length());
            LoadMap loader = new LoadMap(entriesInputStream, this.lock, this.entries, this.allDone, filter, this.exception);
            Thread backgroundThread = new Thread((Runnable)loader, "TarFile.LoadMap");
            backgroundThread.start();
        }
        catch (IOException e) {
            this.file.close();
            throw e;
        }
        catch (RuntimeException e) {
            this.file.close();
            throw e;
        }
    }

    public TarFile(File f) throws IOException {
        this(f, null);
    }

    public TarFile(String filename, EntryFilter filter) throws IOException {
        this(new File(filename), filter);
    }

    public TarFile(String filename) throws IOException {
        this(new File(filename));
    }

    protected Map<String, TarEntry> createEntriesMap() throws IOException {
        return new CachedDiskBackedHashMap<String, TarEntry>(Math.max(17L, this.file.length() / 2048L));
    }

    public TarEntry getEntry(String name) throws IOException {
        boolean interruptedFlag = Thread.interrupted();
        try {
            TarEntry entry;
            do {
                if ((entry = this.getEntryFromMap(name)) == null) continue;
                TarEntry tarEntry = entry;
                return tarEntry;
            } while (!this.allDone.await(1L, TimeUnit.SECONDS));
            entry = this.getEntryFromMap(name);
            if (entry == null && this.exception[0] != null) {
                throw this.exception[0];
            }
            TarEntry tarEntry = entry;
            return tarEntry;
        }
        finally {
            if (interruptedFlag) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TarEntry getEntryFromMap(String name) {
        Object object = this.lock;
        synchronized (object) {
            TarEntry entry = this.entries.get(name);
            return entry;
        }
    }

    public InputStream getInputStream(TarEntry entry) throws IOException {
        return this.getInputStream(entry.getName());
    }

    public InputStream getInputStream(String name) throws IOException {
        TarEntry entry = this.getEntry(name);
        if (entry == null || !TarInputStream.hasContent(entry)) {
            return null;
        }
        return new RandomAccessFileInputStream(this.file.getChannel(), entry.getOffset(), entry.getOffset() + entry.getSize());
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        boolean interruptedFlag = Thread.interrupted();
        try {
            while (true) {
                try {
                    this.allDone.await();
                }
                catch (InterruptedException interruptedException) {
                    interruptedFlag = true;
                    continue;
                }
                break;
            }
            Object object = this.lock;
            synchronized (object) {
                int size;
                int n = size = this.entries.size();
                return n;
            }
        }
        finally {
            if (interruptedFlag) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void close() throws IOException {
        this.file.close();
    }

    public static interface EntryFilter {
        public boolean skipEntry(TarEntry var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoadMap
    implements Runnable {
        private final InputStream entriesInputStream;
        private final Object lock;
        private final Map<String, TarEntry> entries;
        private final CountDownLatch allDone;
        private final EntryFilter filter;
        private final IOException[] exception;

        public LoadMap(InputStream entriesInputStream, Object lock, Map<String, TarEntry> entries, CountDownLatch allDone, EntryFilter filter, IOException[] exception) {
            this.entriesInputStream = entriesInputStream;
            this.lock = lock;
            this.entries = entries;
            this.allDone = allDone;
            this.exception = exception;
            this.filter = filter != null ? filter : new EntryFilter(){

                public boolean skipEntry(TarEntry entry) {
                    return false;
                }
            };
        }

        @Override
        public void run() {
            try {
                try {
                    this.loadMap();
                }
                catch (IOException ex) {
                    this.exception[0] = ex;
                    this.allDone.countDown();
                }
            }
            finally {
                this.allDone.countDown();
            }
        }

        /*
         * Exception decompiling
         */
        private void loadMap() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class RandomAccessFileInputStream
    extends InputStream {
        private final FileChannel channel;
        private long offset;
        private final long maxOffset;
        private boolean closed;
        private final byte[] ONE_BYTE_BUF = new byte[1];

        public RandomAccessFileInputStream(FileChannel fileChannel, long startOffset, long maxOffset) {
            if (startOffset < 0L || maxOffset < 0L || startOffset > maxOffset) {
                throw new IllegalArgumentException();
            }
            this.channel = fileChannel;
            this.offset = startOffset;
            this.maxOffset = maxOffset;
        }

        public int read() throws IOException {
            this.checkClosed();
            if (this.offset >= this.maxOffset) {
                return -1;
            }
            try {
                int bytesRead;
                ByteBuffer buf = ByteBuffer.wrap(this.ONE_BYTE_BUF);
                while ((bytesRead = this.channel.read(buf, this.offset)) == 0) {
                }
                if (bytesRead == -1) {
                    return -1;
                }
            }
            catch (InterruptedIOException e) {
                this.offset += (long)e.bytesTransferred;
                throw e;
            }
            ++this.offset;
            return this.ONE_BYTE_BUF[0] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead;
            block4: {
                this.checkClosed();
                if (this.offset >= this.maxOffset) {
                    return -1;
                }
                try {
                    ByteBuffer buf = ByteBuffer.wrap(b, off, (int)Math.min((long)len, this.maxOffset - this.offset));
                    bytesRead = this.channel.read(buf, this.offset);
                    if (bytesRead != -1) break block4;
                    return -1;
                }
                catch (InterruptedIOException e) {
                    this.offset += (long)e.bytesTransferred;
                    throw e;
                }
            }
            this.offset += (long)bytesRead;
            return bytesRead;
        }

        public int available() throws IOException {
            this.checkClosed();
            return (int)Math.min(Integer.MAX_VALUE, this.maxOffset - this.offset);
        }

        public void close() throws IOException {
            this.closed = true;
        }

        public long skip(long n) throws IOException {
            this.checkClosed();
            if (n <= 0L) {
                return 0L;
            }
            long skipped = Math.min(n, this.maxOffset - this.offset);
            this.offset += skipped;
            return skipped;
        }

        private void checkClosed() throws IOException {
            if (this.closed) {
                throw new IOException("The stream has been closed");
            }
        }
    }
}

