/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.InputStream;

public class UnsynchronizedByteArrayInputStream
extends InputStream {
    private byte[] buf;
    private int pos;
    private int limit;
    private int mark;

    public UnsynchronizedByteArrayInputStream(byte[] buf) {
        this.buf = buf;
        this.limit = buf.length;
    }

    public UnsynchronizedByteArrayInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.limit = offset + length;
        this.mark = offset;
    }

    public int read() {
        if (this.pos == this.limit) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) {
        if (this.limit == this.pos) {
            return -1;
        }
        int bytesRead = Math.min(len, this.limit - this.pos);
        System.arraycopy(this.buf, this.pos, b, off, bytesRead);
        this.pos += bytesRead;
        return bytesRead;
    }

    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        int bytesSkipped = (int)Math.min(n, (long)(this.limit - this.pos));
        this.pos += bytesSkipped;
        return bytesSkipped;
    }

    public int available() {
        return this.limit - this.pos;
    }

    public void close() {
    }

    public void mark(int readlimit) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }

    public boolean markSupported() {
        return true;
    }
}

