/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends OutputStream {
    protected final OutputStream[] out;

    public TeeOutputStream(OutputStream[] out) {
        if (out == null) {
            throw new IllegalArgumentException();
        }
        if (out.length == 0) {
            throw new IllegalArgumentException();
        }
        int i = out.length;
        while (i != 0) {
            if (out[--i] != null) continue;
            throw new IllegalArgumentException();
        }
        this.out = out;
    }

    public void write(int b) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].write(b, off, len);
        }
    }

    public void flush() throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].flush();
        }
    }

    public void close() throws IOException {
        Exception firstException = null;
        int i = this.out.length;
        while (i != 0) {
            --i;
            try {
                this.out[i].close();
            }
            catch (Exception e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            if (firstException instanceof RuntimeException) {
                throw (RuntimeException)firstException;
            }
            throw (IOException)firstException;
        }
    }
}

