/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class DigestComputingInputStream
extends InputStream {
    private MessageDigest liveDigest;
    private MessageDigest markDigest;
    private final InputStream in;
    private long liveSize;
    private long markSize;
    private int markSupported;

    public DigestComputingInputStream(InputStream in, MessageDigest digest) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        if (digest == null) {
            throw new IllegalArgumentException();
        }
        this.in = in;
        this.liveDigest = digest;
    }

    public int read() throws IOException {
        int byteRead = this.in.read();
        if (byteRead != -1) {
            this.liveDigest.update((byte)byteRead);
            ++this.liveSize;
        }
        return byteRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (bytesRead > 0) {
            this.liveDigest.update(b, off, bytesRead);
            this.liveSize += (long)bytesRead;
        }
        return bytesRead;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public byte[] getIntermediateDigest() throws IOException {
        try {
            return ((MessageDigest)this.liveDigest.clone()).digest();
        }
        catch (CloneNotSupportedException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public byte[] getFinalDigest() {
        MessageDigest d = this.liveDigest;
        this.liveDigest = null;
        return d.digest();
    }

    public long getContentSize() {
        return this.liveSize;
    }

    public MessageDigest getLiveDigest() {
        return this.liveDigest;
    }

    public void mark(int readlimit) {
        try {
            MessageDigest newMarkDigest = (MessageDigest)this.liveDigest.clone();
            this.in.mark(readlimit);
            this.markDigest = newMarkDigest;
            this.markSize = this.liveSize;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
    }

    public boolean markSupported() {
        if (!this.in.markSupported()) {
            return false;
        }
        if (this.markSupported == 0) {
            try {
                this.liveDigest.clone();
                this.markSupported = 1;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.markSupported = -1;
            }
        }
        return this.markSupported == 1;
    }

    public void reset() throws IOException {
        if (this.markDigest == null) {
            throw new IOException("Never called mark()");
        }
        this.in.reset();
        try {
            this.liveDigest = (MessageDigest)this.markDigest.clone();
        }
        catch (CloneNotSupportedException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        this.liveSize = this.markSize;
    }
}

