/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.dbhm;

import com.ibm.team.internal.repository.rcp.dbhm.NextFitHeap;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayInputStream;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayOutputStream;
import com.ibm.team.internal.repository.rcp.util.FileChannelUtil;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

public class PersistentNextFitHeap
extends NextFitHeap {
    private static final long MAGIC = -2401053090827371910L;
    private static final int HEAP_TRAILER_SIZE = 20;
    protected boolean mustWriteTrailer;
    protected byte[] originalPersistedBytes;
    protected byte[] bytesToPersist;
    protected boolean closed;
    protected long origFirstFreeBlock;
    protected long origWorkingAreaSize;

    public PersistentNextFitHeap(String path) throws IOException {
        this(new File(path));
    }

    public PersistentNextFitHeap(File f) throws IOException {
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        this.raf = new RAFWrapper(f, "rw");
        long len = FileChannelUtil.getLengthUninterrupted(this.raf);
        if (len != 0L) {
            if (len < 20L) {
                throw new IllegalArgumentException("Not a heap file");
            }
            long offset = len - 20L;
            byte[] buf = new byte[20];
            this.readFully(buf, offset);
            DataInputStream in = new DataInputStream(new UnsynchronizedByteArrayInputStream(buf));
            if (in.readLong() != -2401053090827371910L) {
                throw new IllegalArgumentException("Not a heap file");
            }
            this.origFirstFreeBlock = this.firstFreeBlock = in.readLong();
            int dataLen = in.readInt();
            if ((long)dataLen > offset || dataLen < 0) {
                throw new IllegalArgumentException("Invalid persisted bytes length");
            }
            this.origWorkingAreaSize = this.workingAreaSize = offset - (long)dataLen;
            buf = new byte[dataLen];
            if (dataLen != 0) {
                this.readFully(buf, this.workingAreaSize);
            }
            this.originalPersistedBytes = buf;
        } else {
            this.mustWriteTrailer = true;
            this.originalPersistedBytes = new byte[0];
        }
        this.bytesToPersist = this.originalPersistedBytes;
    }

    protected long allocateAtEnd(long size) throws IOException {
        this.mustWriteTrailer = true;
        return super.allocateAtEnd(size);
    }

    public void close() throws IOException {
        this.persist();
        this.raf.getFile().close();
        this.closed = true;
    }

    public void persist() throws IOException {
        if (this.mustWriteTrailer || this.persistedBytesChanged() || this.metaDataChanged()) {
            UnsynchronizedByteArrayOutputStream bOut = new UnsynchronizedByteArrayOutputStream(20 + this.bytesToPersist.length);
            DataOutputStream out = new DataOutputStream(bOut);
            out.write(this.bytesToPersist);
            out.writeLong(-2401053090827371910L);
            out.writeLong(this.firstFreeBlock);
            out.writeInt(this.bytesToPersist.length);
            out.flush();
            this.writeFully(bOut.toByteArray(), this.workingAreaSize);
            FileChannelUtil.setLengthUninterrupted(this.raf, this.workingAreaSize + 20L + (long)this.bytesToPersist.length);
            this.mustWriteTrailer = false;
            this.writtenMetaData();
            this.writtenBytesChanged();
        }
    }

    protected void writtenBytesChanged() {
        this.originalPersistedBytes = this.bytesToPersist;
    }

    protected boolean persistedBytesChanged() {
        if (this.bytesToPersist == this.originalPersistedBytes) {
            return false;
        }
        if (this.bytesToPersist.length != this.originalPersistedBytes.length) {
            return true;
        }
        int i = this.bytesToPersist.length - 1;
        while (i >= 0) {
            if (this.bytesToPersist[i] != this.originalPersistedBytes[i]) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected void writtenMetaData() {
        this.origFirstFreeBlock = this.firstFreeBlock;
        this.origWorkingAreaSize = this.workingAreaSize;
    }

    protected boolean metaDataChanged() {
        return this.firstFreeBlock != this.origFirstFreeBlock || this.workingAreaSize != this.origWorkingAreaSize;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
        super.finalize();
    }

    public byte[] getPersistedData() {
        byte[] copy = new byte[this.originalPersistedBytes.length];
        System.arraycopy(this.originalPersistedBytes, 0, copy, 0, copy.length);
        return copy;
    }

    public void setPersistedData(byte[] toPersist) {
        this.bytesToPersist = new byte[toPersist.length];
        System.arraycopy(toPersist, 0, this.bytesToPersist, 0, toPersist.length);
    }
}

