/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.dbhm;

import com.ibm.team.internal.repository.rcp.dbhm.BTree;
import com.ibm.team.internal.repository.rcp.dbhm.BTreeAllocator;
import com.ibm.team.internal.repository.rcp.dbhm.ByteBTreeComparator;
import com.ibm.team.internal.repository.rcp.util.FileChannelUtil;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;

public class BTreeHeap
implements BTreeAllocator {
    public static final long NULL = -1L;
    protected static final int MIN_SIZE = 8;
    protected static final int HEADER_SIZE = 9;
    protected static final int TRAILER_SIZE = 8;
    protected static final int DISK_BLOCK_SIZE = 8192;
    protected static final int KEY_SIZE = 16;
    protected RAFWrapper raf;
    protected long workingAreaSize;
    protected BTree freeTable;
    protected SortedSet<Long> freeBlocks;

    protected BTreeHeap() throws IOException {
    }

    public BTreeHeap(File f) throws IOException {
        this.init(f);
    }

    protected void init(File f) throws IOException {
        this.doInit(f);
        this.clear();
    }

    protected void doInit(File f) throws IOException {
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        this.raf = new RAFWrapper(f, "rw");
    }

    public void clear() throws IOException {
        this.workingAreaSize = 0L;
        this.freeTable = this.getBTreeImpl();
        this.freeBlocks = new TreeSet<Long>();
    }

    public long allocateNode(int size) throws IOException {
        if (!this.freeBlocks.isEmpty()) {
            Iterator i = this.freeBlocks.iterator();
            long offset = (Long)i.next();
            i.remove();
            return offset;
        }
        if (size < 8) {
            size = 8;
        }
        return this.allocateAtEnd(size);
    }

    public void freeNode(long location) throws IOException {
        this.freeBlocks.add(location);
    }

    protected void performBTreeFrees() throws IOException {
        while (!this.freeBlocks.isEmpty()) {
            Long offset = this.freeBlocks.last();
            this.freeBlocks.remove(offset);
            this.doFree(offset);
        }
    }

    protected BTree getBTreeImpl() throws IOException {
        return new BTree(16, 8192, ByteBTreeComparator.CMP, this, this.raf);
    }

    public long allocate(long size) throws IOException {
        long result = this.doAllocate(size);
        this.performBTreeFrees();
        return result;
    }

    protected long doAllocate(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        if (size < 8L) {
            size = 8L;
        }
        byte[] byArray = new byte[16];
        byArray[0] = (byte)(size >> 56 & 0xFFL);
        byArray[1] = (byte)(size >> 48 & 0xFFL);
        byArray[2] = (byte)(size >> 40 & 0xFFL);
        byArray[3] = (byte)(size >> 32 & 0xFFL);
        byArray[4] = (byte)(size >> 24 & 0xFFL);
        byArray[5] = (byte)(size >> 16 & 0xFFL);
        byArray[6] = (byte)(size >> 8 & 0xFFL);
        byArray[7] = (byte)(size & 0xFFL);
        byte[] min_value = byArray;
        byte[] value = this.freeTable.removeGreaterOrEqual(min_value);
        if (value != null) {
            long blocksize = ((long)value[0] & 0xFFL) << 56 | ((long)value[1] & 0xFFL) << 48 | ((long)value[2] & 0xFFL) << 40 | ((long)value[3] & 0xFFL) << 32 | ((long)value[4] & 0xFFL) << 24 | (long)((value[5] & 0xFF) << 16) | (long)((value[6] & 0xFF) << 8) | (long)(value[7] & 0xFF);
            long offset = ((long)value[8] & 0xFFL) << 56 | ((long)value[9] & 0xFFL) << 48 | ((long)value[10] & 0xFFL) << 40 | ((long)value[11] & 0xFFL) << 32 | ((long)value[12] & 0xFFL) << 24 | (long)((value[13] & 0xFF) << 16) | (long)((value[14] & 0xFF) << 8) | (long)(value[15] & 0xFF);
            return this.allocateAt(offset, blocksize, size);
        }
        return this.allocateAtEnd(size);
    }

    protected long allocateAtEnd(long size) throws IOException {
        long offset = this.workingAreaSize + 9L;
        ByteBuffer buf = ByteBuffer.allocate(9);
        buf.put((byte)3);
        buf.putLong(size);
        buf.rewind();
        this.writeFully(buf, this.workingAreaSize);
        this.workingAreaSize += size + 9L;
        return offset;
    }

    protected void writeFully(ByteBuffer buf, long position) throws IOException {
        FileChannelUtil.writeFully(buf, position, this.raf, false);
    }

    protected void readFully(ByteBuffer buf, long position) throws IOException {
        FileChannelUtil.readFully(buf, position, this.raf, false);
    }

    protected long allocateAt(long position, long blockSize, long size) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(9);
        if (size + 9L + 8L <= blockSize) {
            long newSize = blockSize - size - 9L;
            long freeOffset = position + 9L + size;
            blockSize = size;
            buf.put((byte)1);
            buf.putLong(newSize);
            buf.rewind();
            this.writeFully(buf, freeOffset);
            buf.rewind();
            buf.limit(8);
            buf.putLong(newSize);
            buf.rewind();
            this.writeFully(buf, freeOffset + newSize + 1L);
            this.addToFree(newSize, freeOffset);
        } else {
            buf.limit(1);
            buf.put((byte)3);
            buf.rewind();
            this.writeFully(buf, position + blockSize + 9L);
        }
        buf.rewind();
        buf.limit(9);
        buf.put((byte)3);
        buf.putLong(blockSize);
        buf.rewind();
        this.writeFully(buf, position);
        return position + 9L;
    }

    protected void removeFromFree(long offset, long size) throws IOException {
        byte[] allocated_value = new byte[]{(byte)(size >> 56 & 0xFFL), (byte)(size >> 48 & 0xFFL), (byte)(size >> 40 & 0xFFL), (byte)(size >> 32 & 0xFFL), (byte)(size >> 24 & 0xFFL), (byte)(size >> 16 & 0xFFL), (byte)(size >> 8 & 0xFFL), (byte)(size & 0xFFL), (byte)(offset >> 56 & 0xFFL), (byte)(offset >> 48 & 0xFFL), (byte)(offset >> 40 & 0xFFL), (byte)(offset >> 32 & 0xFFL), (byte)(offset >> 24 & 0xFFL), (byte)(offset >> 16 & 0xFFL), (byte)(offset >> 8 & 0xFFL), (byte)(offset & 0xFFL)};
        byte[] removed = this.freeTable.removeGreaterOrEqual(allocated_value);
        Assert.isTrue((boolean)Arrays.equals(allocated_value, removed));
    }

    protected void addToFree(long size, long offset) throws IOException {
        byte[] allocated_value = new byte[]{(byte)(size >> 56 & 0xFFL), (byte)(size >> 48 & 0xFFL), (byte)(size >> 40 & 0xFFL), (byte)(size >> 32 & 0xFFL), (byte)(size >> 24 & 0xFFL), (byte)(size >> 16 & 0xFFL), (byte)(size >> 8 & 0xFFL), (byte)(size & 0xFFL), (byte)(offset >> 56 & 0xFFL), (byte)(offset >> 48 & 0xFFL), (byte)(offset >> 40 & 0xFFL), (byte)(offset >> 32 & 0xFFL), (byte)(offset >> 24 & 0xFFL), (byte)(offset >> 16 & 0xFFL), (byte)(offset >> 8 & 0xFFL), (byte)(offset & 0xFFL)};
        this.freeTable.insert(allocated_value);
    }

    protected void finalize() throws Throwable {
        if (this.raf != null) {
            try {
                this.raf.getFile().close();
            }
            catch (IOException iOException) {}
        }
        super.finalize();
    }

    public void free(long offset) throws IOException {
        if (offset == -1L) {
            return;
        }
        this.doFree(offset);
        this.performBTreeFrees();
    }

    protected void doFree(long offset) throws IOException {
        long nextBlockOffset;
        boolean predecessorFree;
        long size;
        byte status;
        long predecessorSize;
        ByteBuffer buf = ByteBuffer.allocate(17);
        if ((offset -= 9L) != 0L) {
            this.readFully(buf, offset - 8L);
            buf.rewind();
            predecessorSize = buf.getLong();
            status = buf.get();
            size = buf.getLong();
        } else {
            predecessorSize = -1L;
            buf.limit(9);
            this.readFully(buf, offset);
            buf.rewind();
            status = buf.get();
            size = buf.getLong();
        }
        if ((status & 2) == 0) {
            throw new IllegalStateException();
        }
        if ((status & 0xFFFFFFFC) != 0) {
            throw new IllegalStateException();
        }
        boolean bl = predecessorFree = (status & 1) == 0;
        if (predecessorFree) {
            long predecessorOffset = offset - predecessorSize - 9L;
            this.removeFromFree(predecessorOffset, predecessorSize);
            offset = predecessorOffset;
            size += predecessorSize + 9L;
        }
        if ((nextBlockOffset = offset + 9L + size) == this.workingAreaSize) {
            this.workingAreaSize = offset;
        } else {
            boolean successorFree;
            buf.rewind();
            buf.limit(9);
            this.readFully(buf, nextBlockOffset);
            buf.rewind();
            byte nextStatus = buf.get();
            long nextSize = buf.getLong();
            if ((nextStatus & 1) == 0) {
                String value = Integer.toString(nextStatus);
                throw new IllegalStateException(value);
            }
            if ((status & 0xFFFFFFFC) != 0) {
                throw new IllegalStateException();
            }
            boolean bl2 = successorFree = (nextStatus & 2) == 0;
            if (successorFree) {
                this.removeFromFree(nextBlockOffset, nextSize);
                size += nextSize + 9L;
            }
            buf.rewind();
            if (predecessorFree) {
                buf.limit(8);
                buf.putLong(size);
                buf.rewind();
                this.writeFully(buf, offset + 1L);
            } else if (successorFree) {
                buf.limit(9);
                buf.put((byte)1);
                buf.putLong(size);
                buf.rewind();
                this.writeFully(buf, offset);
            } else {
                buf.limit(1);
                buf.put((byte)1);
                buf.rewind();
                this.writeFully(buf, offset);
            }
            buf.rewind();
            buf.limit(9);
            buf.putLong(size);
            buf.put((byte)2);
            buf.rewind();
            this.writeFully(buf, offset + size + 1L);
            this.addToFree(size, offset);
        }
    }

    public InputStream getInputStream(long offset) {
        return new FileHeapInputStream(offset);
    }

    public OutputStream getOutputStream(long offset) {
        return new FileHeapOutputStream(offset);
    }

    protected class FileHeapInputStream
    extends InputStream {
        protected ByteBuffer ONE_BYTE_BUF;
        protected long readOffset;

        public FileHeapInputStream(long offset) {
            this.readOffset = offset;
        }

        public int read() throws IOException {
            int bytesRead;
            if (this.ONE_BYTE_BUF == null) {
                this.ONE_BYTE_BUF = ByteBuffer.allocate(1);
            } else {
                this.ONE_BYTE_BUF.rewind();
            }
            try {
                while ((bytesRead = FileChannelUtil.readUninterrupted(this.ONE_BYTE_BUF, this.readOffset, BTreeHeap.this.raf)) == 0) {
                }
            }
            finally {
                this.readOffset += (long)this.ONE_BYTE_BUF.position();
            }
            if (bytesRead == -1) {
                return -1;
            }
            return this.ONE_BYTE_BUF.get(0) & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            try {
                int n = FileChannelUtil.readUninterrupted(buf, this.readOffset, BTreeHeap.this.raf);
                return n;
            }
            finally {
                this.readOffset += (long)(buf.position() - off);
            }
        }

        public long skip(long n) throws IOException {
            n = Math.min(n, FileChannelUtil.getLengthUninterrupted(BTreeHeap.this.raf) - this.readOffset);
            this.readOffset += n;
            return n;
        }
    }

    protected class FileHeapOutputStream
    extends OutputStream {
        protected ByteBuffer ONE_BYTE_BUF;
        protected long writeOffset;

        public FileHeapOutputStream(long offset) {
            this.writeOffset = offset;
        }

        public void write(int b) throws IOException {
            if (this.ONE_BYTE_BUF == null) {
                this.ONE_BYTE_BUF = ByteBuffer.allocate(1);
            } else {
                this.ONE_BYTE_BUF.rewind();
            }
            this.ONE_BYTE_BUF.put((byte)b);
            this.ONE_BYTE_BUF.rewind();
            try {
                BTreeHeap.this.writeFully(this.ONE_BYTE_BUF, this.writeOffset);
                ++this.writeOffset;
            }
            catch (IOException e) {
                this.writeOffset += (long)this.ONE_BYTE_BUF.position();
                throw e;
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            try {
                BTreeHeap.this.writeFully(buf, this.writeOffset);
                this.writeOffset += (long)len;
            }
            catch (IOException e) {
                this.writeOffset += (long)(buf.position() - off);
                throw e;
            }
        }
    }
}

